/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.remoting;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.security.remoting.RemotingConnectionCredential;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.wildfly.security.auth.server.SecurityIdentity;

public class RemotingLoginModule
extends AbstractServerLoginModule {
    private static final String USE_CLIENT_CERT_OPTION = "useClientCert";
    private static final String USE_NEW_CLIENT_CERT_OPTION = "useNewClientCert";
    private static final String[] ALL_OPTIONS = new String[]{"useClientCert", "useNewClientCert"};
    private boolean useClientCert = false;
    private boolean useNewClientCert = false;
    private Principal identity;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        if (options.containsKey(USE_CLIENT_CERT_OPTION)) {
            this.useClientCert = Boolean.parseBoolean(options.get(USE_CLIENT_CERT_OPTION).toString());
        }
        if (options.containsKey(USE_NEW_CLIENT_CERT_OPTION)) {
            this.useNewClientCert = Boolean.parseBoolean(options.get(USE_NEW_CLIENT_CERT_OPTION).toString());
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (super.login()) {
            this.log.debug("super.login()==true");
            return true;
        }
        Object credential = this.getCredential();
        if (credential instanceof RemotingConnectionCredential) {
            RemotingConnectionCredential remotingConnectionCredential = (RemotingConnectionCredential)credential;
            SecurityIdentity localIdentity = remotingConnectionCredential.getSecurityIdentity();
            this.identity = new RealmUser(localIdentity.getPrincipal().getName());
            if (this.getUseFirstPass()) {
                SSLSession session;
                String userName = this.identity.getName();
                this.log.debugf("Storing username '%s'", (Object)userName);
                this.sharedState.put("javax.security.auth.login.name", this.identity);
                if (this.useNewClientCert) {
                    SSLSession session2 = remotingConnectionCredential.getSSLSession();
                    if (session2 != null) {
                        try {
                            credential = session2.getPeerCertificates()[0];
                            this.log.debug("Using new certificate as credential.");
                        }
                        catch (SSLPeerUnverifiedException e) {
                            this.log.debugf("No peer certificate available for '%s'", (Object)userName);
                        }
                    }
                } else if (this.useClientCert && (session = remotingConnectionCredential.getSSLSession()) != null) {
                    try {
                        credential = session.getPeerCertificateChain()[0];
                        this.log.debug("Using certificate as credential.");
                    }
                    catch (SSLPeerUnverifiedException e) {
                        this.log.debugf("No peer certificate available for '%s'", (Object)userName);
                    }
                }
                this.sharedState.put("javax.security.auth.login.password", credential);
            }
            this.loginOk = true;
            return true;
        }
        return false;
    }

    protected Object getCredential() throws LoginException {
        NameCallback nc = new NameCallback("Alias: ");
        ObjectCallback oc = new ObjectCallback("Credential: ");
        Callback[] callbacks = new Callback[]{nc, oc};
        try {
            this.callbackHandler.handle(callbacks);
            return oc.getCredential();
        }
        catch (IOException ioe) {
            LoginException le = new LoginException();
            le.initCause(ioe);
            throw le;
        }
        catch (UnsupportedCallbackException uce) {
            LoginException le = new LoginException();
            le.initCause(uce);
            throw le;
        }
    }

    @Override
    protected Principal getIdentity() {
        return this.identity;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        SimpleGroup callerPrincipal = new SimpleGroup("CallerPrincipal");
        Group[] groups = new Group[]{roles, callerPrincipal};
        callerPrincipal.addMember(this.getIdentity());
        return groups;
    }
}

