/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.remoting.RemoteConnection;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetModuleClassLoaderAction;

class SecurityActions {
    SecurityActions() {
    }

    static ModuleClassLoader getModuleClassLoader(String moduleSpec) throws ModuleLoadException {
        ModuleLoader loader = Module.getCallerModuleLoader();
        Module module = loader.loadModule(ModuleIdentifier.fromString(moduleSpec));
        GetModuleClassLoaderAction action = new GetModuleClassLoaderAction(module);
        return WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(action) : action.run();
    }

    static Class<?> loadClass(String name) throws ClassNotFoundException {
        return SecurityActions.classLoaderActions().loadClass(name);
    }

    static ClassLoader setThreadContextClassLoader(ClassLoader toSet) {
        return SecurityActions.classLoaderActions().setThreadContextClassLoader(toSet);
    }

    private static ClassLoaderActions classLoaderActions() {
        return WildFlySecurityManager.isChecking() ? ClassLoaderActions.PRIVILEGED : ClassLoaderActions.NON_PRIVILEGED;
    }

    static void remotingContextClear() {
        SecurityActions.remotingContextAccociationActions().clear();
    }

    static RemoteConnection remotingContextGetConnection() {
        return SecurityActions.remotingContextAccociationActions().getConnection();
    }

    static boolean remotingContextIsSet() {
        return SecurityActions.remotingContextAccociationActions().isSet();
    }

    private static RemotingContextAssociationActions remotingContextAccociationActions() {
        return !WildFlySecurityManager.isChecking() ? RemotingContextAssociationActions.NON_PRIVILEGED : RemotingContextAssociationActions.PRIVILEGED;
    }

    private static interface RemotingContextAssociationActions {
        public static final RemotingContextAssociationActions NON_PRIVILEGED = new RemotingContextAssociationActions(){

            @Override
            public boolean isSet() {
                return RemotingContext.isSet();
            }

            @Override
            public RemoteConnection getConnection() {
                return RemotingContext.getRemoteConnection();
            }

            @Override
            public void clear() {
                RemotingContext.clear();
            }
        };
        public static final RemotingContextAssociationActions PRIVILEGED = new RemotingContextAssociationActions(){
            private final PrivilegedAction<Boolean> IS_SET_ACTION = new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return NON_PRIVILEGED.isSet();
                }
            };
            private final PrivilegedAction<RemoteConnection> GET_CONNECTION_ACTION = new PrivilegedAction<RemoteConnection>(){

                @Override
                public RemoteConnection run() {
                    return NON_PRIVILEGED.getConnection();
                }
            };
            private final PrivilegedAction<Void> CLEAR_ACTION = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    NON_PRIVILEGED.clear();
                    return null;
                }
            };

            @Override
            public boolean isSet() {
                return AccessController.doPrivileged(this.IS_SET_ACTION);
            }

            @Override
            public RemoteConnection getConnection() {
                return AccessController.doPrivileged(this.GET_CONNECTION_ACTION);
            }

            @Override
            public void clear() {
                AccessController.doPrivileged(this.CLEAR_ACTION);
            }
        };

        public RemoteConnection getConnection();

        public boolean isSet();

        public void clear();
    }

    private static interface ClassLoaderActions {
        public static final ClassLoaderActions NON_PRIVILEGED = new ClassLoaderActions(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                ClassLoader[] cls = new ClassLoader[]{SecurityActions.class.getClassLoader(), WildFlySecurityManager.getCurrentContextClassLoaderPrivileged(), ClassLoader.getSystemClassLoader()};
                ClassNotFoundException e = null;
                for (ClassLoader cl : cls) {
                    if (cl == null) continue;
                    try {
                        return cl.loadClass(name);
                    }
                    catch (ClassNotFoundException ce) {
                        e = ce;
                    }
                }
                throw e != null ? e : SecurityLogger.ROOT_LOGGER.cnfe(name);
            }

            @Override
            public ClassLoader setThreadContextClassLoader(ClassLoader toSet) {
                Thread currentThread = Thread.currentThread();
                ClassLoader previous = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(toSet);
                return previous;
            }
        };
        public static final ClassLoaderActions PRIVILEGED = new ClassLoaderActions(){

            @Override
            public Class<?> loadClass(final String name) throws ClassNotFoundException {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                        @Override
                        public Class<?> run() throws Exception {
                            return NON_PRIVILEGED.loadClass(name);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception cause = e.getException();
                    if (cause instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException(cause);
                }
            }

            @Override
            public ClassLoader setThreadContextClassLoader(final ClassLoader toSet) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return NON_PRIVILEGED.setThreadContextClassLoader(toSet);
                    }
                });
            }
        };

        public Class<?> loadClass(String var1) throws ClassNotFoundException;

        public ClassLoader setThreadContextClassLoader(ClassLoader var1);
    }
}

