/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.plugins.JNDIBasedSecurityManagement;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.ISecurityManagement;
import org.picketbox.factories.SecurityFactory;

public class SecurityManagementService
implements Service<ISecurityManagement> {
    public static final ServiceName SERVICE_NAME = SecurityExtension.JBOSS_SECURITY.append("security-management");
    private final String authenticationManagerClassName;
    private final boolean deepCopySubjectMode;
    private final String callbackHandlerClassName;
    private final String authorizationManagerClassName;
    private final String auditManagerClassName;
    private final String identityTrustManagerClassName;
    private final String mappingManagerClassName;
    private volatile ISecurityManagement previousSecurityManagement;
    private volatile ISecurityManagement securityManagement;
    private final InjectedValue<ServiceModuleLoader> serviceModuleLoaderValue = new InjectedValue();

    public SecurityManagementService(String authenticationManagerClassName, boolean deepCopySubjectMode, String callbackHandlerClassName, String authorizationManagerClassName, String auditManagerClassName, String identityTrustManagerClassName, String mappingManagerClassName) {
        this.authenticationManagerClassName = authenticationManagerClassName;
        this.deepCopySubjectMode = deepCopySubjectMode;
        this.callbackHandlerClassName = callbackHandlerClassName;
        this.authorizationManagerClassName = authorizationManagerClassName;
        this.auditManagerClassName = auditManagerClassName;
        this.identityTrustManagerClassName = identityTrustManagerClassName;
        this.mappingManagerClassName = mappingManagerClassName;
    }

    @Override
    public void start(StartContext context) throws StartException {
        SecurityLogger.ROOT_LOGGER.debugf("Starting SecurityManagementService", new Object[0]);
        JNDIBasedSecurityManagement securityManagement = new JNDIBasedSecurityManagement((ModuleLoader)this.serviceModuleLoaderValue.getValue());
        securityManagement.setAuthenticationManagerClassName(this.authenticationManagerClassName);
        securityManagement.setDeepCopySubjectMode(this.deepCopySubjectMode);
        securityManagement.setCallbackHandlerClassName(this.callbackHandlerClassName);
        securityManagement.setAuthorizationManagerClassName(this.authorizationManagerClassName);
        securityManagement.setAuditManagerClassName(this.auditManagerClassName);
        securityManagement.setIdentityTrustManagerClassName(this.identityTrustManagerClassName);
        securityManagement.setMappingManagerClassName(this.mappingManagerClassName);
        this.securityManagement = securityManagement;
        this.previousSecurityManagement = SecurityFactory.getSecurityManagement();
        SecurityFactory.setSecurityManagement(securityManagement);
    }

    @Override
    public void stop(StopContext context) {
        SecurityFactory.setSecurityManagement(this.previousSecurityManagement);
    }

    @Override
    public ISecurityManagement getValue() throws IllegalStateException {
        return this.securityManagement;
    }

    public Injector<ServiceModuleLoader> getServiceModuleLoaderInjectedValue() {
        return this.serviceModuleLoaderValue;
    }
}

