/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wscf.model.sagas.arjunacore;

import com.arjuna.mw.wsas.UserActivityFactory;
import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.activity.Outcome;
import com.arjuna.mw.wsas.completionstatus.Failure;
import com.arjuna.mw.wsas.completionstatus.FailureOnly;
import com.arjuna.mw.wsas.completionstatus.Success;
import com.arjuna.mw.wsas.exceptions.ActiveChildException;
import com.arjuna.mw.wsas.exceptions.InvalidActivityException;
import com.arjuna.mw.wsas.exceptions.InvalidTimeoutException;
import com.arjuna.mw.wsas.exceptions.NoActivityException;
import com.arjuna.mw.wsas.exceptions.NoPermissionException;
import com.arjuna.mw.wsas.exceptions.ProtocolViolationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wsas.status.NoActivity;
import com.arjuna.mw.wsas.status.Status;
import com.arjuna.mw.wscf.common.CoordinatorId;
import com.arjuna.mw.wscf.exceptions.DuplicateParticipantException;
import com.arjuna.mw.wscf.exceptions.InvalidParticipantException;
import com.arjuna.mw.wscf.exceptions.NoCoordinatorException;
import com.arjuna.mw.wscf.logging.wscfLogger;
import com.arjuna.mw.wscf.model.sagas.api.CoordinatorManager;
import com.arjuna.mw.wscf.model.sagas.api.UserCoordinator;
import com.arjuna.mw.wscf.model.sagas.exceptions.CoordinatorCancelledException;
import com.arjuna.mw.wscf.model.sagas.exceptions.CoordinatorConfirmedException;
import com.arjuna.mw.wscf.model.sagas.outcomes.CoordinationOutcome;
import com.arjuna.mw.wscf.model.sagas.participants.Participant;
import com.arjuna.mwlabs.wsas.UserActivityImple;
import com.arjuna.mwlabs.wsas.activity.ActivityImple;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.BACoordinator;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.CoordinatorControl;

public class CoordinatorServiceImple
implements UserCoordinator,
CoordinatorManager {
    private CoordinatorControl _coordManager;

    public CoordinatorServiceImple() {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + " constructor"));
        }
        this._coordManager = new CoordinatorControl();
    }

    @Override
    public void begin(String coordinationType) throws WrongStateException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".begin. Coordination type: " + coordinationType));
        }
        UserActivityFactory.userActivity().start(coordinationType);
    }

    @Override
    public void begin(String coordinationType, int timeout) throws WrongStateException, InvalidTimeoutException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".begin. Coordination type: " + coordinationType + ", timeout: " + timeout));
        }
        UserActivityFactory.userActivity().start(coordinationType, timeout);
    }

    public BACoordinator createSubordinate() throws SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".createSubordinate"));
        }
        return this._coordManager.createSubordinate();
    }

    @Override
    public void close() throws InvalidActivityException, WrongStateException, ProtocolViolationException, NoCoordinatorException, CoordinatorCancelledException, NoPermissionException, SystemException {
        block12: {
            if (wscfLogger.logger.isTraceEnabled()) {
                wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".close"));
            }
            try {
                Outcome res = UserActivityFactory.userActivity().end(Success.instance());
                if (wscfLogger.logger.isTraceEnabled()) {
                    wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".close. Outcome: " + res));
                }
                if (res == null) break block12;
                if (res instanceof CoordinationOutcome) {
                    CoordinationOutcome co = (CoordinationOutcome)res;
                    switch (co.result()) {
                        case 4: 
                        case 7: 
                        case 11: {
                            break;
                        }
                        case 3: 
                        case 10: {
                            throw new CoordinatorCancelledException();
                        }
                        case 5: {
                            throw new ProtocolViolationException("HeuristicMixed");
                        }
                        case 8: {
                            throw new WrongStateException();
                        }
                        default: {
                            throw new ProtocolViolationException("HeuristicHazard");
                        }
                    }
                    break block12;
                }
                throw new ProtocolViolationException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_CoordinatorServiceImple_1());
            }
            catch (NoActivityException ex) {
                throw new NoCoordinatorException();
            }
            catch (ActiveChildException activeChildException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cancel() throws InvalidActivityException, WrongStateException, ProtocolViolationException, NoCoordinatorException, CoordinatorConfirmedException, NoPermissionException, SystemException {
        block12: {
            if (wscfLogger.logger.isTraceEnabled()) {
                wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".cancel"));
            }
            try {
                Outcome res = UserActivityFactory.userActivity().end(Failure.instance());
                if (wscfLogger.logger.isTraceEnabled()) {
                    wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".cancel. Outcome: " + res));
                }
                if (res == null) break block12;
                if (res instanceof CoordinationOutcome) {
                    CoordinationOutcome co = (CoordinationOutcome)res;
                    switch (co.result()) {
                        case 4: 
                        case 11: {
                            throw new CoordinatorConfirmedException();
                        }
                        case 3: 
                        case 7: 
                        case 10: {
                            break;
                        }
                        case 5: {
                            throw new ProtocolViolationException("HeuristicMixed");
                        }
                        case 8: {
                            throw new WrongStateException();
                        }
                        default: {
                            throw new ProtocolViolationException("HeuristicHazard");
                        }
                    }
                    break block12;
                }
                throw new ProtocolViolationException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_CoordinatorServiceImple_1());
            }
            catch (NoActivityException ex) {
                throw new NoCoordinatorException();
            }
            catch (ActiveChildException activeChildException) {
                // empty catch block
            }
        }
    }

    @Override
    public void complete() throws InvalidActivityException, WrongStateException, ProtocolViolationException, NoCoordinatorException, NoPermissionException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".complete"));
        }
        this._coordManager.complete();
    }

    @Override
    public void setCancelOnly() throws NoCoordinatorException, WrongStateException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".complete"));
        }
        try {
            UserActivityFactory.userActivity().setCompletionStatus(FailureOnly.instance());
        }
        catch (NoActivityException ex) {
            throw new NoCoordinatorException();
        }
    }

    @Override
    public int getTimeout() throws SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".getTimeout"));
        }
        return UserActivityFactory.userActivity().getTimeout();
    }

    @Override
    public void setTimeout(int timeout) throws InvalidTimeoutException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".setTimeout. Timeout: " + timeout));
        }
        UserActivityFactory.userActivity().setTimeout(timeout);
    }

    @Override
    public Status status() throws SystemException {
        ActivityImple curr;
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".status"));
        }
        if ((curr = this.current()) == null) {
            return NoActivity.instance();
        }
        return this._coordManager.status();
    }

    @Override
    public ActivityHierarchy suspend() throws SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".suspend"));
        }
        return UserActivityFactory.userActivity().suspend();
    }

    @Override
    public void resume(ActivityHierarchy tx) throws InvalidActivityException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".resume"));
        }
        UserActivityFactory.userActivity().resume(tx);
    }

    @Override
    public void enlistParticipant(Participant act) throws WrongStateException, DuplicateParticipantException, InvalidParticipantException, NoCoordinatorException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".enlistParticipant. Participant: " + act));
        }
        this._coordManager.enlistParticipant(act);
    }

    @Override
    public void delistParticipant(String participantId) throws InvalidParticipantException, NoCoordinatorException, WrongStateException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".delistParticipant. Participant id: " + participantId));
        }
        this._coordManager.delistParticipant(participantId);
    }

    @Override
    public void participantCompleted(String participantId) throws NoActivityException, InvalidParticipantException, WrongStateException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".participantCompleted. Participant id: " + participantId));
        }
        this._coordManager.participantCompleted(participantId);
    }

    @Override
    public void participantFaulted(String participantId) throws NoActivityException, InvalidParticipantException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".participantFaulted. Participant id: " + participantId));
        }
        this._coordManager.participantFaulted(participantId);
        try {
            this.setCancelOnly();
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    @Override
    public void participantCannotComplete(String participantId) throws NoActivityException, InvalidParticipantException, WrongStateException, SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".participantCannotComplete. Participant id: " + participantId));
        }
        this._coordManager.participantCannotComplete(participantId);
        try {
            this.setCancelOnly();
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    @Override
    public ActivityHierarchy currentActivity() throws SystemException {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".currentActivity"));
        }
        return UserActivityFactory.userActivity().currentActivity();
    }

    @Override
    public CoordinatorId identifier() throws NoActivityException, SystemException {
        ActivityImple curr;
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".identifier"));
        }
        if ((curr = this.current()) == null) {
            throw new NoActivityException();
        }
        return this._coordManager.identifier();
    }

    public final ActivityImple current() {
        if (wscfLogger.logger.isTraceEnabled()) {
            wscfLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".current"));
        }
        UserActivityImple imple = (UserActivityImple)UserActivityFactory.userActivity();
        return imple.current();
    }
}

