/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.AnnotatableTypeSystem;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedAnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;

public class TypeSystem {
    private int typeid = 128;
    private TypeBinding[][] types;
    protected HashedParameterizedTypes parameterizedTypes;
    private SimpleLookupTable annotationTypes;
    LookupEnvironment environment;

    public TypeSystem(LookupEnvironment environment) {
        this.environment = environment;
        this.annotationTypes = new SimpleLookupTable(16);
        this.typeid = 128;
        this.types = new TypeBinding[256][];
        this.parameterizedTypes = new HashedParameterizedTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TypeBinding getUnannotatedType(TypeBinding type) {
        UnresolvedReferenceBinding urb = null;
        if (type.isUnresolvedType()) {
            urb = (UnresolvedReferenceBinding)type;
            ReferenceBinding resolvedType = urb.resolvedType;
            if (resolvedType != null) {
                type = CharOperation.indexOf('$', type.sourceName()) > 0 ? this.environment.convertToRawType(resolvedType, false) : resolvedType;
            } else if (CharOperation.indexOf('$', type.sourceName()) > 0) {
                boolean mayTolerateMissingType = this.environment.mayTolerateMissingType;
                this.environment.mayTolerateMissingType = true;
                try {
                    type = BinaryTypeBinding.resolveType(type, this.environment, true);
                }
                finally {
                    this.environment.mayTolerateMissingType = mayTolerateMissingType;
                }
            }
        }
        try {
            if (type.id == Integer.MAX_VALUE) {
                if (type.hasTypeAnnotations()) {
                    throw new IllegalStateException();
                }
                int typesLength = this.types.length;
                if (this.typeid == typesLength) {
                    this.types = new TypeBinding[typesLength * 2][];
                    System.arraycopy(this.types, 0, this.types, 0, typesLength);
                }
                type.id = this.typeid++;
                this.types[type.id] = new TypeBinding[4];
            } else {
                TypeBinding nakedType;
                TypeBinding typeBinding = nakedType = this.types[type.id] == null ? null : this.types[type.id][0];
                if (type.hasTypeAnnotations() && nakedType == null) {
                    throw new IllegalStateException();
                }
                if (nakedType != null) {
                    TypeBinding typeBinding2 = nakedType;
                    return typeBinding2;
                }
                this.types[type.id] = new TypeBinding[4];
            }
        }
        finally {
            if (urb != null && urb.id == Integer.MAX_VALUE) {
                urb.id = type.id;
            }
        }
        TypeBinding typeBinding = type;
        this.types[type.id][0] = typeBinding;
        return typeBinding;
    }

    public void forceRegisterAsDerived(TypeBinding derived) {
        TypeBinding unannotated;
        int id = derived.id;
        if (id != Integer.MAX_VALUE && this.types[id] != null) {
            unannotated = this.types[id][0];
            if (unannotated == derived) {
                this.types[id][0] = unannotated = derived.clone(null);
            }
        } else {
            throw new IllegalStateException("Type was not yet registered as expected: " + derived);
        }
        this.cacheDerivedType(unannotated, derived);
    }

    public TypeBinding[] getAnnotatedTypes(TypeBinding type) {
        return Binding.NO_TYPES;
    }

    public ArrayBinding getArrayType(TypeBinding leafType, int dimensions) {
        TypeBinding derivedType;
        int i;
        if (leafType instanceof ArrayBinding) {
            dimensions += leafType.dimensions();
            leafType = leafType.leafComponentType();
        }
        TypeBinding unannotatedLeafType = this.getUnannotatedType(leafType);
        TypeBinding[] derivedTypes = this.types[unannotatedLeafType.id];
        int length = derivedTypes.length;
        for (i = 0; i < length && (derivedType = derivedTypes[i]) != null; ++i) {
            if (!derivedType.isArrayType() || derivedType.hasTypeAnnotations() || derivedType.leafComponentType() != unannotatedLeafType || derivedType.dimensions() != dimensions) continue;
            return (ArrayBinding)derivedType;
        }
        if (i == length) {
            TypeBinding[] typeBindingArray = derivedTypes;
            derivedTypes = new TypeBinding[length * 2];
            System.arraycopy(typeBindingArray, 0, derivedTypes, 0, length);
            this.types[unannotatedLeafType.id] = derivedTypes;
        }
        derivedTypes[i] = new ArrayBinding(unannotatedLeafType, dimensions, this.environment);
        ArrayBinding arrayType = derivedTypes[i];
        int typesLength = this.types.length;
        if (this.typeid == typesLength) {
            this.types = new TypeBinding[typesLength * 2][];
            System.arraycopy(this.types, 0, this.types, 0, typesLength);
        }
        this.types[this.typeid] = new TypeBinding[1];
        arrayType.id = this.typeid++;
        ArrayBinding arrayBinding = arrayType;
        this.types[arrayType.id][0] = arrayBinding;
        return arrayBinding;
    }

    public ArrayBinding getArrayType(TypeBinding leafComponentType, int dimensions, AnnotationBinding[] annotations) {
        return this.getArrayType(leafComponentType, dimensions);
    }

    public ReferenceBinding getMemberType(ReferenceBinding memberType, ReferenceBinding enclosingType) {
        return memberType;
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding genericType, TypeBinding[] typeArguments, ReferenceBinding enclosingType) {
        ReferenceBinding unannotatedGenericType = (ReferenceBinding)this.getUnannotatedType(genericType);
        int typeArgumentsLength = typeArguments == null ? 0 : typeArguments.length;
        TypeBinding[] unannotatedTypeArguments = typeArguments == null ? null : new TypeBinding[typeArgumentsLength];
        for (int i = 0; i < typeArgumentsLength; ++i) {
            unannotatedTypeArguments[i] = this.getUnannotatedType(typeArguments[i]);
        }
        ReferenceBinding unannotatedEnclosingType = enclosingType == null ? null : (ReferenceBinding)this.getUnannotatedType(enclosingType);
        ParameterizedTypeBinding parameterizedType = this.parameterizedTypes.get(unannotatedGenericType, unannotatedTypeArguments, unannotatedEnclosingType, Binding.NO_ANNOTATIONS);
        if (parameterizedType != null) {
            return parameterizedType;
        }
        parameterizedType = new ParameterizedTypeBinding(unannotatedGenericType, unannotatedTypeArguments, unannotatedEnclosingType, this.environment);
        this.cacheDerivedType(unannotatedGenericType, parameterizedType);
        this.parameterizedTypes.put(genericType, typeArguments, enclosingType, parameterizedType);
        int typesLength = this.types.length;
        if (this.typeid == typesLength) {
            this.types = new TypeBinding[typesLength * 2][];
            System.arraycopy(this.types, 0, this.types, 0, typesLength);
        }
        this.types[this.typeid] = new TypeBinding[1];
        parameterizedType.id = this.typeid++;
        ParameterizedTypeBinding parameterizedTypeBinding = parameterizedType;
        this.types[parameterizedType.id][0] = parameterizedTypeBinding;
        return parameterizedTypeBinding;
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding genericType, TypeBinding[] typeArguments, ReferenceBinding enclosingType, AnnotationBinding[] annotations) {
        return this.getParameterizedType(genericType, typeArguments, enclosingType);
    }

    public RawTypeBinding getRawType(ReferenceBinding genericType, ReferenceBinding enclosingType) {
        TypeBinding derivedType;
        int i;
        ReferenceBinding unannotatedGenericType = (ReferenceBinding)this.getUnannotatedType(genericType);
        ReferenceBinding unannotatedEnclosingType = enclosingType == null ? null : (ReferenceBinding)this.getUnannotatedType(enclosingType);
        TypeBinding[] derivedTypes = this.types[unannotatedGenericType.id];
        int length = derivedTypes.length;
        for (i = 0; i < length && (derivedType = derivedTypes[i]) != null; ++i) {
            if (!derivedType.isRawType() || derivedType.actualType() != unannotatedGenericType || derivedType.hasTypeAnnotations() || derivedType.enclosingType() != unannotatedEnclosingType) continue;
            return (RawTypeBinding)derivedType;
        }
        if (i == length) {
            TypeBinding[] typeBindingArray = derivedTypes;
            derivedTypes = new TypeBinding[length * 2];
            System.arraycopy(typeBindingArray, 0, derivedTypes, 0, length);
            this.types[unannotatedGenericType.id] = derivedTypes;
        }
        derivedTypes[i] = new RawTypeBinding(unannotatedGenericType, unannotatedEnclosingType, this.environment);
        RawTypeBinding rawTytpe = derivedTypes[i];
        int typesLength = this.types.length;
        if (this.typeid == typesLength) {
            this.types = new TypeBinding[typesLength * 2][];
            System.arraycopy(this.types, 0, this.types, 0, typesLength);
        }
        this.types[this.typeid] = new TypeBinding[1];
        rawTytpe.id = this.typeid++;
        RawTypeBinding rawTypeBinding = rawTytpe;
        this.types[rawTytpe.id][0] = rawTypeBinding;
        return rawTypeBinding;
    }

    public RawTypeBinding getRawType(ReferenceBinding genericType, ReferenceBinding enclosingType, AnnotationBinding[] annotations) {
        return this.getRawType(genericType, enclosingType);
    }

    public WildcardBinding getWildcard(ReferenceBinding genericType, int rank, TypeBinding bound, TypeBinding[] otherBounds, int boundKind) {
        TypeBinding derivedType;
        int i;
        if (genericType == null) {
            genericType = ReferenceBinding.LUB_GENERIC;
        }
        ReferenceBinding unannotatedGenericType = (ReferenceBinding)this.getUnannotatedType(genericType);
        int otherBoundsLength = otherBounds == null ? 0 : otherBounds.length;
        Object[] unannotatedOtherBounds = otherBounds == null ? null : new TypeBinding[otherBoundsLength];
        for (int i2 = 0; i2 < otherBoundsLength; ++i2) {
            unannotatedOtherBounds[i2] = this.getUnannotatedType(otherBounds[i2]);
        }
        TypeBinding unannotatedBound = bound == null ? null : this.getUnannotatedType(bound);
        TypeBinding[] derivedTypes = this.types[unannotatedGenericType.id];
        int length = derivedTypes.length;
        for (i = 0; i < length && (derivedType = derivedTypes[i]) != null; ++i) {
            if (!derivedType.isWildcard() || derivedType.actualType() != unannotatedGenericType || derivedType.hasTypeAnnotations() || derivedType.rank() != rank || derivedType.boundKind() != boundKind || derivedType.bound() != unannotatedBound || !Util.effectivelyEqual(derivedType.additionalBounds(), unannotatedOtherBounds)) continue;
            return (WildcardBinding)derivedType;
        }
        if (i == length) {
            TypeBinding[] typeBindingArray = derivedTypes;
            derivedTypes = new TypeBinding[length * 2];
            System.arraycopy(typeBindingArray, 0, derivedTypes, 0, length);
            this.types[unannotatedGenericType.id] = derivedTypes;
        }
        derivedTypes[i] = new WildcardBinding(unannotatedGenericType, rank, unannotatedBound, (TypeBinding[])unannotatedOtherBounds, boundKind, this.environment);
        WildcardBinding wildcard = derivedTypes[i];
        int typesLength = this.types.length;
        if (this.typeid == typesLength) {
            this.types = new TypeBinding[typesLength * 2][];
            System.arraycopy(this.types, 0, this.types, 0, typesLength);
        }
        this.types[this.typeid] = new TypeBinding[1];
        wildcard.id = this.typeid++;
        WildcardBinding wildcardBinding = wildcard;
        this.types[wildcard.id][0] = wildcardBinding;
        return wildcardBinding;
    }

    public final CaptureBinding getCapturedWildcard(WildcardBinding wildcard, ReferenceBinding contextType, int start, int end, ASTNode cud, int id) {
        int i;
        int length;
        WildcardBinding unannotatedWildcard = (WildcardBinding)this.getUnannotatedType(wildcard);
        TypeBinding[] derivedTypes = this.types[unannotatedWildcard.id];
        int nullSlot = length = derivedTypes.length;
        for (i = length - 1; i >= -1; --i) {
            if (i == -1) {
                i = nullSlot;
                break;
            }
            TypeBinding derivedType = derivedTypes[i];
            if (derivedType == null) {
                nullSlot = i;
                continue;
            }
            if (!derivedType.isCapture()) continue;
            CaptureBinding prior = (CaptureBinding)derivedType;
            if (prior.cud != cud) {
                i = nullSlot;
                break;
            }
            if (prior.sourceType != contextType || prior.start != start || prior.end != end) continue;
            return prior;
        }
        if (i == length) {
            TypeBinding[] typeBindingArray = derivedTypes;
            derivedTypes = new TypeBinding[length * 2];
            System.arraycopy(typeBindingArray, 0, derivedTypes, 0, length);
            this.types[unannotatedWildcard.id] = derivedTypes;
        }
        derivedTypes[i] = new CaptureBinding(wildcard, contextType, start, end, cud, id);
        return derivedTypes[i];
    }

    public WildcardBinding getWildcard(ReferenceBinding genericType, int rank, TypeBinding bound, TypeBinding[] otherBounds, int boundKind, AnnotationBinding[] annotations) {
        return this.getWildcard(genericType, rank, bound, otherBounds, boundKind);
    }

    public TypeBinding getAnnotatedType(TypeBinding type, AnnotationBinding[][] annotations) {
        return type;
    }

    protected final TypeBinding[] getDerivedTypes(TypeBinding keyType) {
        keyType = this.getUnannotatedType(keyType);
        return this.types[keyType.id];
    }

    private TypeBinding cacheDerivedType(TypeBinding keyType, TypeBinding derivedType) {
        if (keyType == null || derivedType == null || keyType.id == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        TypeBinding[] derivedTypes = this.types[keyType.id];
        int length = derivedTypes.length;
        int first = 0;
        int last = length;
        int i = (first + last) / 2;
        do {
            if (derivedTypes[i] == null) {
                if (i == first || i > 0 && derivedTypes[i - 1] != null) break;
                last = i - 1;
                continue;
            }
            first = i + 1;
        } while ((i = (first + last) / 2) < length && first <= last);
        if (i == length) {
            TypeBinding[] typeBindingArray = derivedTypes;
            derivedTypes = new TypeBinding[length * 2];
            System.arraycopy(typeBindingArray, 0, derivedTypes, 0, length);
            this.types[keyType.id] = derivedTypes;
        }
        derivedTypes[i] = derivedType;
        return derivedTypes[i];
    }

    protected final TypeBinding cacheDerivedType(TypeBinding keyType, TypeBinding nakedType, TypeBinding derivedType) {
        this.cacheDerivedType(keyType, derivedType);
        if (nakedType.id != keyType.id) {
            this.cacheDerivedType(nakedType, derivedType);
        }
        return derivedType;
    }

    public final AnnotationBinding getAnnotationType(ReferenceBinding annotationType, boolean requiredResolved) {
        AnnotationBinding annotation = (AnnotationBinding)this.annotationTypes.get(annotationType);
        if (annotation == null) {
            annotation = requiredResolved ? new AnnotationBinding(annotationType, Binding.NO_ELEMENT_VALUE_PAIRS) : new UnresolvedAnnotationBinding(annotationType, Binding.NO_ELEMENT_VALUE_PAIRS, this.environment);
            this.annotationTypes.put(annotationType, annotation);
        }
        if (requiredResolved) {
            annotation.resolve();
        }
        return annotation;
    }

    public boolean isAnnotatedTypeSystem() {
        return false;
    }

    public void reset() {
        this.annotationTypes = new SimpleLookupTable(16);
        this.typeid = 128;
        this.types = new TypeBinding[256][];
        this.parameterizedTypes = new HashedParameterizedTypes();
    }

    public void updateCaches(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType) {
        int i;
        int unresolvedTypeId = unresolvedType.id;
        if (unresolvedTypeId != Integer.MAX_VALUE) {
            int length;
            TypeBinding[] derivedTypes = this.types[unresolvedTypeId];
            int n = length = derivedTypes == null ? 0 : derivedTypes.length;
            for (i = 0; i < length && derivedTypes[i] != null; ++i) {
                if (derivedTypes[i] != unresolvedType) continue;
                resolvedType.id = unresolvedTypeId;
                derivedTypes[i] = resolvedType;
            }
        }
        if (this.annotationTypes.get(unresolvedType) != null) {
            Object[] keys = this.annotationTypes.keyTable;
            int l = keys.length;
            for (i = 0; i < l; ++i) {
                if (keys[i] != unresolvedType) continue;
                keys[i] = resolvedType;
                break;
            }
        }
    }

    public final TypeBinding getIntersectionType18(ReferenceBinding[] intersectingTypes) {
        int intersectingTypesLength;
        int n = intersectingTypesLength = intersectingTypes == null ? 0 : intersectingTypes.length;
        if (intersectingTypesLength == 0) {
            return null;
        }
        ReferenceBinding keyType = intersectingTypes[0];
        if (keyType == null || intersectingTypesLength == 1) {
            return keyType;
        }
        block0: for (TypeBinding derivedType : this.getDerivedTypes(keyType)) {
            ReferenceBinding[] priorIntersectingTypes;
            if (derivedType == null) break;
            if (!derivedType.isIntersectionType18() || (priorIntersectingTypes = derivedType.getIntersectingTypes()).length != intersectingTypesLength) continue;
            for (int j = 0; j < intersectingTypesLength; ++j) {
                if (intersectingTypes[j] != priorIntersectingTypes[j]) continue block0;
            }
            return derivedType;
        }
        return this.cacheDerivedType(keyType, new IntersectionTypeBinding18(intersectingTypes, this.environment));
    }

    public void fixTypeVariableDeclaringElement(TypeVariableBinding var, Binding declaringElement) {
        int id = var.id;
        if (id < this.typeid && this.types[id] != null) {
            for (TypeBinding t : this.types[id]) {
                if (!(t instanceof TypeVariableBinding)) continue;
                ((TypeVariableBinding)t).declaringElement = declaringElement;
            }
        } else {
            var.declaringElement = declaringElement;
        }
    }

    public final class HashedParameterizedTypes {
        HashMap<ParameterizedTypeBinding, ParameterizedTypeBinding[]> hashedParameterizedTypes = new HashMap(256);

        ParameterizedTypeBinding get(ReferenceBinding genericType, TypeBinding[] typeArguments, ReferenceBinding enclosingType, AnnotationBinding[] annotations) {
            int length;
            ReferenceBinding unannotatedGenericType = (ReferenceBinding)TypeSystem.this.getUnannotatedType(genericType);
            int typeArgumentsLength = typeArguments == null ? 0 : typeArguments.length;
            Object[] unannotatedTypeArguments = typeArguments == null ? null : new TypeBinding[typeArgumentsLength];
            for (int i = 0; i < typeArgumentsLength; ++i) {
                unannotatedTypeArguments[i] = TypeSystem.this.getUnannotatedType(typeArguments[i]);
            }
            ReferenceBinding unannotatedEnclosingType = enclosingType == null ? null : (ReferenceBinding)TypeSystem.this.getUnannotatedType(enclosingType);
            InternalParameterizedTypeBinding typeParameterization = new InternalParameterizedTypeBinding(unannotatedGenericType, (TypeBinding[])unannotatedTypeArguments, unannotatedEnclosingType, TypeSystem.this.environment);
            ReferenceBinding genericTypeToMatch = unannotatedGenericType;
            ReferenceBinding enclosingTypeToMatch = unannotatedEnclosingType;
            Object[] typeArgumentsToMatch = unannotatedTypeArguments;
            if (TypeSystem.this instanceof AnnotatableTypeSystem) {
                genericTypeToMatch = genericType;
                enclosingTypeToMatch = enclosingType;
                typeArgumentsToMatch = typeArguments;
            }
            ParameterizedTypeBinding[] parameterizedTypeBindings = this.hashedParameterizedTypes.get(typeParameterization);
            int n = length = parameterizedTypeBindings == null ? 0 : parameterizedTypeBindings.length;
            for (int i = 0; i < length; ++i) {
                ParameterizedTypeBinding parameterizedType = parameterizedTypeBindings[i];
                if (parameterizedType.actualType() != genericTypeToMatch || parameterizedType.enclosingType() != enclosingTypeToMatch || !Util.effectivelyEqual(parameterizedType.typeArguments(), typeArgumentsToMatch) || !Util.effectivelyEqual(annotations, parameterizedType.getTypeAnnotations())) continue;
                return parameterizedType;
            }
            return null;
        }

        void put(ReferenceBinding genericType, TypeBinding[] typeArguments, ReferenceBinding enclosingType, ParameterizedTypeBinding parameterizedType) {
            int slot;
            ReferenceBinding unannotatedGenericType = (ReferenceBinding)TypeSystem.this.getUnannotatedType(genericType);
            int typeArgumentsLength = typeArguments == null ? 0 : typeArguments.length;
            TypeBinding[] unannotatedTypeArguments = typeArguments == null ? null : new TypeBinding[typeArgumentsLength];
            for (int i = 0; i < typeArgumentsLength; ++i) {
                unannotatedTypeArguments[i] = TypeSystem.this.getUnannotatedType(typeArguments[i]);
            }
            ReferenceBinding unannotatedEnclosingType = enclosingType == null ? null : (ReferenceBinding)TypeSystem.this.getUnannotatedType(enclosingType);
            InternalParameterizedTypeBinding typeParameterization = new InternalParameterizedTypeBinding(unannotatedGenericType, unannotatedTypeArguments, unannotatedEnclosingType, TypeSystem.this.environment);
            ParameterizedTypeBinding[] parameterizedTypeBindings = this.hashedParameterizedTypes.get(typeParameterization);
            if (parameterizedTypeBindings == null) {
                slot = 0;
                parameterizedTypeBindings = new ParameterizedTypeBinding[1];
            } else {
                slot = parameterizedTypeBindings.length;
                ParameterizedTypeBinding[] parameterizedTypeBindingArray = parameterizedTypeBindings;
                parameterizedTypeBindings = new ParameterizedTypeBinding[slot + 1];
                System.arraycopy(parameterizedTypeBindingArray, 0, parameterizedTypeBindings, 0, slot);
            }
            parameterizedTypeBindings[slot] = parameterizedType;
            this.hashedParameterizedTypes.put(typeParameterization, parameterizedTypeBindings);
        }

        private final class InternalParameterizedTypeBinding
        extends ParameterizedTypeBinding {
            public InternalParameterizedTypeBinding(ReferenceBinding genericType, TypeBinding[] typeArguments, ReferenceBinding enclosingType, LookupEnvironment environment) {
                super(genericType, typeArguments, enclosingType, environment);
            }

            public boolean equals(Object other) {
                ParameterizedTypeBinding that = (ParameterizedTypeBinding)other;
                return this.type == that.type && this.enclosingType == that.enclosingType && Util.effectivelyEqual(this.arguments, that.arguments);
            }

            @Override
            public int hashCode() {
                int length;
                int hashCode = this.type.hashCode() + 13 * (this.enclosingType != null ? this.enclosingType.hashCode() : 0);
                int n = length = this.arguments == null ? 0 : this.arguments.length;
                for (int i = 0; i < length; ++i) {
                    hashCode += (i + 1) * this.arguments[i].id * this.arguments[i].hashCode();
                }
                return hashCode;
            }
        }
    }
}

