/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.commons.cipher;

import java.io.Console;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.picketbox.commons.cipher.Base64;

public class PBEUtils {
    public static byte[] encode(byte[] secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec) throws Exception {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(1, (Key)cipherKey, cipherSpec);
        byte[] encoding = cipher.doFinal(secret);
        return encoding;
    }

    public static String encode64(byte[] secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec) throws Exception {
        byte[] encoding = PBEUtils.encode(secret, cipherAlgorithm, cipherKey, cipherSpec);
        String b64 = Base64.encodeBytes(encoding);
        return b64;
    }

    public static byte[] decode(byte[] secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(2, (Key)cipherKey, cipherSpec);
        byte[] decode = cipher.doFinal(secret);
        return decode;
    }

    public static String decode64(String secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] encoding = Base64.decode(secret);
        byte[] decode = PBEUtils.decode(encoding, cipherAlgorithm, cipherKey, cipherSpec);
        return new String(decode, "UTF-8");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Encrypt a password\nUsage: PBEUtils <salt> <count> [password]\nsalt: the Salt\ncount: the IterationCount\npassword: the plaintext password that should be encrypted. If this argument is not provided it will be prompted");
            System.exit(1);
        }
        byte[] passwordToEncode = null;
        if (args.length == 3) {
            passwordToEncode = args[2].getBytes("UTF-8");
        } else {
            Console console = System.console();
            char[] pass = console.readPassword("Enter the password: ", new Object[0]);
            String passString = new String(pass);
            passwordToEncode = passString.getBytes();
        }
        byte[] salt = args[0].substring(0, 8).getBytes();
        int count = Integer.parseInt(args[1]);
        char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        SecretKey cipherKey = factory.generateSecret(keySpec);
        String encodedPassword = PBEUtils.encode64(passwordToEncode, "PBEwithMD5andDES", cipherKey, cipherSpec);
        System.out.println("Encoded password: " + encodedPassword);
    }
}

