/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.wfly10.config.management.ManageableResource;
import org.jboss.migration.wfly10.config.management.ManageableResourceType;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.ManagementOperationException;

public abstract class AbstractManageableResource<P extends ManageableResource>
implements ManageableResource {
    private final Map<ManageableResourceType, Factory> childResourceFactories = new HashMap<ManageableResourceType, Factory>();
    private final String resourceName;
    private final PathAddress pathAddress;
    private final P parent;
    private final ManageableServerConfiguration serverConfiguration;

    protected AbstractManageableResource(String resourceName, PathAddress pathAddress, P parent) {
        this.resourceName = resourceName;
        this.pathAddress = pathAddress != null ? pathAddress : PathAddress.EMPTY_ADDRESS;
        this.parent = parent;
        this.serverConfiguration = parent != null ? parent.getServerConfiguration() : (ManageableServerConfiguration)((Object)this);
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public PathAddress getResourcePathAddress() {
        return this.pathAddress;
    }

    public P getParentResource() {
        return this.parent;
    }

    @Override
    public ManageableServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    @Override
    public ModelNode getResourceConfiguration() {
        if (!this.isExistentResource()) {
            return null;
        }
        PathAddress address = this.getResourcePathAddress();
        ModelNode op = Util.createEmptyOperation((String)"read-resource", (PathAddress)address);
        op.get("recursive").set(true);
        ModelNode result = this.serverConfiguration.executeManagementOperation(op);
        return result.get("result");
    }

    protected void addChildResourceFactory(Factory childResourceFactory) {
        this.childResourceFactories.put(childResourceFactory.getResourceType(), childResourceFactory);
    }

    protected <T extends ManageableResource> Factory<T, ?> getChildResourceFactory(ManageableResourceType resourceType) {
        return this.childResourceFactories.get(resourceType);
    }

    protected <T extends ManageableResource> List<Factory> getChildResourceFactories(Class<T> resourceType) {
        return this.childResourceFactories.values().stream().filter(factory -> this.isResourceTypeMatch(resourceType, factory.getResourceType().getType())).collect(Collectors.toList());
    }

    protected <T extends ManageableResource> List<Factory> getDescendantResourceFactories(ManageableResourceType resourceType) {
        return this.childResourceFactories.values().stream().filter(factory -> factory.getResourceType().getDescendantTypes().contains(resourceType)).collect(Collectors.toList());
    }

    private boolean isResourceTypeMatch(Class<?> resourceType, Class<?> candidateType) {
        if (resourceType.equals(candidateType)) {
            return true;
        }
        for (Class<?> candidateInterfaceType : candidateType.getInterfaces()) {
            if (!this.isResourceTypeMatch(resourceType, candidateInterfaceType)) continue;
            return true;
        }
        return false;
    }

    protected <T extends ManageableResource> List<Factory> getDescendantResourceFactories(Class<T> resourceType) {
        return this.childResourceFactories.values().stream().filter(factory -> {
            Set<ManageableResourceType> descendantTypes = factory.getResourceType().getDescendantTypes();
            for (ManageableResourceType t : descendantTypes) {
                if (!this.isResourceTypeMatch(resourceType, t.getType())) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    @Override
    public <T extends ManageableResource> T getChildResource(ManageableResourceType resourceType, String resourceName) {
        Factory<T, ?> factory = this.getChildResourceFactory(resourceType);
        return factory != null ? (T)factory.getResource(resourceName) : null;
    }

    @Override
    public <T extends ManageableResource> List<T> getChildResources(ManageableResourceType resourceType) {
        Factory<T, ?> factory = this.getChildResourceFactory(resourceType);
        return factory != null ? factory.getResources() : null;
    }

    @Override
    public <T extends ManageableResource> List<T> getChildResources(Class<T> resourceType) {
        return this.getChildResources(resourceType, null);
    }

    @Override
    public <T extends ManageableResource> List<T> getChildResources(Class<T> resourceType, String resourceName) {
        List<Factory> factories = this.getChildResourceFactories(resourceType);
        if (factories.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        for (Factory factory : factories) {
            if (resourceName != null) {
                Object t = factory.getResource(resourceName);
                if (t == null) continue;
                result.add(t);
                continue;
            }
            result.addAll(factory.getResources());
        }
        return result;
    }

    @Override
    public Set<ManageableResourceType> getChildResourceTypes() {
        return Collections.unmodifiableSet(this.childResourceFactories.keySet());
    }

    @Override
    public Set<String> getChildResourceNames(ManageableResourceType resourceType) {
        Factory factory = this.getChildResourceFactory(resourceType);
        return factory != null ? factory.getResourceNames() : null;
    }

    @Override
    public <T extends ManageableResource> PathAddress getChildResourcePathAddress(ManageableResourceType resourceType, String resourceName) {
        Factory<T, ?> factory = this.getChildResourceFactory(resourceType);
        return factory != null ? factory.getResourcePathAddress(resourceName) : null;
    }

    @Override
    public void removeChildResource(ManageableResourceType resourceType, String resourceName) {
        Factory factory = this.getChildResourceFactory(resourceType);
        if (factory != null) {
            factory.removeResource(resourceName);
        }
    }

    @Override
    public void removeResource() throws ManagementOperationException {
        if (this.isExistentResource()) {
            PathAddress address = this.getResourcePathAddress();
            ModelNode op = Util.createRemoveOperation((PathAddress)address);
            this.serverConfiguration.executeManagementOperation(op);
        }
    }

    @Override
    public <T extends ManageableResource> Set<T> findResources(ManageableResourceType resourceType) {
        return this.findResources(resourceType, null);
    }

    @Override
    public <T extends ManageableResource> Set<T> findResources(ManageableResourceType resourceType, String resourceName) {
        Factory<T, ?> childFactory;
        HashSet<ManageableResource> result = new HashSet<ManageableResource>();
        if (resourceType.equals(this.getResourceType()) && (resourceName == null || resourceName.equals(this.getResourceName()))) {
            result.add(this);
        }
        if ((childFactory = this.getChildResourceFactory(resourceType)) != null) {
            if (resourceName != null) {
                T child = childFactory.getResource(resourceName);
                if (child != null) {
                    result.add((ManageableResource)child);
                }
            } else {
                for (ManageableResource manageableResource : childFactory.getResources()) {
                    result.add(manageableResource);
                }
            }
        }
        for (Factory factory : this.getDescendantResourceFactories(resourceType)) {
            for (ManageableResource child : factory.getResources()) {
                result.addAll(child.findResources(resourceType, resourceName));
            }
        }
        return result;
    }

    @Override
    public <T extends ManageableResource> Set<T> findResources(Class<T> resourceType) {
        return this.findResources(resourceType, null);
    }

    public String toString() {
        return "ManageableResource(type=" + String.valueOf(this.getResourceType()) + ", name=" + String.valueOf(this.getResourceName()) + ")";
    }

    @Override
    public <T extends ManageableResource> Set<T> findResources(Class<T> resourceType, String resourceName) {
        HashSet<ManageableResource> result = new HashSet<ManageableResource>();
        if (resourceType.isInstance(this) && (resourceName == null || resourceName.equals(this.getResourceName()))) {
            result.add(this);
        }
        for (Factory childFactory : this.getChildResourceFactories(resourceType)) {
            if (resourceName != null) {
                Object child = childFactory.getResource(resourceName);
                if (child == null) continue;
                result.add((ManageableResource)child);
                continue;
            }
            for (ManageableResource child : childFactory.getResources()) {
                result.add(child);
            }
        }
        for (Factory descendantFactory : this.getDescendantResourceFactories(resourceType)) {
            for (ManageableResource child : descendantFactory.getResources()) {
                result.addAll(child.findResources(resourceType, resourceName));
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractManageableResource that = (AbstractManageableResource)o;
        if (!this.pathAddress.equals(that.pathAddress)) {
            return false;
        }
        return this.serverConfiguration.equals(that.serverConfiguration);
    }

    public int hashCode() {
        return this.pathAddress.hashCode();
    }

    protected static abstract class Factory<T extends ManageableResource, P extends ManageableResource> {
        protected final P parentResource;
        protected final ManageableServerConfiguration serverConfiguration;
        protected final PathAddress pathAddressBase;
        protected final String pathElementKey;
        protected final ManageableResourceType resourceType;

        public Factory(ManageableResourceType resourceType, PathAddress pathAddressBase, String pathElementKey, P parentResource) {
            this.resourceType = resourceType;
            this.pathAddressBase = pathAddressBase;
            this.pathElementKey = pathElementKey;
            this.parentResource = parentResource;
            this.serverConfiguration = parentResource.getServerConfiguration();
        }

        public PathAddress getResourcePathAddress(String resourceName) {
            return this.pathAddressBase.append(this.pathElementKey, resourceName);
        }

        public Set<String> getResourceNames() {
            try {
                ModelNode op = Util.createEmptyOperation((String)"read-children-names", (PathAddress)this.pathAddressBase);
                op.get("child-type").set(this.pathElementKey);
                ModelNode opResult = this.serverConfiguration.executeManagementOperation(op);
                HashSet<String> result = new HashSet<String>();
                for (ModelNode resultNode : opResult.get("result").asList()) {
                    result.add(resultNode.asString());
                }
                return result;
            }
            catch (ManagementOperationException e) {
                try {
                    ModelNode op = Util.createEmptyOperation((String)"read-children-types", (PathAddress)this.pathAddressBase);
                    ModelNode opResult = this.serverConfiguration.executeManagementOperation(op);
                    boolean childrenTypeFound = false;
                    for (ModelNode resultNode : opResult.get("result").asList()) {
                        if (!this.pathElementKey.equals(resultNode.asString())) continue;
                        childrenTypeFound = true;
                        break;
                    }
                    if (!childrenTypeFound) {
                        return Collections.emptySet();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
        }

        public boolean hasResource(String resourceName) {
            return this.getResourceNames().contains(resourceName);
        }

        public void removeResource(String resourceName) {
            if (this.hasResource(resourceName)) {
                PathAddress address = this.getResourcePathAddress(resourceName);
                ModelNode op = Util.createRemoveOperation((PathAddress)address);
                this.serverConfiguration.executeManagementOperation(op);
            }
        }

        public ManageableResourceType getResourceType() {
            return this.resourceType;
        }

        public T getResource(String resourceName) {
            return this.hasResource(resourceName) ? (T)this.newResourceInstance(resourceName) : null;
        }

        public List<T> getResources() {
            Set<String> resourceNames = this.getResourceNames();
            if (resourceNames.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<T> result = new ArrayList<T>();
            for (String resourceName : resourceNames) {
                result.add(this.getResource(resourceName));
            }
            return result;
        }

        protected abstract T newResourceInstance(String var1);

        public String toString() {
            return "ManageableResourceChildFactory(parent=" + String.valueOf(this.parentResource) + ", childType=" + this.getResourceType() + ")";
        }
    }
}

