/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task;

import org.jboss.migration.core.Server;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.console.UserConfirmationServerMigrationTask;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.WildFlyServer10;
import org.jboss.migration.wfly10.config.task.DomainConfigurationsMigration;
import org.jboss.migration.wfly10.config.task.HostConfigurationsMigration;
import org.jboss.migration.wfly10.config.task.ServerMigration;

public class DomainMigration<S extends Server>
implements ServerMigration.SubtaskFactory<S> {
    public static final String DOMAIN = "domain";
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("domain").build();
    private final DomainConfigurationsMigration<S, ?> domainConfigurationsMigration;
    private final HostConfigurationsMigration<S, ?> hostConfigurationsMigration;

    public DomainMigration(Builder<S> builder) {
        this.domainConfigurationsMigration = ((Builder)builder).domainConfigurationsMigration;
        this.hostConfigurationsMigration = ((Builder)builder).hostConfigurationsMigration;
    }

    @Override
    public ServerMigrationTask getTask(S source, WildFlyServer10 target) {
        ServerMigrationTask task = new ServerMigrationTask((Server)source, target){
            final /* synthetic */ Server val$source;
            final /* synthetic */ WildFlyServer10 val$target;
            {
                this.val$source = server;
                this.val$target = wildFlyServer10;
            }

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            public ServerMigrationTaskResult run(TaskContext context) {
                ConsoleWrapper consoleWrapper = context.getConsoleWrapper();
                consoleWrapper.println();
                context.getLogger().infof("--- Migrating managed domain...", new Object[0]);
                DomainMigration.this.beforeConfigurationsMigration(this.val$source, this.val$target, context);
                if (DomainMigration.this.domainConfigurationsMigration != null) {
                    consoleWrapper.println();
                    context.execute(DomainMigration.this.domainConfigurationsMigration.getServerMigrationTask(this.val$source, this.val$target, JBossServerConfiguration.Type.DOMAIN));
                }
                if (DomainMigration.this.hostConfigurationsMigration != null) {
                    consoleWrapper.println();
                    context.execute(DomainMigration.this.hostConfigurationsMigration.getServerMigrationTask(this.val$source, this.val$target, JBossServerConfiguration.Type.HOST));
                }
                DomainMigration.this.afterConfigurationsMigration(this.val$source, this.val$target, context);
                return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
            }
        };
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)new UserConfirmationServerMigrationTask(task, "Migrate the source's managed domain?"));
    }

    protected void beforeConfigurationsMigration(S source, WildFlyServer10 target, TaskContext context) {
    }

    protected void afterConfigurationsMigration(S source, WildFlyServer10 target, TaskContext context) {
    }

    public static class Builder<S extends Server> {
        private DomainConfigurationsMigration<S, ?> domainConfigurationsMigration;
        private HostConfigurationsMigration<S, ?> hostConfigurationsMigration;

        public Builder<S> domainConfigurations(DomainConfigurationsMigration<S, ?> domainConfigurationsMigration) {
            this.domainConfigurationsMigration = domainConfigurationsMigration;
            return this;
        }

        public Builder<S> hostConfigurations(HostConfigurationsMigration<S, ?> hostConfigurationsMigration) {
            this.hostConfigurationsMigration = hostConfigurationsMigration;
            return this;
        }

        public DomainMigration<S> build() {
            return new DomainMigration(this);
        }
    }
}

