/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.paths;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.jboss.MigrateResolvablePathTaskBuilder;
import org.jboss.migration.core.jboss.ResolvablePath;
import org.jboss.migration.core.jboss.XmlConfigurationMigration;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.SimpleComponentTask;
import org.jboss.migration.core.task.component.TaskSkipPolicy;

public class WebSubsystemPathsMigration
implements XmlConfigurationMigration.Component {
    public static final Set<String> ELEMENT_LOCAL_NAMES = Collections.singleton("ssl");
    public static final String CERTIFICATE_KEY_FILE = "certificate-key-file";
    public static final String CA_CERTIFICATE_FILE = "ca-certificate-file";
    protected final Set<String> certificateKeyFiles = new HashSet<String>();
    protected final Set<String> caCertificateFiles = new HashSet<String>();

    protected WebSubsystemPathsMigration() {
    }

    public Set<String> getElementLocalNames() {
        return ELEMENT_LOCAL_NAMES;
    }

    public void processElement(XMLStreamReader reader, JBossServerConfiguration sourceConfiguration, JBossServerConfiguration targetConfiguration, TaskContext context) throws IOException {
        String caCertificateFile;
        String namespaceURI = reader.getNamespaceURI();
        if (namespaceURI == null || !namespaceURI.startsWith("urn:jboss:domain:web:")) {
            return;
        }
        String certificateKeyFile = reader.getAttributeValue(null, CERTIFICATE_KEY_FILE);
        if (certificateKeyFile != null) {
            this.certificateKeyFiles.add(certificateKeyFile);
        }
        if ((caCertificateFile = reader.getAttributeValue(null, CA_CERTIFICATE_FILE)) != null) {
            this.caCertificateFiles.add(caCertificateFile);
        }
    }

    public void afterProcessingElements(JBossServerConfiguration sourceConfiguration, JBossServerConfiguration targetConfiguration, TaskContext taskContext) {
        taskContext.execute(((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)new SimpleComponentTask.Builder().name(taskContext.getTaskName().getName() + ".subsystem.web.ssl")).skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet())).runnable(context -> {
            String subtaskNamePrefix = context.getTaskName() + ".";
            for (String certificateKeyFile : this.certificateKeyFiles) {
                context.execute(new MigrateResolvablePathTaskBuilder().name(subtaskNamePrefix + CERTIFICATE_KEY_FILE).path(ResolvablePath.fromPathExpression((String)certificateKeyFile)).source(sourceConfiguration).target(targetConfiguration).build());
            }
            for (String caCertificateFile : this.caCertificateFiles) {
                context.execute(new MigrateResolvablePathTaskBuilder().name(subtaskNamePrefix + CA_CERTIFICATE_FILE).path(ResolvablePath.fromPathExpression((String)caCertificateFile)).source(sourceConfiguration).target(targetConfiguration).build());
            }
            return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        })).build());
    }

    public static class Factory
    implements XmlConfigurationMigration.ComponentFactory {
        public XmlConfigurationMigration.Component newComponent() {
            return new WebSubsystemPathsMigration();
        }
    }
}

