/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.ejb3;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class WorkaroundForWFLY5520<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "apply-wfly-5520-fix";

    public WorkaroundForWFLY5520() {
        this.subtaskName(TASK_NAME);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        ManageableServerConfiguration configurationManagement = subsystemResource.getServerConfiguration();
        if (!configurationManagement.getServer().getProductInfo().getName().equals("EAP") || !configurationManagement.getServer().getProductInfo().getVersion().equals("7.0.0.Beta1")) {
            return ServerMigrationTaskResult.SKIPPED;
        }
        if (config == null || !config.hasDefined("default-clustered-sfsb-cache")) {
            return ServerMigrationTaskResult.SKIPPED;
        }
        PathAddress address = subsystemResource.getResourcePathAddress();
        ModelNode op = Util.createEmptyOperation((String)"undefine-attribute", (PathAddress)address);
        op.get("name").set("default-clustered-sfsb-cache");
        configurationManagement.executeManagementOperation(op);
        op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)address);
        op.get("name").set("default-sfsb-cache");
        op.get("value").set("clustered");
        configurationManagement.executeManagementOperation(op);
        op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)address);
        op.get("name").set("default-sfsb-passivation-disabled-cache");
        op.get("value").set("simple");
        configurationManagement.executeManagementOperation(op);
        context.getLogger().infof("Target server does not includes fix for WFLY-5520, workaround applied into EJB3 subsystem configuration.", new Object[0]);
        return ServerMigrationTaskResult.SUCCESS;
    }
}

