/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.undertow;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class SetDefaultHttpListenerRedirectSocket<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "set-default-http-listener-redirect-socket";
    private static final String SERVER_NAME = "default-server";
    private static final String HTTP_LISTENER = "http-listener";
    private static final String REDIRECT_SOCKET_ATTR_NAME = "redirect-socket";
    private static final String REDIRECT_SOCKET_ATTR_VALUE = "https";
    private final String httpListenerName;

    public SetDefaultHttpListenerRedirectSocket() {
        this("default");
    }

    public SetDefaultHttpListenerRedirectSocket(String defaultHttpListenerName) {
        this.httpListenerName = defaultHttpListenerName;
        this.subtaskName(TASK_NAME);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        if (config.hasDefined(new String[]{"server", SERVER_NAME, HTTP_LISTENER, this.httpListenerName}) && !config.hasDefined(new String[]{"server", SERVER_NAME, HTTP_LISTENER, this.httpListenerName, REDIRECT_SOCKET_ATTR_NAME})) {
            PathAddress pathAddress = subsystemResource.getResourcePathAddress().append("server", SERVER_NAME).append(HTTP_LISTENER, this.httpListenerName);
            ModelNode op = Util.getWriteAttributeOperation((PathAddress)pathAddress, (String)REDIRECT_SOCKET_ATTR_NAME, (String)REDIRECT_SOCKET_ATTR_VALUE);
            subsystemResource.getServerConfiguration().executeManagementOperation(op);
            context.getLogger().debugf("Undertow's default HTTP listener '%s' redirect-socket set as 'https'.", (Object)this.httpListenerName);
            return ServerMigrationTaskResult.SUCCESS;
        }
        return ServerMigrationTaskResult.SKIPPED;
    }
}

