/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceConfiguratorContext;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceContext;
import org.wildfly.clustering.server.singleton.LegacyDistributedSingletonService;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.election.SimpleSingletonElectionPolicy;

@Deprecated
public class DistributedSingletonServiceBuilder<T>
extends SimpleServiceNameProvider
implements SingletonServiceBuilder<T>,
DistributedSingletonServiceContext {
    private final SupplierDependency<ServiceProviderRegistry<ServiceName>> registry;
    private final SupplierDependency<CommandDispatcherFactory> dispatcherFactory;
    private final Service<T> primaryService;
    private final Service<T> backupService;
    private volatile SingletonElectionPolicy electionPolicy = new SimpleSingletonElectionPolicy();
    private volatile int quorum = 1;

    public DistributedSingletonServiceBuilder(DistributedSingletonServiceConfiguratorContext context, ServiceName serviceName, Service<T> primaryService, Service<T> backupService) {
        super(serviceName);
        this.registry = context.getServiceProviderRegistryDependency();
        this.dispatcherFactory = context.getCommandDispatcherFactoryDependency();
        this.primaryService = primaryService;
        this.backupService = backupService;
    }

    public ServiceBuilder<T> build(ServiceTarget target) {
        LegacyDistributedSingletonService<T> service = new LegacyDistributedSingletonService<T>(this, this.primaryService, this.backupService);
        ServiceBuilder installer = target.addService(this.getServiceName(), service);
        return new CompositeDependency(new Dependency[]{this.registry, this.dispatcherFactory}).register(installer);
    }

    public SingletonServiceBuilder<T> requireQuorum(int quorum) {
        if (quorum < 1) {
            throw ClusteringServerLogger.ROOT_LOGGER.invalidQuorum(quorum);
        }
        this.quorum = quorum;
        return this;
    }

    public SingletonServiceBuilder<T> electionPolicy(SingletonElectionPolicy electionPolicy) {
        this.electionPolicy = electionPolicy;
        return this;
    }

    @Override
    public Supplier<ServiceProviderRegistry<ServiceName>> getServiceProviderRegistry() {
        return this.registry;
    }

    @Override
    public Supplier<CommandDispatcherFactory> getCommandDispatcherFactory() {
        return this.dispatcherFactory;
    }

    @Override
    public SingletonElectionPolicy getElectionPolicy() {
        return this.electionPolicy;
    }

    @Override
    public int getQuorum() {
        return this.quorum;
    }
}

