/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.function.Function;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.spi.persistence.SimpleKeyFormat;
import org.wildfly.clustering.marshalling.spi.StringExternalizer;

public enum ServiceNameResolver implements Function<String, ServiceName>
{
    RESOLVER;

    static final Function<ServiceName, String> PARSER;

    @Override
    public ServiceName apply(String name) {
        return ServiceName.parse((String)name);
    }

    static {
        PARSER = ServiceName::getCanonicalName;
    }

    public static class ServiceNameKeyFormat
    extends SimpleKeyFormat<ServiceName> {
        public ServiceNameKeyFormat() {
            super(ServiceName.class, (Function)RESOLVER, PARSER);
        }
    }

    public static class ServiceNameExternalizer
    extends StringExternalizer<ServiceName> {
        public ServiceNameExternalizer() {
            super(ServiceName.class, (Function)RESOLVER, PARSER);
        }
    }
}

