/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.FD_ALL;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FRAG3;
import org.jgroups.protocols.MERGE3;
import org.jgroups.protocols.MFC;
import org.jgroups.protocols.MPING;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UDP;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class InfinispanStackMerge3Test {
    private static final List<Supplier<TP>> TRANSPORTS = Arrays.asList(TCP::new, UDP::new);
    private static final int RUNS = Integer.valueOf(System.getProperty("runs", "5"));
    private static final int MEMBERS = Integer.valueOf(System.getProperty("members", "10"));

    public static void main(String[] args) throws Exception {
        HashMap<String, List<Long>> results = new HashMap<String, List<Long>>();
        for (Supplier<TP> transport : TRANSPORTS) {
            results.put(transport.get().getClass().getSimpleName(), new LinkedList());
            for (int run = 0; run < RUNS; ++run) {
                JChannel[] channels = new JChannel[MEMBERS];
                for (int member = 0; member < MEMBERS; ++member) {
                    channels[member] = InfinispanStackMerge3Test.createChannel(transport.get(), String.valueOf(member + 1));
                }
                Util.waitUntilAllChannelsHaveSameView(10000L, 500L, channels);
                System.out.printf("-- run #%d: cluster formed:\n%s\n", run + 1, InfinispanStackMerge3Test.printViews(channels));
                Stream.of(channels).forEach(channel -> {
                    GMS gms = (GMS)channel.getProtocolStack().findProtocol((Class<? extends Protocol>)GMS.class);
                    View view = View.create(channel.getAddress(), gms.getViewId().getId() + 1L, channel.getAddress());
                    gms.installView(view);
                });
                System.out.printf("-- injected partition (waiting for merge):\n%s\n", InfinispanStackMerge3Test.printViews(channels));
                long timeBeforeMerge = System.currentTimeMillis();
                Util.waitUntilAllChannelsHaveSameView(360000L, 100L, channels);
                long timeAfterMerge = System.currentTimeMillis();
                System.out.printf("-- run #%d: %s cluster merged in %d ms:\n%s\n", run + 1, transport.get().getClass().getSimpleName(), timeAfterMerge - timeBeforeMerge, InfinispanStackMerge3Test.printViews(channels));
                Stream.of(channels).forEach(JChannel::close);
                ((List)results.get(transport.get().getClass().getSimpleName())).add(timeAfterMerge - timeBeforeMerge);
            }
        }
        InfinispanStackMerge3Test.printStats(results);
    }

    protected static String printViews(JChannel ... channels) {
        return Stream.of(channels).map(ch -> String.format("%s: %s", ch.getAddress(), ch.getView())).collect(Collectors.joining("\n"));
    }

    protected static JChannel createChannel(TP transport, String name) throws Exception {
        return new JChannel(transport.setBindAddress(Util.getLocalhost()), new MPING(), new MERGE3().setMinInterval(5000L).setMaxInterval(10000L), new FD_SOCK(), new FD_ALL().interval(2000L).timeout(8000L).timeoutCheckInterval(2000L), new VERIFY_SUSPECT().setTimeout(5000L), new NAKACK2().setUseMcastXmit(false), new UNICAST3(), new STABLE(), new GMS().joinTimeout(1000L).printLocalAddress(false), new MFC(), new FRAG3().fragSize(8000)).setName(name).connect(InfinispanStackMerge3Test.class.getSimpleName());
    }

    private static void printStats(Map<String, List<Long>> results) {
        for (Map.Entry<String, List<Long>> entry : results.entrySet()) {
            System.out.printf("Results for %s%n", entry.getKey());
            System.out.printf("Min merge time=%d%n", entry.getValue().stream().min(Long::compare).get());
            System.out.printf("Max merge time=%d%n", entry.getValue().stream().max(Long::compare).get());
            System.out.printf("Avg merge time=%s%n", entry.getValue().stream().mapToLong(x -> x).average().getAsDouble());
            System.out.printf("===================================================================%n", new Object[0]);
        }
    }
}

