/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.csiv2;

import java.nio.charset.StandardCharsets;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jboss.metadata.ejb.jboss.IORASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.jboss.metadata.ejb.jboss.IORTransportConfigMetaData;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TransportAddress;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.service.CorbaORBService;

public final class CSIv2Util {
    private static final byte[] gssUpMechOidArray = CSIv2Util.createGSSUPMechOID();

    private CSIv2Util() {
    }

    public static TaggedComponent createCopy(TaggedComponent tc) {
        TaggedComponent copy = null;
        if (tc != null) {
            byte[] buf = new byte[tc.component_data.length];
            System.arraycopy(tc.component_data, 0, buf, 0, tc.component_data.length);
            copy = new TaggedComponent(tc.tag, buf);
        }
        return copy;
    }

    public static TaggedComponent createSSLTaggedComponent(IORSecurityConfigMetaData metadata, Codec codec, int sslPort, ORB orb) {
        TaggedComponent tc;
        if (metadata == null) {
            IIOPLogger.ROOT_LOGGER.debug("Method createSSLTaggedComponent() called with null metadata");
            return null;
        }
        if (sslPort == 0) {
            return null;
        }
        try {
            int supports = CSIv2Util.createTargetSupports(metadata.getTransportConfig());
            int requires = CSIv2Util.createTargetRequires(metadata.getTransportConfig());
            SSL ssl = new SSL((short)supports, (short)requires, (short)sslPort);
            Any any = orb.create_any();
            SSLHelper.insert((Any)any, (SSL)ssl);
            byte[] componentData = codec.encode_value(any);
            tc = new TaggedComponent(20, componentData);
        }
        catch (InvalidTypeForEncoding e) {
            throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
        }
        return tc;
    }

    public static TaggedComponent createSecurityTaggedComponent(IORSecurityConfigMetaData metadata, Codec codec, int sslPort, ORB orb) {
        TaggedComponent tc;
        if (metadata == null) {
            IIOPLogger.ROOT_LOGGER.debug("Method createSecurityTaggedComponent() called with null metadata");
            return null;
        }
        CompoundSecMech[] mechList = CSIv2Util.createCompoundSecMechanisms(metadata, codec, sslPort, orb);
        CompoundSecMechList csmList = new CompoundSecMechList(false, mechList);
        try {
            Any any = orb.create_any();
            CompoundSecMechListHelper.insert((Any)any, (CompoundSecMechList)csmList);
            byte[] b = codec.encode_value(any);
            tc = new TaggedComponent(33, b);
        }
        catch (InvalidTypeForEncoding e) {
            throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
        }
        return tc;
    }

    public static CompoundSecMech[] createCompoundSecMechanisms(IORSecurityConfigMetaData metadata, Codec codec, int sslPort, ORB orb) {
        CompoundSecMech csm;
        CompoundSecMech[] csmList = new CompoundSecMech[1];
        TaggedComponent transport_mech = CSIv2Util.createTransportMech(metadata.getTransportConfig(), codec, sslPort, orb);
        AS_ContextSec asContext = CSIv2Util.createAuthenticationServiceContext(metadata);
        SAS_ContextSec sasContext = CSIv2Util.createSecureAttributeServiceContext(metadata);
        int target_requires = CSIv2Util.createTargetRequires(metadata.getTransportConfig()) | asContext.target_requires | sasContext.target_requires;
        csmList[0] = csm = new CompoundSecMech((short)target_requires, transport_mech, asContext, sasContext);
        return csmList;
    }

    public static SAS_ContextSec createSecureAttributeServiceContext(IORSecurityConfigMetaData metadata) {
        SAS_ContextSec context;
        int support = 0;
        boolean require = false;
        ServiceConfiguration[] privilAuth = new ServiceConfiguration[]{};
        Object supNamMechs = new byte[][]{};
        int supIdenTypes = 0;
        IORSASContextMetaData sasMeta = metadata.getSasContext();
        if (sasMeta == null || sasMeta.getCallerPropagation().equals("NONE")) {
            context = new SAS_ContextSec((short)support, (short)(require ? 1 : 0), privilAuth, (byte[][])supNamMechs, supIdenTypes);
        } else {
            support = 1024;
            byte[] upMech = CSIv2Util.createGSSUPMechOID();
            supNamMechs = new byte[1][upMech.length];
            System.arraycopy(upMech, 0, supNamMechs[0], 0, upMech.length);
            supIdenTypes = 15;
            context = new SAS_ContextSec((short)support, (short)(require ? 1 : 0), privilAuth, (byte[][])supNamMechs, supIdenTypes);
        }
        return context;
    }

    public static AS_ContextSec createAuthenticationServiceContext(IORSecurityConfigMetaData metadata) {
        AS_ContextSec context;
        int support = 0;
        int require = 0;
        byte[] clientAuthMech = new byte[]{};
        byte[] targetName = new byte[]{};
        IORASContextMetaData asMeta = metadata.getAsContext();
        if (asMeta == null || asMeta.getAuthMethod().equals("NONE")) {
            context = new AS_ContextSec((short)support, (short)require, clientAuthMech, targetName);
        } else {
            support = 64;
            if (asMeta.isRequired()) {
                require = 64;
            }
            clientAuthMech = CSIv2Util.createGSSUPMechOID();
            String realm = asMeta.getRealm();
            targetName = CSIv2Util.createGSSExportedName(clientAuthMech, realm.getBytes());
            context = new AS_ContextSec((short)support, (short)require, clientAuthMech, targetName);
        }
        return context;
    }

    public static TaggedComponent createTransportMech(IORTransportConfigMetaData tconfig, Codec codec, int sslPort, ORB orb) {
        TaggedComponent tc;
        int support = 0;
        int require = 0;
        if (tconfig != null) {
            require = CSIv2Util.createTargetRequires(tconfig);
            support = CSIv2Util.createTargetSupports(tconfig);
        }
        if (tconfig == null || support == 0 || sslPort == 0) {
            tc = new TaggedComponent(34, new byte[0]);
        } else {
            String host = CorbaORBService.getORBProperty("OAIAddr");
            TransportAddress[] taList = CSIv2Util.createTransportAddress(host, sslPort);
            TLS_SEC_TRANS tst = new TLS_SEC_TRANS((short)support, (short)require, taList);
            try {
                Any any = orb.create_any();
                TLS_SEC_TRANSHelper.insert((Any)any, (TLS_SEC_TRANS)tst);
                byte[] b = codec.encode_value(any);
                tc = new TaggedComponent(36, b);
            }
            catch (InvalidTypeForEncoding e) {
                throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
            }
        }
        return tc;
    }

    public static TransportAddress[] createTransportAddress(String host, int port) {
        short short_port = port > Short.MAX_VALUE ? (short)(port - 65536) : (short)port;
        TransportAddress ta = new TransportAddress(host, short_port);
        TransportAddress[] taList = new TransportAddress[]{ta};
        return taList;
    }

    public static int createTargetRequires(IORTransportConfigMetaData tc) {
        int requires = 0;
        if (tc != null) {
            if (tc.getIntegrity().equals("REQUIRED")) {
                requires |= 2;
            }
            if (tc.getConfidentiality().equals("REQUIRED")) {
                requires |= 4;
            }
            if (tc.getDetectMisordering().equalsIgnoreCase("REQUIRED")) {
                requires |= 0x10;
            }
            if (tc.getDetectReplay().equalsIgnoreCase("REQUIRED")) {
                requires |= 8;
            }
            if (tc.getEstablishTrustInClient().equals("REQUIRED")) {
                requires |= 0x40;
            }
        }
        return requires;
    }

    public static int createTargetSupports(IORTransportConfigMetaData tc) {
        int supports = 0;
        if (tc != null) {
            if (!tc.getIntegrity().equals("NONE")) {
                supports |= 2;
            }
            if (!tc.getConfidentiality().equals("NONE")) {
                supports |= 4;
            }
            if (!tc.getDetectMisordering().equalsIgnoreCase("NONE")) {
                supports |= 0x10;
            }
            if (!tc.getDetectReplay().equalsIgnoreCase("NONE")) {
                supports |= 8;
            }
            if (!tc.getEstablishTrustInTarget().equals("NONE")) {
                supports |= 0x20;
            }
            if (!tc.getEstablishTrustInClient().equals("NONE")) {
                supports |= 0x40;
            }
        }
        return supports;
    }

    public static byte[] createGSSUPMechOID() {
        byte[] retval = new byte[]{};
        try {
            Oid oid = new Oid("oid:2.23.130.1.1.1".substring(4));
            retval = oid.getDER();
        }
        catch (GSSException e) {
            IIOPLogger.ROOT_LOGGER.caughtExceptionEncodingGSSUPMechOID(e);
        }
        return retval;
    }

    public static byte[] createGSSExportedName(byte[] oid, byte[] name) {
        int olen = oid.length;
        int nlen = name.length;
        int size = 4 + olen + 4 + nlen;
        byte[] buf = new byte[size];
        int i = 0;
        buf[i++] = 4;
        buf[i++] = 1;
        buf[i++] = (byte)(olen & 0xFF00);
        buf[i++] = (byte)(olen & 0xFF);
        System.arraycopy(oid, 0, buf, i, olen);
        i += olen;
        buf[i++] = (byte)(nlen & 0xFF000000);
        buf[i++] = (byte)(nlen & 0xFF0000);
        buf[i++] = (byte)(nlen & 0xFF00);
        buf[i++] = (byte)(nlen & 0xFF);
        System.arraycopy(name, 0, buf, i, nlen);
        return buf;
    }

    public static byte[] encodeInitialContextToken(InitialContextToken authToken, Codec codec) {
        byte[] out;
        Any any = ORB.init().create_any();
        InitialContextTokenHelper.insert((Any)any, (InitialContextToken)authToken);
        try {
            out = codec.encode_value(any);
        }
        catch (Exception e) {
            return new byte[0];
        }
        int length = out.length + gssUpMechOidArray.length;
        int n = length < 128 ? 0 : (length < 256 ? 1 : (length < 65536 ? 2 : (length < 0x1000000 ? 3 : 4)));
        byte[] encodedToken = new byte[2 + n + length];
        encodedToken[0] = 96;
        if (n == 0) {
            encodedToken[1] = (byte)length;
        } else {
            encodedToken[1] = (byte)(n | 0x80);
            switch (n) {
                case 1: {
                    encodedToken[2] = (byte)length;
                    break;
                }
                case 2: {
                    encodedToken[2] = (byte)(length >> 8);
                    encodedToken[3] = (byte)length;
                    break;
                }
                case 3: {
                    encodedToken[2] = (byte)(length >> 16);
                    encodedToken[3] = (byte)(length >> 8);
                    encodedToken[4] = (byte)length;
                    break;
                }
                default: {
                    encodedToken[2] = (byte)(length >> 24);
                    encodedToken[3] = (byte)(length >> 16);
                    encodedToken[4] = (byte)(length >> 8);
                    encodedToken[5] = (byte)length;
                }
            }
        }
        System.arraycopy(gssUpMechOidArray, 0, encodedToken, 2 + n, gssUpMechOidArray.length);
        System.arraycopy(out, 0, encodedToken, 2 + n + gssUpMechOidArray.length, out.length);
        return encodedToken;
    }

    public static InitialContextToken decodeInitialContextToken(byte[] encodedToken, Codec codec) {
        Any any;
        if (encodedToken[0] != 96) {
            return null;
        }
        int encodedLength = 0;
        int n = 0;
        if (encodedToken[1] >= 0) {
            encodedLength = encodedToken[1];
        } else {
            n = encodedToken[1] & 0x7F;
            for (int i = 1; i <= n; ++i) {
                encodedLength += (encodedToken[1 + i] & 0xFF) << (n - i) * 8;
            }
        }
        int length = encodedLength - gssUpMechOidArray.length;
        byte[] encodedInitialContextToken = new byte[length];
        System.arraycopy(encodedToken, 2 + n + gssUpMechOidArray.length, encodedInitialContextToken, 0, length);
        try {
            any = codec.decode_value(encodedInitialContextToken, InitialContextTokenHelper.type());
        }
        catch (Exception e) {
            return null;
        }
        return InitialContextTokenHelper.extract((Any)any);
    }

    public static byte[] encodeGssExportedName(byte[] name) {
        return CSIv2Util.createGSSExportedName(gssUpMechOidArray, name);
    }

    public static byte[] decodeGssExportedName(byte[] encodedName) {
        if (encodedName[0] != 4 || encodedName[1] != 1) {
            return null;
        }
        int mechOidLength = (encodedName[2] & 0xFF) << 8;
        byte[] oidArray = new byte[mechOidLength += encodedName[3] & 0xFF];
        System.arraycopy(encodedName, 4, oidArray, 0, mechOidLength);
        for (int i = 0; i < mechOidLength; ++i) {
            if (gssUpMechOidArray[i] == oidArray[i]) continue;
            return null;
        }
        int offset = 4 + mechOidLength;
        int nameLength = (encodedName[offset] & 0xFF) << 24;
        nameLength += (encodedName[++offset] & 0xFF) << 16;
        nameLength += (encodedName[++offset] & 0xFF) << 8;
        byte[] name = new byte[nameLength += encodedName[++offset] & 0xFF];
        System.arraycopy(encodedName, ++offset, name, 0, nameLength);
        return name;
    }

    public static CompoundSecMech getMatchingSecurityMech(ClientRequestInfo ri, Codec codec, short clientSupports, short clientRequires) {
        try {
            TaggedComponent tc = ri.get_effective_component(33);
            Any any = codec.decode_value(tc.component_data, CompoundSecMechListHelper.type());
            CompoundSecMechList csmList = CompoundSecMechListHelper.extract((Any)any);
            for (int i = 0; i < csmList.mechanism_list.length; ++i) {
                CompoundSecMech securityMech = csmList.mechanism_list[i];
                AS_ContextSec authConfig = securityMech.as_context_mech;
                if ((0x20 & (clientRequires ^ authConfig.target_supports) & ~authConfig.target_supports) != 0 || (0x40 & (authConfig.target_requires ^ clientSupports) & ~clientSupports) != 0) continue;
                SAS_ContextSec identityConfig = securityMech.sas_context_mech;
                if ((0x400 & (identityConfig.target_requires ^ clientSupports) & ~clientSupports) != 0) continue;
                return securityMech;
            }
            return null;
        }
        catch (BAD_PARAM e) {
            return null;
        }
        catch (TypeMismatch e) {
            throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
        }
        catch (FormatMismatch e) {
            throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
        }
    }

    public static void toString(CompoundSecMech securityMech, StringBuilder builder) {
        SAS_ContextSec sasMech;
        AS_ContextSec asMech = securityMech != null ? securityMech.as_context_mech : null;
        SAS_ContextSec sAS_ContextSec = sasMech = securityMech != null ? securityMech.sas_context_mech : null;
        if (securityMech != null) {
            builder.append("CompoundSecMech[");
            builder.append("target_requires: ");
            builder.append(securityMech.target_requires);
            if (asMech != null) {
                builder.append("AS_ContextSec[");
                builder.append("client_authentication_mech: ");
                builder.append(new String(asMech.client_authentication_mech, StandardCharsets.UTF_8));
                builder.append(", target_name: ");
                builder.append(new String(asMech.target_name, StandardCharsets.UTF_8));
                builder.append(", target_requires: ");
                builder.append(asMech.target_requires);
                builder.append(", target_supports: ");
                builder.append(asMech.target_supports);
                builder.append("]");
            }
            if (sasMech != null) {
                builder.append("SAS_ContextSec[");
                builder.append("supported_identity_types: ");
                builder.append(sasMech.supported_identity_types);
                builder.append(", target_requires: ");
                builder.append(sasMech.target_requires);
                builder.append(", target_supports: ");
                builder.append(sasMech.target_supports);
                builder.append("]");
            }
            builder.append("]");
        }
    }
}

