/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import org.wildfly.discovery.AttributeValue;

final class BooleanAttributeValue
extends AttributeValue {
    private static final long serialVersionUID = -5223377657098950186L;
    private final boolean value;
    static final BooleanAttributeValue TRUE = new BooleanAttributeValue(true);
    static final BooleanAttributeValue FALSE = new BooleanAttributeValue(false);

    private BooleanAttributeValue(boolean value) {
        super(Boolean.toString(value));
        this.value = value;
    }

    @Override
    String generateToString() {
        return Boolean.toString(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BooleanAttributeValue && this.equals((BooleanAttributeValue)obj);
    }

    @Override
    public boolean equals(AttributeValue obj) {
        return obj instanceof BooleanAttributeValue && this.equals((BooleanAttributeValue)obj);
    }

    public boolean equals(BooleanAttributeValue obj) {
        return obj == this || obj != null && this.value == obj.value;
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    @Override
    int getKind() {
        return this.value ? 3 : 4;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    Object readResolve() {
        return this.value ? TRUE : FALSE;
    }

    Object writeReplace() {
        return this.value ? TRUE : FALSE;
    }
}

