/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

public class IdentitySharedExclusiveLock {
    private int sharedHoldCount;
    private boolean isExclusiveLocked;
    private int exclusiveRequests;

    public synchronized IdentityLock lockExclusive() {
        boolean interrupted = false;
        try {
            ++this.exclusiveRequests;
            while (this.sharedHoldCount > 0 || this.isExclusiveLocked) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            this.isExclusiveLocked = true;
            --this.exclusiveRequests;
            IdentityLock identityLock = new IdentityLock(true);
            return identityLock;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized IdentityLock lockShared() {
        boolean interrupted = false;
        try {
            while (this.isExclusiveLocked || this.exclusiveRequests > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            ++this.sharedHoldCount;
            IdentityLock identityLock = new IdentityLock(false);
            return identityLock;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private synchronized void release(IdentityLock identityLock) {
        if (identityLock.isExclusive()) {
            this.isExclusiveLocked = false;
            this.notifyAll();
        } else if (--this.sharedHoldCount == 0) {
            this.notifyAll();
        }
    }

    public class IdentityLock
    implements AutoCloseable {
        private final boolean exclusive;
        private volatile boolean valid = true;

        public IdentityLock(boolean exclusive) {
            this.exclusive = exclusive;
        }

        public synchronized void release() {
            if (this.valid) {
                IdentitySharedExclusiveLock.this.release(this);
                this.valid = false;
            }
        }

        @Override
        public void close() {
            this.release();
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

