/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.env;

import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;

public class SkippableByEnvServerMigrationTask
implements ServerMigrationTask {
    private final ServerMigrationTask task;
    private final String propertyName;

    public SkippableByEnvServerMigrationTask(ServerMigrationTask task, String propertyName) {
        this.task = task;
        this.propertyName = propertyName;
    }

    public SkippableByEnvServerMigrationTask(ServerMigrationTask task) {
        this(task, task.getName().getName() + ".skip");
    }

    @Override
    public ServerMigrationTaskName getName() {
        return this.task.getName();
    }

    @Override
    public ServerMigrationTaskResult run(TaskContext context) {
        return context.getMigrationEnvironment().getPropertyAsBoolean(this.propertyName, Boolean.FALSE) == false ? this.task.run(context) : ServerMigrationTaskResult.SKIPPED;
    }

    public String toString() {
        return "SkippableByEnvServerMigrationTask[task=" + this.task.toString() + ", propertyName=" + this.propertyName + "]";
    }
}

