/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import org.jboss.migration.core.jboss.Extension;

public class Subsystem {
    private final String name;
    private final String namespaceWithoutVersion;
    private final Extension extension;

    public Subsystem(Builder builder) {
        this.name = builder.name;
        this.namespaceWithoutVersion = builder.namespaceWithoutVersion == null ? "urn:jboss:domain:" + this.name : builder.namespaceWithoutVersion;
        this.extension = builder.extension;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceWithoutVersion() {
        return this.namespaceWithoutVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subsystem subsystem = (Subsystem)o;
        return this.name.equals(subsystem.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private static class DefaultBuilder
    extends Builder<DefaultBuilder> {
        private DefaultBuilder() {
        }

        @Override
        protected DefaultBuilder getThis() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String name;
        private String namespaceWithoutVersion;
        private Extension extension;

        protected abstract T getThis();

        public T extension(Extension extension) {
            this.extension = extension;
            return this.getThis();
        }

        public T name(String name) {
            this.name = name;
            return this.getThis();
        }

        public T namespaceWithoutVersion(String namespaceWithoutVersion) {
            this.namespaceWithoutVersion = namespaceWithoutVersion;
            return this.getThis();
        }

        public Subsystem build() {
            return new Subsystem(this);
        }
    }
}

