/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.logging.Logger;
import org.jboss.migration.core.MigrationData;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskExecution;
import org.jboss.migration.core.util.xml.AttributeValue;
import org.jboss.migration.core.util.xml.ElementNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;

public class XmlReportWriter
implements XMLElementWriter<MigrationData> {
    public static XmlReportWriter INSTANCE = new XmlReportWriter();

    private XmlReportWriter() {
    }

    public void writeContent(XMLStreamWriter streamWriter, MigrationData value) throws XMLStreamException {
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.deparseDocument((XMLElementWriter)this, (Object)value, streamWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(File file, MigrationData value) throws XMLStreamException, IOException {
        Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
        try (FileOutputStream out = new FileOutputStream(file);){
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
            try {
                this.writeContent(writer, value);
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter, MigrationData description) throws XMLStreamException {
        ElementNode rootElementNode = new ElementNode(null, "server-migration-report", "urn:jboss:server-migration:1.0");
        this.processMigrationData(description, rootElementNode);
        streamWriter.writeStartDocument();
        rootElementNode.marshall((XMLStreamWriter)streamWriter);
        streamWriter.writeEndDocument();
    }

    protected void processMigrationData(MigrationData description, ElementNode rootElementNode) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String utcTime = sdf.format(new Date(description.getRootTask().getStartTime()));
        rootElementNode.addAttribute("start-time", new AttributeValue(utcTime));
        ElementNode serversNode = new ElementNode(rootElementNode, "servers");
        this.processServer(description.getSource(), serversNode, "source");
        this.processServer(description.getTarget(), serversNode, "target");
        rootElementNode.addChild(serversNode);
        this.processEnvironment(description.getServerMigrationEnvironment(), rootElementNode);
        this.processTask(description.getRootTask(), rootElementNode);
    }

    protected void processServer(Server server, ElementNode parentElementNode, String elementLocalName) {
        ElementNode serverNode = new ElementNode(parentElementNode, elementLocalName);
        serverNode.addAttribute("name", new AttributeValue(server.getProductInfo().getName()));
        serverNode.addAttribute("version", new AttributeValue(server.getProductInfo().getVersion()));
        serverNode.addAttribute("base-dir", new AttributeValue(server.getBaseDir().toString()));
        parentElementNode.addChild(serverNode);
    }

    protected void processEnvironment(MigrationEnvironment environment, ElementNode parentElementNode) {
        ElementNode environmentNode = new ElementNode(parentElementNode, "environment");
        for (String propertyName : environment.getPropertyNamesReaded()) {
            ElementNode propertyNode = new ElementNode(environmentNode, "property");
            propertyNode.addAttribute("name", new AttributeValue(propertyName));
            propertyNode.addAttribute("value", new AttributeValue(environment.getPropertyAsString(propertyName, "null")));
            environmentNode.addChild(propertyNode);
        }
        parentElementNode.addChild(environmentNode);
    }

    protected void processTask(TaskExecution task, ElementNode parentElementNode) {
        ElementNode taskNode = new ElementNode(parentElementNode, "task");
        taskNode.addAttribute("number", new AttributeValue(String.valueOf(task.getTaskNumber())));
        taskNode.addAttribute("name", new AttributeValue(task.getTaskName().toString()));
        this.processTaskLogger(task.getLogger(), taskNode);
        this.processTaskResult(task.getResult(), taskNode);
        this.processSubtasks(task.getSubtasks(), taskNode);
        parentElementNode.addChild(taskNode);
    }

    protected void processTaskLogger(Logger logger2, ElementNode taskNode) {
        ElementNode loggerNode = new ElementNode(taskNode, "logger");
        loggerNode.addAttribute("logger", new AttributeValue(logger2.getName()));
        taskNode.addChild(loggerNode);
    }

    protected void processTaskResult(ServerMigrationTaskResult result, ElementNode taskNode) {
        Map<String, String> attributes;
        ElementNode resultNode = new ElementNode(taskNode, "result");
        resultNode.addAttribute("status", new AttributeValue(result.getStatus().name()));
        if (result.getFailReason() != null) {
            resultNode.addAttribute("fail-reason", new AttributeValue(result.getFailReason().toString()));
        }
        if ((attributes = result.getAttributes()) != null && !attributes.isEmpty()) {
            ElementNode attributesElementNode = new ElementNode(resultNode, "attributes");
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                ElementNode attributeElementNode = new ElementNode(resultNode, "attribute");
                attributeElementNode.addAttribute("name", new AttributeValue(attribute.getKey()));
                attributeElementNode.addAttribute("value", new AttributeValue(attribute.getValue()));
                attributesElementNode.addChild(attributeElementNode);
            }
            resultNode.addChild(attributesElementNode);
        }
        taskNode.addChild(resultNode);
    }

    protected void processSubtasks(List<TaskExecution> subtasks, ElementNode taskNode) {
        if (subtasks != null && !subtasks.isEmpty()) {
            ElementNode subtasksNode = new ElementNode(taskNode, "subtasks");
            for (TaskExecution subtask : subtasks) {
                this.processTask(subtask, subtasksNode);
            }
            taskNode.addChild(subtasksNode);
        }
    }
}

