/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.util.xml.XMLFileMatcher;

public abstract class SimpleXMLFileMatcher
implements XMLFileMatcher {
    @Override
    public boolean matches(Path path) throws ServerMigrationFailureException {
        boolean match = false;
        String fileName = path.getFileName().toString();
        if (this.fileNameMatches(fileName)) {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                reader.require(7, null, null);
                while (reader.hasNext()) {
                    if (reader.next() != 1) continue;
                    if (this.documentElementLocalNameMatches(reader.getLocalName()) && this.documentNamespaceURIMatches(reader.getNamespaceURI())) {
                        match = true;
                    }
                    break;
                }
            }
            catch (IOException | XMLStreamException e) {
                throw new ServerMigrationFailureException("failed to parse xml file " + path, e);
            }
        }
        return match;
    }

    protected boolean fileNameMatches(String fileName) {
        return fileName.endsWith(".xml");
    }

    protected boolean documentElementLocalNameMatches(String localName) {
        return true;
    }

    protected boolean documentNamespaceURIMatches(String namespaceURI) {
        return true;
    }
}

