/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.util.ByteListImpl;
import org.apache.xerces.impl.dv.util.HexBin;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class HexBinaryDV
extends TypeValidator {
    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        byte[] decoded = HexBin.decode(content);
        if (decoded == null) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "hexBinary"});
        }
        return new XHex(decoded);
    }

    @Override
    public int getDataLength(Object value) {
        return ((XHex)value).getLength();
    }

    private static final class XHex
    extends ByteListImpl {
        public XHex(byte[] data) {
            super(data);
        }

        @Override
        public synchronized String toString() {
            if (this.canonical == null) {
                this.canonical = HexBin.encode(this.data);
            }
            return this.canonical;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof XHex)) {
                return false;
            }
            int len = this.data.length;
            byte[] odata = ((XHex)obj).data;
            if (len != odata.length) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (this.data[i] == odata[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.data.length; ++i) {
                hash = hash * 37 + (this.data[i] & 0xFF);
            }
            return hash;
        }
    }
}

