/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate5.service;

import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.spi.ServiceContributor;
import org.jboss.as.jpa.hibernate5.service.WildFlyCustomJtaPlatformInitiator;
import org.jboss.as.jpa.hibernate5.service.WildFlyCustomRegionFactoryInitiator;

public class ServiceContributorImpl
implements ServiceContributor {
    private static final String CONTROLJTAINTEGRATION = "wildfly.jpa.jtaplatform";
    private static final String CONTROL2LCINTEGRATION = "wildfly.jpa.regionfactory";

    public void contribute(StandardServiceRegistryBuilder serviceRegistryBuilder) {
        Boolean regionFactoryInitiatorEnabled;
        Boolean jtaPlatformInitiatorEnabled = serviceRegistryBuilder.getSettings().getOrDefault(CONTROLJTAINTEGRATION, true);
        if (jtaPlatformInitiatorEnabled == null || jtaPlatformInitiatorEnabled instanceof Boolean && jtaPlatformInitiatorEnabled.booleanValue() || Boolean.parseBoolean(((Object)jtaPlatformInitiatorEnabled).toString())) {
            serviceRegistryBuilder.addInitiator((StandardServiceInitiator)new WildFlyCustomJtaPlatformInitiator());
        }
        if ((regionFactoryInitiatorEnabled = serviceRegistryBuilder.getSettings().getOrDefault(CONTROL2LCINTEGRATION, true)) == null || regionFactoryInitiatorEnabled instanceof Boolean && regionFactoryInitiatorEnabled.booleanValue() || Boolean.parseBoolean(((Object)regionFactoryInitiatorEnabled).toString())) {
            serviceRegistryBuilder.addInitiator((StandardServiceInitiator)new WildFlyCustomRegionFactoryInitiator());
        }
    }
}

