/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.EndpointConfigFactory;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.WorkerThreadPoolVsEndpointHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

class RemotingSubsystemAdd
extends AbstractAddStepHandler {
    private final boolean forDomain;

    RemotingSubsystemAdd(RemotingSubsystemRootResource.Attributes attributes) {
        super(attributes.all);
        this.forDomain = attributes.forDomain;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        context.addStep((OperationStepHandler)new WorkerThreadPoolVsEndpointHandler(this.forDomain), OperationContext.Stage.MODEL);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceController controller;
        ModelNode endpointModel = context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{RemotingEndpointResource.ENDPOINT_PATH})).getModel();
        String workerName = RemotingSubsystemRootResource.WORKER.resolveModelAttribute(context, endpointModel).asString();
        OptionMap map = EndpointConfigFactory.populate((ExpressionResolver)context, endpointModel);
        String nodeName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
        EndpointService endpointService = new EndpointService(nodeName, EndpointService.EndpointType.SUBSYSTEM, map);
        if (context.getProcessType() == ProcessType.DOMAIN_SERVER && (controller = context.getServiceRegistry(false).getService(RemotingServices.SUBSYSTEM_ENDPOINT)) != null) {
            return;
        }
        context.getCapabilityServiceTarget().addCapability(RemotingSubsystemRootResource.REMOTING_ENDPOINT_CAPABILITY, (Service)endpointService).addCapabilityRequirement("org.wildfly.io.worker", XnioWorker.class, endpointService.getWorker(), new String[]{workerName}).install();
    }
}

