/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.deployment;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.as.cli.Attachments;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.impl.aesh.cmd.LegacyBridge;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.AccessRequirements;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.CommandWithPermissions;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.Permissions;
import org.jboss.as.cli.impl.aesh.cmd.security.ControlledCommandActivator;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.MountHandle;
import org.wildfly.core.cli.command.BatchCompliantCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.cli.command.aesh.activator.HideOptionActivator;

@CommandDefinition(name="deploy-cli-archive", description="", activator=ControlledCommandActivator.class)
public class DeployArchiveCommand
extends CommandWithPermissions
implements Command<CLICommandInvocation>,
BatchCompliantCommand,
LegacyBridge {
    private static final String CLI_ARCHIVE_SUFFIX = ".cli";
    @Deprecated
    @Option(hasValue=false, activator=HideOptionActivator.class)
    private boolean help;
    @Option(hasValue=true, required=false)
    public String script;
    @Argument(required=true)
    public File file;

    public DeployArchiveCommand(CommandContext ctx, Permissions permissions) {
        super(ctx, AccessRequirements.deployArchiveAccess(permissions), permissions);
    }

    @Deprecated
    public DeployArchiveCommand(CommandContext ctx) {
        this(ctx, (Permissions)null);
    }

    protected String getAction() {
        return "deploy-cli-archive";
    }

    protected String getDefaultScript() {
        return "deploy.scr";
    }

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo("deployment " + this.getAction()));
            return CommandResult.SUCCESS;
        }
        CommandContext ctx = commandInvocation.getCommandContext();
        return this.execute(ctx);
    }

    @Override
    public CommandResult execute(CommandContext ctx) throws CommandException {
        this.checkArgument();
        Attachments attachments = new Attachments();
        try {
            ModelNode result;
            ModelNode request = this.buildRequest(ctx, attachments);
            if (!request.get("steps").isDefined()) {
                CommandResult commandResult = CommandResult.SUCCESS;
                return commandResult;
            }
            OperationBuilder op = new OperationBuilder(request, true);
            for (String f : attachments.getAttachedFiles()) {
                op.addFileAsAttachment(new File(f));
            }
            try (Operation operation = op.build();){
                result = ctx.getModelControllerClient().execute(operation);
            }
            if (!Util.isSuccess(result)) {
                throw new CommandException(Util.getFailureDescription(result));
            }
        }
        catch (IOException e) {
            throw new CommandException("Failed to deploy archive", (Throwable)e);
        }
        catch (CommandFormatException ex) {
            throw new CommandException((Throwable)ex);
        }
        finally {
            attachments.done();
        }
        return CommandResult.SUCCESS;
    }

    private void checkArgument() throws CommandException {
        if (this.file == null) {
            throw new CommandException("No archive file");
        }
        if (!this.file.exists()) {
            throw new CommandException("Path " + this.file.getAbsolutePath() + " doesn't exist.");
        }
        if (!DeployArchiveCommand.isCliArchive(this.file)) {
            throw new CommandException("Not a CLI archive " + this.file.getAbsolutePath());
        }
    }

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        return this.buildRequest(context, null);
    }

    @Override
    public ModelNode buildRequest(CommandContext context, Attachments attachments) throws CommandFormatException {
        MountHandle root;
        TempFileProvider tempFileProvider;
        CommandContext ctx = context;
        try {
            String name = "cli-" + System.currentTimeMillis();
            tempFileProvider = TempFileProvider.create((String)name, (ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "CLI (un)deploy archive tempFile")), (boolean)true);
            root = DeployArchiveCommand.extractArchive(this.file, tempFileProvider, name);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OperationFormatException("Unable to extract archive '" + this.file.getAbsolutePath() + "' to temporary location");
        }
        Consumer<Attachments> cl = a -> VFSUtils.safeClose((Closeable[])new Closeable[]{root, tempFileProvider});
        if (attachments != null) {
            attachments.addConsumer(cl);
        }
        File currentDir = ctx.getCurrentDir();
        ctx.setCurrentDir(root.getMountSource());
        String holdbackBatch = DeployArchiveCommand.activateNewBatch(ctx);
        try {
            File scriptFile;
            if (this.script == null) {
                this.script = this.getDefaultScript();
            }
            if (!(scriptFile = new File(ctx.getCurrentDir(), this.script)).exists()) {
                throw new CommandFormatException("ERROR: script '" + this.script + "' not found.");
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(scriptFile));
                String line = reader.readLine();
                while (!ctx.isTerminated() && line != null) {
                    context.handle(line);
                    line = reader.readLine();
                }
            }
            catch (FileNotFoundException e) {
                throw new CommandFormatException("ERROR: script '" + this.script + "' not found.");
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to read the next command from " + scriptFile.getName() + ": " + e.getMessage(), e);
            }
            catch (CommandLineException ex) {
                throw new CommandFormatException(ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ModelNode modelNode = ctx.getBatchManager().getActiveBatch().toRequest();
            return modelNode;
        }
        catch (CommandFormatException cfex) {
            cl.accept(attachments);
            throw cfex;
        }
        finally {
            ctx.setCurrentDir(currentDir);
            DeployArchiveCommand.discardBatch(ctx, holdbackBatch, attachments, cl);
        }
    }

    public static boolean isCliArchive(File f) {
        return f != null && !f.isDirectory() && f.getName().endsWith(CLI_ARCHIVE_SUFFIX);
    }

    static MountHandle extractArchive(File archive, TempFileProvider tempFileProvider, String name) throws IOException {
        return (MountHandle)VFS.mountZipExpanded((File)archive, (VirtualFile)VFS.getChild((String)name), (TempFileProvider)tempFileProvider);
    }

    static String activateNewBatch(CommandContext ctx) {
        String currentBatch = null;
        BatchManager batchManager = ctx.getBatchManager();
        Attachments attachments = null;
        if (batchManager.isBatchActive()) {
            Batch current = batchManager.getActiveBatch();
            attachments = current.getAttachments();
            currentBatch = "batch" + System.currentTimeMillis();
            batchManager.holdbackActiveBatch(currentBatch);
        }
        batchManager.activateNewBatch();
        Batch archiveBatch = batchManager.getActiveBatch();
        if (attachments != null) {
            for (String f : attachments.getAttachedFiles()) {
                archiveBatch.getAttachments().addFileAttachment(f);
            }
        }
        return currentBatch;
    }

    static void discardBatch(CommandContext ctx, String holdbackBatch, Attachments attachments, Consumer<Attachments> listener) {
        BatchManager batchManager = ctx.getBatchManager();
        Attachments archiveAttachments = batchManager.getActiveBatch().getAttachments();
        if (attachments != null) {
            for (String f : archiveAttachments.getAttachedFiles()) {
                attachments.addFileAttachment(f);
            }
        }
        batchManager.discardActiveBatch();
        if (holdbackBatch != null) {
            batchManager.activateHeldbackBatch(holdbackBatch);
            Attachments activeAttachments = batchManager.getActiveBatch().getAttachments();
            for (int i = activeAttachments.getAttachedFiles().size(); i < archiveAttachments.getAttachedFiles().size(); ++i) {
                activeAttachments.addFileAttachment(archiveAttachments.getAttachedFiles().get(i));
            }
            activeAttachments.addConsumer(listener);
        }
    }

    @Override
    public BatchCompliantCommand.BatchResponseHandler buildBatchResponseHandler(CommandContext commandContext, Attachments attachments) {
        return null;
    }
}

