/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jsonb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Priority;
import javax.json.bind.Jsonb;
import javax.ws.rs.Consumes;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.io.input.ProxyInputStream;
import org.jboss.resteasy.plugins.providers.jsonb.AbstractJsonBindingProvider;
import org.jboss.resteasy.plugins.providers.jsonb.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.Types;

@Provider
@Produces(value={"application/json", "application/*+json", "text/json", "*/*"})
@Consumes(value={"application/json", "application/*+json", "text/json", "*/*"})
@Priority(value=4900)
public class JsonBindingProvider
extends AbstractJsonBindingProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private final boolean disabled;

    public JsonBindingProvider() {
        ResteasyConfiguration context = (ResteasyConfiguration)ResteasyProviderFactory.getContextData(ResteasyConfiguration.class);
        this.disabled = context != null && (Boolean.parseBoolean(context.getParameter("resteasy.preferJacksonOverJsonB")) || Boolean.parseBoolean(context.getParameter("resteasy.jsonp.enable")));
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.disabled) {
            return false;
        }
        if (this.isGenericJaxb(type, genericType)) {
            return false;
        }
        return JsonBindingProvider.isSupportedMediaType(mediaType) && (FindAnnotation.hasJsonBindingAnnotations((Annotation[])annotations) || !this.isJaxbClass(type));
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Jsonb jsonb = this.getJsonb(type);
        EmptyCheckInputStream is = new EmptyCheckInputStream(entityStream);
        try {
            return jsonb.fromJson((InputStream)((Object)is), genericType);
        }
        catch (Throwable e) {
            if (is.isEmpty()) {
                return null;
            }
            throw new ProcessingException(Messages.MESSAGES.jsonBDeserializationError(e));
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.disabled) {
            return false;
        }
        if (this.isGenericJaxb(type, genericType)) {
            return false;
        }
        return JsonBindingProvider.isSupportedMediaType(mediaType) && (FindAnnotation.hasJsonBindingAnnotations((Annotation[])annotations) || !this.isJaxbClass(type));
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Jsonb jsonb = this.getJsonb(type);
        try {
            entityStream.write(jsonb.toJson(t).getBytes(JsonBindingProvider.getCharset(mediaType)));
            entityStream.flush();
        }
        catch (Throwable e) {
            throw new ProcessingException(Messages.MESSAGES.jsonBSerializationError(e.toString()));
        }
    }

    private boolean isGenericJaxb(Class<?> type, Type genericType) {
        Class baseType;
        Class valueType;
        if (Map.class.isAssignableFrom(type) && genericType != null && (valueType = Types.getMapValueType((Type)genericType)) != null && this.isJaxbClass(valueType)) {
            return true;
        }
        return (Collection.class.isAssignableFrom(type) || type.isArray()) && genericType != null && (baseType = Types.getCollectionBaseType(type, (Type)genericType)) != null && this.isJaxbClass(baseType);
    }

    private boolean isJaxbClass(Class<?> classType) {
        if (JAXBElement.class.equals(classType)) {
            return true;
        }
        for (Annotation a : classType.getAnnotations()) {
            Class<? extends Annotation> c = a.annotationType();
            if (!c.equals(XmlRootElement.class) && !c.equals(XmlType.class) && !c.equals(XmlJavaTypeAdapter.class) && !c.equals(XmlSeeAlso.class)) continue;
            return true;
        }
        return false;
    }

    private class EmptyCheckInputStream
    extends ProxyInputStream {
        boolean read;
        boolean empty;

        public EmptyCheckInputStream(InputStream proxy) {
            super(proxy);
            this.read = false;
            this.empty = false;
        }

        protected synchronized void afterRead(int n) throws IOException {
            if (!this.read && n <= 0) {
                this.empty = true;
            }
            this.read = true;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }
}

