/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterTableRenameColumn
extends SchemaCommand {
    private boolean ifTableExists;
    private String tableName;
    private String oldName;
    private String newName;

    public AlterTableRenameColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfTableExists(boolean b) {
        this.ifTableExists = b;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setOldColumnName(String oldName) {
        this.oldName = oldName;
    }

    public void setNewColumnName(String newName) {
        this.newName = newName;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        Table table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.tableName);
        }
        Column column = table.getColumn(this.oldName);
        this.session.getUser().checkRight(table, 15);
        table.checkSupportAlter();
        Expression newCheckExpr = column.getCheckConstraint(this.session, this.newName);
        table.renameColumn(column, this.newName);
        column.removeCheckConstraint();
        column.addCheckConstraint(this.session, newCheckExpr);
        table.setModified();
        db.updateMeta(this.session, table);
        for (DbObject child : table.getChildren()) {
            if (child.getCreateSQL() == null) continue;
            db.updateMeta(this.session, child);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 16;
    }
}

