/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.api.Aggregate;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.engine.Session;
import org.h2.engine.UserAggregate;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class JavaAggregate
extends Expression {
    private final UserAggregate userAggregate;
    private final Select select;
    private final Expression[] args;
    private int[] argTypes;
    private int dataType;
    private Connection userConnection;
    private int lastGroupRowId;

    public JavaAggregate(UserAggregate userAggregate, Expression[] args, Select select) {
        this.userAggregate = userAggregate;
        this.args = args;
        this.select = select;
    }

    @Override
    public int getCost() {
        int cost = 5;
        for (Expression e : this.args) {
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getScale() {
        return DataType.getDataType((int)this.dataType).defaultScale;
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder();
        buff.append(Parser.quoteIdentifier(this.userAggregate.getName())).append('(');
        for (Expression e : this.args) {
            buff.appendExceptFirst(", ");
            buff.append(e.getSQL());
        }
        return buff.append(')').toString();
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 1: 
            case 2: {
                return false;
            }
            case 7: {
                visitor.addDependency(this.userAggregate);
                break;
            }
        }
        for (Expression e : this.args) {
            if (e == null || e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        for (Expression arg : this.args) {
            arg.mapColumns(resolver, level);
        }
    }

    @Override
    public Expression optimize(Session session) {
        this.userConnection = session.createConnection(false);
        int len = this.args.length;
        this.argTypes = new int[len];
        for (int i = 0; i < len; ++i) {
            int type;
            Expression expr = this.args[i];
            this.args[i] = expr.optimize(session);
            this.argTypes[i] = type = expr.getType();
        }
        try {
            Aggregate aggregate = this.getInstance();
            this.dataType = aggregate.getInternalType(this.argTypes);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.args) {
            e.setEvaluatable(tableFilter, b);
        }
    }

    private Aggregate getInstance() throws SQLException {
        Aggregate agg = this.userAggregate.getInstance();
        agg.init(this.userConnection);
        return agg;
    }

    @Override
    public Value getValue(Session session) {
        HashMap<Expression, Object> group = this.select.getCurrentGroup();
        if (group == null) {
            throw DbException.get(90054, this.getSQL());
        }
        try {
            Object obj;
            Aggregate agg = (Aggregate)group.get(this);
            if (agg == null) {
                agg = this.getInstance();
            }
            if ((obj = agg.getResult()) == null) {
                return ValueNull.INSTANCE;
            }
            return DataType.convertToValue(session, obj, this.dataType);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    @Override
    public void updateAggregate(Session session) {
        HashMap<Expression, Object> group = this.select.getCurrentGroup();
        if (group == null) {
            return;
        }
        int groupRowId = this.select.getCurrentGroupRowId();
        if (this.lastGroupRowId == groupRowId) {
            return;
        }
        this.lastGroupRowId = groupRowId;
        Aggregate agg = (Aggregate)group.get(this);
        try {
            if (agg == null) {
                agg = this.getInstance();
                group.put(this, agg);
            }
            Object[] argValues = new Object[this.args.length];
            Object arg = null;
            int len = this.args.length;
            for (int i = 0; i < len; ++i) {
                Value v = this.args[i].getValue(session);
                v = v.convertTo(this.argTypes[i]);
                argValues[i] = arg = v.getObject();
            }
            if (this.args.length == 1) {
                agg.add(arg);
            } else {
                agg.add(argValues);
            }
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }
}

