/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.mvstore.type.StringDataType;
import org.h2.util.MathUtils;
import org.h2.util.New;

public class MVStore {
    public static final boolean ASSERT = false;
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE = 1;
    private static final int FORMAT_READ = 1;
    private static final int MARKED_FREE = 10000000;
    volatile BackgroundWriterThread backgroundWriterThread;
    private volatile boolean reuseSpace = true;
    private boolean closed;
    private FileStore fileStore;
    private boolean fileStoreIsProvided;
    private final int pageSplitSize;
    private CacheLongKeyLIRS<Page> cache;
    private CacheLongKeyLIRS<Page.PageChildren> cacheChunkRef;
    private Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, HashMap<Integer, Chunk>> freedPageSpace = new ConcurrentHashMap();
    private MVMap<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private HashMap<String, Object> storeHeader = New.hashMap();
    private WriteBuffer writeBuffer;
    private int lastMapId;
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    private final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private long currentVersion;
    private long lastStoredVersion;
    private int unsavedMemory;
    private int autoCommitMemory;
    private boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private Chunk retainChunk;
    private volatile long currentStoreVersion = -1L;
    private Thread currentStoreThread;
    private volatile boolean metaChanged;
    private int autoCommitDelay;
    private int autoCompactFillRate;
    private long autoCompactLastFileOpCount;
    private Object compactSync = new Object();
    private IllegalStateException panicException;
    private long lastTimeAbsolute;
    private long lastFreeUnusedChunks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MVStore(HashMap<String, Object> config) {
        int mb;
        Object o = config.get("compress");
        this.compressionLevel = o == null ? 0 : (Integer)o;
        String fileName = (String)config.get("fileName");
        o = config.get("pageSplitSize");
        this.pageSplitSize = o == null ? (fileName == null ? 4096 : 16384) : (Integer)o;
        o = config.get("backgroundExceptionHandler");
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)o;
        this.meta = new MVMap(StringDataType.INSTANCE, StringDataType.INSTANCE);
        HashMap<String, Object> c = New.hashMap();
        c.put("id", 0);
        c.put("createVersion", this.currentVersion);
        this.meta.init(this, c);
        this.fileStore = (FileStore)config.get("fileStore");
        if (fileName == null && this.fileStore == null) {
            this.cache = null;
            this.cacheChunkRef = null;
            return;
        }
        if (this.fileStore == null) {
            this.fileStoreIsProvided = false;
            this.fileStore = new FileStore();
        } else {
            this.fileStoreIsProvided = true;
        }
        this.retentionTime = this.fileStore.getDefaultRetentionTime();
        boolean readOnly = config.containsKey("readOnly");
        o = config.get("cacheSize");
        int n = mb = o == null ? 16 : (Integer)o;
        if (mb > 0) {
            CacheLongKeyLIRS.Config cc = new CacheLongKeyLIRS.Config();
            cc.maxMemory = (long)mb * 1024L * 1024L;
            o = config.get("cacheConcurrency");
            if (o != null) {
                cc.segmentCount = (Integer)o;
            }
            this.cache = new CacheLongKeyLIRS(cc);
            cc.maxMemory /= 4L;
            this.cacheChunkRef = new CacheLongKeyLIRS(cc);
        }
        int kb = (o = config.get("autoCommitBufferSize")) == null ? 1024 : (Integer)o;
        this.autoCommitMemory = kb * 1024 * 19;
        o = config.get("autoCompactFillRate");
        this.autoCompactFillRate = o == null ? 50 : (Integer)o;
        char[] encryptionKey = (char[])config.get("encryptionKey");
        try {
            if (!this.fileStoreIsProvided) {
                this.fileStore.open(fileName, readOnly, encryptionKey);
            }
            if (this.fileStore.size() == 0L) {
                this.lastCommitTime = this.creationTime = this.getTimeAbsolute();
                this.storeHeader.put("H", 2);
                this.storeHeader.put("blockSize", 4096);
                this.storeHeader.put("format", 1);
                this.storeHeader.put("created", this.creationTime);
                this.writeStoreHeader();
            } else {
                this.readStoreHeader();
            }
        }
        catch (IllegalStateException e) {
            this.panic(e);
        }
        finally {
            if (encryptionKey != null) {
                Arrays.fill(encryptionKey, '\u0000');
            }
        }
        this.lastCommitTime = this.getTimeSinceCreation();
        o = config.get("autoCommitDelay");
        int delay = o == null ? 1000 : (Integer)o;
        this.setAutoCommitDelay(delay);
    }

    private void panic(IllegalStateException e) {
        if (this.backgroundExceptionHandler != null) {
            this.backgroundExceptionHandler.uncaughtException(null, e);
        }
        this.panicException = e;
        this.closeImmediately();
        throw e;
    }

    public static MVStore open(String fileName) {
        HashMap<String, Object> config = New.hashMap();
        config.put("fileName", fileName);
        return new MVStore(config);
    }

    <T extends MVMap<?, ?>> T openMapVersion(long version, int mapId, MVMap<?, ?> template) {
        MVMap<String, String> oldMeta = this.getMetaMap(version);
        long rootPos = MVStore.getRootPos(oldMeta, mapId);
        MVMap<?, ?> m = template.openReadOnly();
        m.setRootPos(rootPos, version);
        return (T)m;
    }

    public <K, V> MVMap<K, V> openMap(String name) {
        return this.openMap(name, new MVMap.Builder());
    }

    public synchronized <M extends MVMap<K, V>, K, V> M openMap(String name, MVMap.MapBuilder<M, K, V> builder) {
        long root;
        M map;
        int id;
        this.checkOpen();
        String x = this.meta.get("name." + name);
        if (x != null) {
            id = DataUtils.parseHexInt(x);
            MVMap<?, ?> old = this.maps.get(id);
            if (old != null) {
                return (M)old;
            }
            map = builder.create();
            String config = this.meta.get(MVMap.getMapKey(id));
            HashMap<String, Object> c = New.hashMap();
            c.putAll(DataUtils.parseMap(config));
            c.put("id", id);
            ((MVMap)map).init(this, c);
            root = MVStore.getRootPos(this.meta, id);
        } else {
            HashMap<String, Object> c = New.hashMap();
            id = ++this.lastMapId;
            c.put("id", id);
            c.put("createVersion", this.currentVersion);
            map = builder.create();
            ((MVMap)map).init(this, c);
            this.markMetaChanged();
            x = Integer.toHexString(id);
            this.meta.put(MVMap.getMapKey(id), ((MVMap)map).asString(name));
            this.meta.put("name." + name, x);
            root = 0L;
        }
        ((MVMap)map).setRootPos(root, -1L);
        this.maps.put(id, (MVMap<?, ?>)map);
        return map;
    }

    public synchronized Set<String> getMapNames() {
        String x;
        HashSet<String> set = New.hashSet();
        this.checkOpen();
        Iterator<String> it = this.meta.keyIterator("name.");
        while (it.hasNext() && (x = it.next()).startsWith("name.")) {
            set.add(x.substring("name.".length()));
        }
        return set;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long version) {
        Chunk c = this.getChunkForVersion(version);
        DataUtils.checkArgument(c != null, "Unknown version {0}", version);
        c = this.readChunkHeader(c.block);
        MVMap<String, String> oldMeta = this.meta.openReadOnly();
        oldMeta.setRootPos(c.metaRootPos, version);
        return oldMeta;
    }

    private Chunk getChunkForVersion(long version) {
        Chunk newest = null;
        for (Chunk c : this.chunks.values()) {
            if (c.version > version || newest != null && c.id <= newest.id) continue;
            newest = c;
        }
        return newest;
    }

    public boolean hasMap(String name) {
        return this.meta.containsKey("name." + name);
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private synchronized void readStoreHeader() {
        Chunk newest = null;
        boolean validStoreHeader = false;
        ByteBuffer fileHeaderBlocks = this.fileStore.readFully(0L, 8192);
        byte[] buff = new byte[4096];
        for (int i = 0; i <= 4096; i += 4096) {
            fileHeaderBlocks.get(buff);
            try {
                String s = new String(buff, 0, 4096, DataUtils.LATIN).trim();
                HashMap<String, String> m = DataUtils.parseMap(s);
                int blockSize = DataUtils.readHexInt(m, "blockSize", 4096);
                if (blockSize != 4096) {
                    throw DataUtils.newIllegalStateException(5, "Block size {0} is currently not supported", blockSize);
                }
                int check = DataUtils.readHexInt(m, "fletcher", 0);
                m.remove("fletcher");
                s = s.substring(0, s.lastIndexOf("fletcher") - 1);
                byte[] bytes = s.getBytes(DataUtils.LATIN);
                int checksum = DataUtils.getFletcher32(bytes, bytes.length);
                if (check != checksum) continue;
                long version = DataUtils.readHexLong(m, "version", 0L);
                if (newest != null && version <= newest.version) continue;
                validStoreHeader = true;
                this.storeHeader.putAll(m);
                this.creationTime = DataUtils.readHexLong(m, "created", 0L);
                int chunkId = DataUtils.readHexInt(m, "chunk", 0);
                long block = DataUtils.readHexLong(m, "block", 0L);
                Chunk test = this.readChunkHeaderAndFooter(block);
                if (test == null || test.id != chunkId) continue;
                newest = test;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!validStoreHeader) {
            throw DataUtils.newIllegalStateException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        long format = DataUtils.readHexLong(this.storeHeader, "format", 1L);
        if (format > 1L && !this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(5, "The write format {0} is larger than the supported format {1}, and the file was not opened in read-only mode", format, 1);
        }
        if ((format = DataUtils.readHexLong(this.storeHeader, "formatRead", format)) > 1L) {
            throw DataUtils.newIllegalStateException(5, "The read format {0} is larger than the supported format {1}", format, 1);
        }
        this.lastStoredVersion = -1L;
        this.chunks.clear();
        long now = System.currentTimeMillis();
        int year = 1970 + (int)(now / 31557600000L);
        if (year < 2014) {
            this.creationTime = now - (long)this.fileStore.getDefaultRetentionTime();
        } else if (now < this.creationTime) {
            this.creationTime = now;
            this.storeHeader.put("created", this.creationTime);
        }
        Chunk test = this.readChunkFooter(this.fileStore.size());
        if (test != null && (test = this.readChunkHeaderAndFooter(test.block)) != null && (newest == null || test.version > newest.version)) {
            newest = test;
        }
        if (newest == null) {
            return;
        }
        while (newest.next != 0L && newest.next < this.fileStore.size() / 4096L && (test = this.readChunkHeaderAndFooter(newest.next)) != null && test.id > newest.id) {
            newest = test;
        }
        this.setLastChunk(newest);
        this.loadChunkMeta();
        this.verifyLastChunks();
        for (Chunk c : this.chunks.values()) {
            if (c.pageCountLive == 0) {
                this.registerFreePage(this.currentVersion, c.id, 0L, 0);
            }
            long start = c.block * 4096L;
            int length = c.len * 4096;
            this.fileStore.markUsed(start, length);
        }
    }

    private void loadChunkMeta() {
        String s;
        Iterator<String> it = this.meta.keyIterator("chunk.");
        while (it.hasNext() && (s = it.next()).startsWith("chunk.")) {
            s = this.meta.get(s);
            Chunk c = Chunk.fromString(s);
            if (this.chunks.containsKey(c.id)) continue;
            if (c.block == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", c.id);
            }
            this.chunks.put(c.id, c);
        }
    }

    private void setLastChunk(Chunk last) {
        this.lastChunk = last;
        if (last == null) {
            this.lastMapId = 0;
            this.currentVersion = 0L;
            this.meta.setRootPos(0L, -1L);
        } else {
            this.lastMapId = last.mapId;
            this.currentVersion = last.version;
            this.chunks.put(last.id, last);
            this.meta.setRootPos(last.metaRootPos, -1L);
        }
        this.setWriteVersion(this.currentVersion);
    }

    private void verifyLastChunks() {
        Chunk newest;
        long time = this.getTimeSinceCreation();
        ArrayList ids = new ArrayList(this.chunks.keySet());
        Collections.sort(ids);
        int newestValidChunk = -1;
        Chunk old = null;
        for (Integer chunkId : ids) {
            Chunk c = this.chunks.get(chunkId);
            if (old != null && c.time < old.time) break;
            old = c;
            if (c.time + (long)this.retentionTime < time) {
                newestValidChunk = c.id;
                continue;
            }
            Chunk test = this.readChunkHeaderAndFooter(c.block);
            if (test == null || test.id != c.id) break;
            newestValidChunk = chunkId;
        }
        if ((newest = this.chunks.get(newestValidChunk)) != this.lastChunk) {
            this.rollbackTo(newest == null ? 0L : newest.version);
        }
    }

    private Chunk readChunkHeaderAndFooter(long block) {
        Chunk header;
        try {
            header = this.readChunkHeader(block);
        }
        catch (Exception e) {
            return null;
        }
        if (header == null) {
            return null;
        }
        Chunk footer = this.readChunkFooter((block + (long)header.len) * 4096L);
        if (footer == null || footer.id != header.id) {
            return null;
        }
        return header;
    }

    private Chunk readChunkFooter(long end) {
        try {
            ByteBuffer lastBlock = this.fileStore.readFully(end - 128L, 128);
            byte[] buff = new byte[128];
            lastBlock.get(buff);
            String s = new String(buff, DataUtils.LATIN).trim();
            HashMap<String, String> m = DataUtils.parseMap(s);
            int check = DataUtils.readHexInt(m, "fletcher", 0);
            m.remove("fletcher");
            s = s.substring(0, s.lastIndexOf("fletcher") - 1);
            byte[] bytes = s.getBytes(DataUtils.LATIN);
            int checksum = DataUtils.getFletcher32(bytes, bytes.length);
            if (check == checksum) {
                int chunk = DataUtils.readHexInt(m, "chunk", 0);
                Chunk c = new Chunk(chunk);
                c.version = DataUtils.readHexLong(m, "version", 0L);
                c.block = DataUtils.readHexLong(m, "block", 0L);
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeStoreHeader() {
        StringBuilder buff = new StringBuilder();
        if (this.lastChunk != null) {
            this.storeHeader.put("block", this.lastChunk.block);
            this.storeHeader.put("chunk", this.lastChunk.id);
            this.storeHeader.put("version", this.lastChunk.version);
        }
        DataUtils.appendMap(buff, this.storeHeader);
        byte[] bytes = buff.toString().getBytes(DataUtils.LATIN);
        int checksum = DataUtils.getFletcher32(bytes, bytes.length);
        DataUtils.appendMap(buff, "fletcher", checksum);
        buff.append("\n");
        bytes = buff.toString().getBytes(DataUtils.LATIN);
        ByteBuffer header = ByteBuffer.allocate(8192);
        header.put(bytes);
        header.position(4096);
        header.put(bytes);
        header.rewind();
        this.write(0L, header);
    }

    private void write(long pos, ByteBuffer buffer) {
        try {
            this.fileStore.writeFully(pos, buffer);
        }
        catch (IllegalStateException e) {
            this.panic(e);
            throw e;
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        FileStore f = this.fileStore;
        if (f != null && !f.isReadOnly()) {
            this.stopBackgroundThread();
            if (this.hasUnsavedChanges()) {
                this.commitAndSave();
            }
        }
        this.closeStore(true);
    }

    public void closeImmediately() {
        block2: {
            try {
                this.closeStore(false);
            }
            catch (Exception e) {
                if (this.backgroundExceptionHandler == null) break block2;
                this.backgroundExceptionHandler.uncaughtException(null, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean shrinkIfPossible) {
        if (this.closed) {
            return;
        }
        this.stopBackgroundThread();
        this.closed = true;
        if (this.fileStore == null) {
            return;
        }
        MVStore mVStore = this;
        synchronized (mVStore) {
            if (shrinkIfPossible) {
                this.shrinkFileIfPossible(0);
            }
            this.cache = null;
            this.cacheChunkRef = null;
            for (MVMap<?, ?> m : New.arrayList(this.maps.values())) {
                m.close();
            }
            this.meta = null;
            this.chunks.clear();
            this.maps.clear();
            try {
                if (!this.fileStoreIsProvided) {
                    this.fileStore.close();
                }
            }
            finally {
                this.fileStore = null;
            }
        }
    }

    boolean isChunkLive(int chunkId) {
        String s = this.meta.get(Chunk.getMetaKey(chunkId));
        return s != null;
    }

    private Chunk getChunk(long pos) {
        Chunk c = this.getChunkIfFound(pos);
        if (c == null) {
            int chunkId = DataUtils.getPageChunkId(pos);
            throw DataUtils.newIllegalStateException(6, "Chunk {0} not found", chunkId);
        }
        return c;
    }

    private Chunk getChunkIfFound(long pos) {
        int chunkId = DataUtils.getPageChunkId(pos);
        Chunk c = this.chunks.get(chunkId);
        if (c == null) {
            this.checkOpen();
            if (!Thread.holdsLock(this)) {
                throw DataUtils.newIllegalStateException(9, "Chunk {0} no longer exists", chunkId);
            }
            String s = this.meta.get(Chunk.getMetaKey(chunkId));
            if (s == null) {
                return null;
            }
            c = Chunk.fromString(s);
            if (c.block == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", chunkId);
            }
            this.chunks.put(c.id, c);
        }
        return c;
    }

    private void setWriteVersion(long version) {
        for (MVMap<?, ?> map : this.maps.values()) {
            map.setWriteVersion(version);
        }
        MVMap<String, String> m = this.meta;
        if (m == null) {
            this.checkOpen();
        }
        m.setWriteVersion(version);
    }

    public long commit() {
        if (this.fileStore != null) {
            return this.commitAndSave();
        }
        long v = ++this.currentVersion;
        this.setWriteVersion(v);
        return v;
    }

    private synchronized long commitAndSave() {
        if (this.closed) {
            return this.currentVersion;
        }
        if (this.fileStore == null) {
            throw DataUtils.newIllegalStateException(2, "This is an in-memory store", new Object[0]);
        }
        if (this.currentStoreVersion >= 0L) {
            return this.currentVersion;
        }
        if (!this.hasUnsavedChanges()) {
            return this.currentVersion;
        }
        if (this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(2, "This store is read-only", new Object[0]);
        }
        try {
            this.currentStoreVersion = this.currentVersion;
            this.currentStoreThread = Thread.currentThread();
            long l = this.storeNow();
            return l;
        }
        finally {
            this.currentStoreVersion = -1L;
            this.currentStoreThread = null;
        }
    }

    private long storeNow() {
        try {
            return this.storeNowTry();
        }
        catch (IllegalStateException e) {
            this.panic(e);
            return -1L;
        }
    }

    private long storeNowTry() {
        boolean storeAtEndOfFile;
        Chunk old;
        int lastChunkId;
        int freeDelay;
        long time = this.getTimeSinceCreation();
        if (time >= this.lastFreeUnusedChunks + (long)(freeDelay = this.retentionTime / 10)) {
            this.lastFreeUnusedChunks = time;
            this.freeUnusedChunks();
            this.lastFreeUnusedChunks = this.getTimeSinceCreation();
        }
        int currentUnsavedPageCount = this.unsavedMemory;
        long storeVersion = this.currentStoreVersion;
        long version = ++this.currentVersion;
        this.setWriteVersion(version);
        this.lastCommitTime = time;
        this.retainChunk = null;
        if (this.lastChunk == null) {
            lastChunkId = 0;
        } else {
            lastChunkId = this.lastChunk.id;
            this.meta.put(Chunk.getMetaKey(lastChunkId), this.lastChunk.asString());
            time = Math.max(this.lastChunk.time, time);
        }
        int newChunkId = lastChunkId;
        while ((old = this.chunks.get(newChunkId = (newChunkId + 1) % 0x3FFFFFF)) != null) {
            if (old.block != Long.MAX_VALUE) continue;
            IllegalStateException e = DataUtils.newIllegalStateException(3, "Last block not stored, possibly due to out-of-memory", new Object[0]);
            this.panic(e);
        }
        Chunk c = new Chunk(newChunkId);
        c.pageCount = Integer.MAX_VALUE;
        c.pageCountLive = Integer.MAX_VALUE;
        c.maxLen = Long.MAX_VALUE;
        c.maxLenLive = Long.MAX_VALUE;
        c.metaRootPos = Long.MAX_VALUE;
        c.block = Long.MAX_VALUE;
        c.len = Integer.MAX_VALUE;
        c.time = time;
        c.version = version;
        c.mapId = this.lastMapId;
        c.next = Long.MAX_VALUE;
        this.chunks.put(c.id, c);
        this.meta.put(Chunk.getMetaKey(c.id), c.asString());
        this.meta.remove(Chunk.getMetaKey(c.id));
        ArrayList<MVMap<?, ?>> list = New.arrayList(this.maps.values());
        ArrayList<MVMap> changed = New.arrayList();
        for (MVMap<?, ?> m : list) {
            MVMap<?, ?> r;
            m.setWriteVersion(version);
            long v = m.getVersion();
            if (m.getCreateVersion() > storeVersion || m.isVolatile() || v < 0L || v < this.lastStoredVersion || (r = m.openVersion(storeVersion)).getRoot().getPos() != 0L) continue;
            changed.add(r);
        }
        this.applyFreedSpace(storeVersion);
        WriteBuffer buff = this.getWriteBuffer();
        c.writeChunkHeader(buff, 0);
        int headerLength = buff.position();
        c.pageCount = 0;
        c.pageCountLive = 0;
        c.maxLen = 0L;
        c.maxLenLive = 0L;
        for (MVMap m : changed) {
            Page p = m.getRoot();
            String key = MVMap.getMapRootKey(m.getId());
            if (p.getTotalCount() == 0L) {
                this.meta.put(key, "0");
                continue;
            }
            p.writeUnsavedRecursive(c, buff);
            long root = p.getPos();
            this.meta.put(key, Long.toHexString(root));
        }
        this.meta.setWriteVersion(version);
        Page metaRoot = this.meta.getRoot();
        metaRoot.writeUnsavedRecursive(c, buff);
        int chunkLength = buff.position();
        int length = MathUtils.roundUpInt(chunkLength + 128, 4096);
        buff.limit(length);
        long end = this.getFileLengthInUse();
        long filePos = this.reuseSpace ? this.fileStore.allocate(length) : end;
        boolean bl = storeAtEndOfFile = filePos + (long)length >= this.fileStore.size();
        if (!this.reuseSpace) {
            this.fileStore.markUsed(end, length);
        }
        c.block = filePos / 4096L;
        c.len = length / 4096;
        c.metaRootPos = metaRoot.getPos();
        if (this.reuseSpace) {
            int predictBlocks = c.len;
            long predictedNextStart = this.fileStore.allocate(predictBlocks * 4096);
            this.fileStore.free(predictedNextStart, predictBlocks * 4096);
            c.next = predictedNextStart / 4096L;
        } else {
            c.next = 0L;
        }
        buff.position(0);
        c.writeChunkHeader(buff, headerLength);
        this.revertTemp(storeVersion);
        buff.position(buff.limit() - 128);
        buff.put(c.getFooterBytes());
        buff.position(0);
        this.write(filePos, buff.getBuffer());
        this.releaseWriteBuffer(buff);
        boolean writeStoreHeader = false;
        if (!storeAtEndOfFile) {
            if (this.lastChunk == null) {
                writeStoreHeader = true;
            } else if (this.lastChunk.next != c.block) {
                writeStoreHeader = true;
            } else {
                long headerVersion = DataUtils.readHexLong(this.storeHeader, "version", 0L);
                if (this.lastChunk.version - headerVersion > 20L) {
                    writeStoreHeader = true;
                } else {
                    int chunkId = DataUtils.readHexInt(this.storeHeader, "chunk", 0);
                    while (true) {
                        Chunk old2;
                        if ((old2 = this.chunks.get(chunkId)) == null) {
                            writeStoreHeader = true;
                            break;
                        }
                        if (chunkId == this.lastChunk.id) break;
                        ++chunkId;
                    }
                }
            }
        }
        this.lastChunk = c;
        if (writeStoreHeader) {
            this.writeStoreHeader();
        }
        if (!storeAtEndOfFile) {
            this.shrinkFileIfPossible(1);
        }
        for (MVMap m : changed) {
            Page p = m.getRoot();
            if (p.getTotalCount() <= 0L) continue;
            p.writeEnd();
        }
        metaRoot.writeEnd();
        this.unsavedMemory = Math.max(0, this.unsavedMemory - currentUnsavedPageCount);
        this.metaChanged = false;
        this.lastStoredVersion = storeVersion;
        return version;
    }

    private synchronized void freeUnusedChunks() {
        if (this.lastChunk == null || !this.reuseSpace) {
            return;
        }
        Set<Integer> referenced = this.collectReferencedChunks();
        ArrayList<Chunk> free = New.arrayList();
        long time = this.getTimeSinceCreation();
        for (Chunk c : this.chunks.values()) {
            if (referenced.contains(c.id)) continue;
            free.add(c);
        }
        for (Chunk c : free) {
            if (this.canOverwriteChunk(c, time)) {
                this.chunks.remove(c.id);
                this.markMetaChanged();
                this.meta.remove(Chunk.getMetaKey(c.id));
                long start = c.block * 4096L;
                int length = c.len * 4096;
                this.fileStore.free(start, length);
                continue;
            }
            if (c.unused != 0L) continue;
            c.unused = time;
            this.meta.put(Chunk.getMetaKey(c.id), c.asString());
            this.markMetaChanged();
        }
    }

    private Set<Integer> collectReferencedChunks() {
        String key;
        long testVersion = this.lastChunk.version;
        DataUtils.checkArgument(testVersion > 0L, "Collect references on version 0", new Object[0]);
        long readCount = this.getFileStore().readCount;
        HashSet<Integer> referenced = New.hashSet();
        Cursor<String, String> c = this.meta.cursor("root.");
        while (c.hasNext() && (key = c.next()).startsWith("root.")) {
            long pos = DataUtils.parseHexLong(c.getValue());
            if (pos == 0L) continue;
            int mapId = DataUtils.parseHexInt(key.substring("root.".length()));
            this.collectReferencedChunks(referenced, mapId, pos, 0);
        }
        long pos = this.lastChunk.metaRootPos;
        this.collectReferencedChunks(referenced, 0, pos, 0);
        readCount = this.fileStore.readCount - readCount;
        return referenced;
    }

    private void collectReferencedChunks(Set<Integer> targetChunkSet, int mapId, long pos, int level) {
        int c = DataUtils.getPageChunkId(pos);
        targetChunkSet.add(c);
        if (DataUtils.getPageType(pos) == 0) {
            return;
        }
        Page.PageChildren refs = this.readPageChunkReferences(mapId, pos, -1);
        if (!refs.chunkList) {
            HashSet<Integer> target = New.hashSet();
            for (int i = 0; i < refs.children.length; ++i) {
                long p = refs.children[i];
                this.collectReferencedChunks(target, mapId, p, level + 1);
            }
            target.remove(c);
            long[] children = new long[target.size()];
            int i = 0;
            for (Integer p : target) {
                children[i++] = DataUtils.getPagePos(p, 0, 0, 0);
            }
            refs.children = children;
            refs.chunkList = true;
            if (this.cacheChunkRef != null) {
                this.cacheChunkRef.put(refs.pos, refs, refs.getMemory());
            }
        }
        for (long p : refs.children) {
            targetChunkSet.add(DataUtils.getPageChunkId(p));
        }
    }

    private Page.PageChildren readPageChunkReferences(int mapId, long pos, int parentChunk) {
        int chunk;
        if (DataUtils.getPageType(pos) == 0) {
            return null;
        }
        Page.PageChildren r = this.cacheChunkRef != null ? this.cacheChunkRef.get(pos) : null;
        if (r == null) {
            Page p;
            if (this.cache != null && (p = this.cache.get(pos)) != null) {
                r = new Page.PageChildren(p);
            }
            if (r == null) {
                Chunk c = this.getChunk(pos);
                long filePos = c.block * 4096L;
                if ((filePos += (long)DataUtils.getPageOffset(pos)) < 0L) {
                    throw DataUtils.newIllegalStateException(6, "Negative position {0}; p={1}, c={2}", filePos, pos, c.toString());
                }
                long maxPos = (c.block + (long)c.len) * 4096L;
                r = Page.PageChildren.read(this.fileStore, pos, mapId, filePos, maxPos);
            }
            r.removeDuplicateChunkReferences();
            if (this.cacheChunkRef != null) {
                this.cacheChunkRef.put(pos, r, r.getMemory());
            }
        }
        if (r.children.length == 0 && (chunk = DataUtils.getPageChunkId(pos)) == parentChunk) {
            return null;
        }
        return r;
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer buff;
        if (this.writeBuffer != null) {
            buff = this.writeBuffer;
            buff.clear();
        } else {
            buff = new WriteBuffer();
        }
        return buff;
    }

    private void releaseWriteBuffer(WriteBuffer buff) {
        if (buff.capacity() <= 0x400000) {
            this.writeBuffer = buff;
        }
    }

    private boolean canOverwriteChunk(Chunk c, long time) {
        Chunk r;
        if (this.retentionTime >= 0) {
            if (c.time + (long)this.retentionTime > time) {
                return false;
            }
            if (c.unused == 0L || c.unused + (long)(this.retentionTime / 2) > time) {
                return false;
            }
        }
        return (r = this.retainChunk) == null || c.version <= r.version;
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.getTimeAbsolute() - this.creationTime);
    }

    private long getTimeAbsolute() {
        long now = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && now < this.lastTimeAbsolute) {
            now = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = now;
        }
        return now;
    }

    private void applyFreedSpace(long storeVersion) {
        ArrayList<Chunk> modified;
        do {
            modified = New.arrayList();
            Iterator<Map.Entry<Long, HashMap<Integer, Chunk>>> it = this.freedPageSpace.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, HashMap<Integer, Chunk>> e = it.next();
                long v = e.getKey();
                if (v > storeVersion) continue;
                HashMap<Integer, Chunk> freed = e.getValue();
                for (Chunk f : freed.values()) {
                    Chunk c = this.chunks.get(f.id);
                    if (c == null) continue;
                    c.maxLenLive += f.maxLenLive;
                    c.pageCountLive += f.pageCountLive;
                    if (c.pageCountLive < 0 && c.pageCountLive > -10000000) {
                        c.pageCountLive = 0;
                    }
                    if (c.maxLenLive < 0L && c.maxLenLive > -10000000L) {
                        c.maxLenLive = 0L;
                    }
                    modified.add(c);
                }
                it.remove();
            }
            for (Chunk c : modified) {
                this.meta.put(Chunk.getMetaKey(c.id), c.asString());
            }
        } while (modified.size() != 0);
    }

    private void shrinkFileIfPossible(int minPercent) {
        long fileSize;
        if (this.fileStore.isReadOnly()) {
            return;
        }
        long end = this.getFileLengthInUse();
        if (end >= (fileSize = this.fileStore.size())) {
            return;
        }
        if (minPercent > 0 && fileSize - end < 4096L) {
            return;
        }
        int savedPercent = (int)(100L - end * 100L / fileSize);
        if (savedPercent < minPercent) {
            return;
        }
        if (!this.closed) {
            this.sync();
        }
        this.fileStore.truncate(end);
    }

    private long getFileLengthInUse() {
        long size = 8192L;
        for (Chunk c : this.chunks.values()) {
            if (c.len == Integer.MAX_VALUE) continue;
            long x = (c.block + (long)c.len) * 4096L;
            size = Math.max(size, x);
        }
        return size;
    }

    public boolean hasUnsavedChanges() {
        this.checkOpen();
        if (this.metaChanged) {
            return true;
        }
        for (MVMap<?, ?> m : this.maps.values()) {
            long v;
            if (m.isClosed() || (v = m.getVersion()) < 0L || v <= this.lastStoredVersion) continue;
            return true;
        }
        return false;
    }

    private Chunk readChunkHeader(long block) {
        long p = block * 4096L;
        ByteBuffer buff = this.fileStore.readFully(p, 1024);
        return Chunk.readChunkHeader(buff, p);
    }

    public synchronized boolean compactRewriteFully() {
        this.checkOpen();
        if (this.lastChunk == null) {
            return false;
        }
        Iterator<MVMap<?, ?>> iterator = this.maps.values().iterator();
        while (iterator.hasNext()) {
            MVMap<?, ?> m;
            MVMap<?, ?> map = m = iterator.next();
            Cursor<Object, ?> cursor = map.cursor(null);
            Page lastPage = null;
            while (cursor.hasNext()) {
                cursor.next();
                Page p = cursor.getPage();
                if (p == lastPage) continue;
                Object k = p.getKey(0);
                Object v = p.getValue(0);
                map.put(k, v);
                lastPage = p;
            }
        }
        this.commitAndSave();
        return true;
    }

    public synchronized boolean compactMoveChunks() {
        return this.compactMoveChunks(100, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean compactMoveChunks(int targetFillRate, long moveSize) {
        this.checkOpen();
        if (this.lastChunk == null || !this.reuseSpace) {
            return false;
        }
        int oldRetentionTime = this.retentionTime;
        boolean oldReuse = this.reuseSpace;
        try {
            this.retentionTime = -1;
            this.freeUnusedChunks();
            if (this.fileStore.getFillRate() > targetFillRate) {
                boolean bl = false;
                return bl;
            }
            long start = this.fileStore.getFirstFree() / 4096L;
            ArrayList<Chunk> move = this.compactGetMoveBlocks(start, moveSize);
            this.compactMoveChunks(move);
            this.freeUnusedChunks();
            this.storeNow();
        }
        finally {
            this.reuseSpace = oldReuse;
            this.retentionTime = oldRetentionTime;
        }
        return true;
    }

    private ArrayList<Chunk> compactGetMoveBlocks(long startBlock, long moveSize) {
        ArrayList<Chunk> move = New.arrayList();
        for (Chunk c : this.chunks.values()) {
            if (c.block <= startBlock) continue;
            move.add(c);
        }
        Collections.sort(move, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk o1, Chunk o2) {
                return Long.signum(o1.block - o2.block);
            }
        });
        int count = 0;
        long size = 0L;
        for (Chunk c : move) {
            long chunkSize = (long)c.len * 4096L;
            if (size + chunkSize > moveSize) break;
            size += chunkSize;
            ++count;
        }
        while (move.size() > count && move.size() > 1) {
            move.remove(1);
        }
        return move;
    }

    private void compactMoveChunks(ArrayList<Chunk> move) {
        int chunkHeaderLen;
        ByteBuffer readBuff;
        int length;
        long start;
        WriteBuffer buff;
        for (Chunk c : move) {
            buff = this.getWriteBuffer();
            start = c.block * 4096L;
            length = c.len * 4096;
            buff.limit(length);
            readBuff = this.fileStore.readFully(start, length);
            Chunk.readChunkHeader(readBuff, start);
            chunkHeaderLen = readBuff.position();
            buff.position(chunkHeaderLen);
            buff.put(readBuff);
            long end = this.getFileLengthInUse();
            this.fileStore.markUsed(end, length);
            this.fileStore.free(start, length);
            c.block = end / 4096L;
            c.next = 0L;
            buff.position(0);
            c.writeChunkHeader(buff, chunkHeaderLen);
            buff.position(length - 128);
            buff.put(c.getFooterBytes());
            buff.position(0);
            this.write(end, buff.getBuffer());
            this.releaseWriteBuffer(buff);
            this.markMetaChanged();
            this.meta.put(Chunk.getMetaKey(c.id), c.asString());
        }
        this.reuseSpace = false;
        this.commitAndSave();
        this.sync();
        this.reuseSpace = true;
        for (Chunk c : move) {
            if (!this.chunks.containsKey(c.id)) continue;
            buff = this.getWriteBuffer();
            start = c.block * 4096L;
            length = c.len * 4096;
            buff.limit(length);
            readBuff = this.fileStore.readFully(start, length);
            Chunk.readChunkHeader(readBuff, 0L);
            chunkHeaderLen = readBuff.position();
            buff.position(chunkHeaderLen);
            buff.put(readBuff);
            long pos = this.fileStore.allocate(length);
            this.fileStore.free(start, length);
            buff.position(0);
            c.block = pos / 4096L;
            c.writeChunkHeader(buff, chunkHeaderLen);
            buff.position(length - 128);
            buff.put(c.getFooterBytes());
            buff.position(0);
            this.write(pos, buff.getBuffer());
            this.releaseWriteBuffer(buff);
            this.markMetaChanged();
            this.meta.put(Chunk.getMetaKey(c.id), c.asString());
        }
        this.commitAndSave();
        this.sync();
        this.shrinkFileIfPossible(0);
    }

    public void sync() {
        this.checkOpen();
        FileStore f = this.fileStore;
        if (f != null) {
            f.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compact(int targetFillRate, int write) {
        if (!this.reuseSpace) {
            return false;
        }
        Object object = this.compactSync;
        synchronized (object) {
            ArrayList<Chunk> old;
            this.checkOpen();
            MVStore mVStore = this;
            synchronized (mVStore) {
                old = this.compactGetOldChunks(targetFillRate, write);
            }
            if (old == null || old.size() == 0) {
                return false;
            }
            this.compactRewrite(old);
            return true;
        }
    }

    private ArrayList<Chunk> compactGetOldChunks(int targetFillRate, int write) {
        int fillRate;
        if (this.lastChunk == null) {
            return null;
        }
        long maxLengthSum = 0L;
        long maxLengthLiveSum = 0L;
        long time = this.getTimeSinceCreation();
        for (Chunk c : this.chunks.values()) {
            if (c.time + (long)this.retentionTime > time) continue;
            maxLengthSum += c.maxLen;
            maxLengthLiveSum += c.maxLenLive;
        }
        if (maxLengthLiveSum < 0L) {
            return null;
        }
        if (maxLengthSum <= 0L) {
            maxLengthSum = 1L;
        }
        if ((fillRate = (int)(100L * maxLengthLiveSum / maxLengthSum)) >= targetFillRate) {
            return null;
        }
        ArrayList<Chunk> old = New.arrayList();
        Chunk last = this.chunks.get(this.lastChunk.id);
        for (Chunk c : this.chunks.values()) {
            if (c.time + (long)this.retentionTime > time) continue;
            long age = last.version - c.version + 1L;
            c.collectPriority = (int)((long)(c.getFillRate() * 1000) / age);
            old.add(c);
        }
        if (old.size() == 0) {
            return null;
        }
        Collections.sort(old, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk o1, Chunk o2) {
                int comp = new Integer(o1.collectPriority).compareTo(o2.collectPriority);
                if (comp == 0) {
                    comp = new Long(o1.maxLenLive).compareTo(o2.maxLenLive);
                }
                return comp;
            }
        });
        long written = 0L;
        int chunkCount = 0;
        Chunk move = null;
        for (Chunk c : old) {
            if (move != null && c.collectPriority > 0 && written > (long)write) break;
            written += c.maxLenLive;
            ++chunkCount;
            move = c;
        }
        if (chunkCount < 1) {
            return null;
        }
        boolean remove = false;
        Iterator it = old.iterator();
        while (it.hasNext()) {
            Chunk c = (Chunk)it.next();
            if (move == c) {
                remove = true;
                continue;
            }
            if (!remove) continue;
            it.remove();
        }
        return old;
    }

    private void compactRewrite(ArrayList<Chunk> old) {
        HashSet<Integer> set = New.hashSet();
        for (Chunk chunk : old) {
            set.add(chunk.id);
        }
        for (MVMap mVMap : this.maps.values()) {
            MVMap map = mVMap;
            if (map.rewrite(set)) continue;
            return;
        }
        if (!this.meta.rewrite(set)) {
            return;
        }
        this.freeUnusedChunks();
        this.commitAndSave();
    }

    Page readPage(MVMap<?, ?> map, long pos) {
        Page p;
        if (pos == 0L) {
            throw DataUtils.newIllegalStateException(6, "Position 0", new Object[0]);
        }
        Page page = p = this.cache == null ? null : this.cache.get(pos);
        if (p == null) {
            Chunk c = this.getChunk(pos);
            long filePos = c.block * 4096L;
            if ((filePos += (long)DataUtils.getPageOffset(pos)) < 0L) {
                throw DataUtils.newIllegalStateException(6, "Negative position {0}", filePos);
            }
            long maxPos = (c.block + (long)c.len) * 4096L;
            p = Page.read(this.fileStore, pos, map, filePos, maxPos);
            this.cachePage(pos, p, p.getMemory());
        }
        return p;
    }

    void removePage(MVMap<?, ?> map, long pos, int memory) {
        if (pos == 0L) {
            this.unsavedMemory = Math.max(0, this.unsavedMemory - memory);
            return;
        }
        if (this.cache != null && DataUtils.getPageType(pos) == 0) {
            this.cache.remove(pos);
        }
        Chunk c = this.getChunk(pos);
        long version = this.currentVersion;
        if (map == this.meta && this.currentStoreVersion >= 0L && Thread.currentThread() == this.currentStoreThread) {
            version = this.currentStoreVersion;
        }
        this.registerFreePage(version, c.id, DataUtils.getPageMaxLength(pos), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFreePage(long version, int chunkId, long maxLengthLive, int pageCount) {
        HashMap<Integer, Chunk> freed = this.freedPageSpace.get(version);
        if (freed == null) {
            freed = New.hashMap();
            HashMap<Integer, Chunk> f2 = this.freedPageSpace.putIfAbsent(version, freed);
            if (f2 != null) {
                freed = f2;
            }
        }
        HashMap<Integer, Chunk> hashMap = freed;
        synchronized (hashMap) {
            Chunk f = freed.get(chunkId);
            if (f == null) {
                f = new Chunk(chunkId);
                freed.put(chunkId, f);
            }
            f.maxLenLive -= maxLengthLive;
            f.pageCountLive -= pageCount;
        }
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean reuseSpace) {
        this.reuseSpace = reuseSpace;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int ms) {
        this.retentionTime = ms;
    }

    public void setVersionsToKeep(int count) {
        this.versionsToKeep = count;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    long getOldestVersionToKeep() {
        long v = this.currentVersion;
        if (this.fileStore == null) {
            return v - (long)this.versionsToKeep;
        }
        long storeVersion = this.currentStoreVersion;
        if (storeVersion > -1L) {
            v = Math.min(v, storeVersion);
        }
        return v;
    }

    private boolean isKnownVersion(long version) {
        if (version > this.currentVersion || version < 0L) {
            return false;
        }
        if (version == this.currentVersion || this.chunks.size() == 0) {
            return true;
        }
        Chunk c = this.getChunkForVersion(version);
        if (c == null) {
            return false;
        }
        MVMap<String, String> oldMeta = this.getMetaMap(version);
        if (oldMeta == null) {
            return false;
        }
        try {
            String chunkKey;
            Iterator<String> it = oldMeta.keyIterator("chunk.");
            while (it.hasNext() && (chunkKey = it.next()).startsWith("chunk.")) {
                if (this.meta.containsKey(chunkKey)) continue;
                String s = oldMeta.get(chunkKey);
                Chunk c2 = Chunk.fromString(s);
                Chunk test = this.readChunkHeaderAndFooter(c2.block);
                if (test == null || test.id != c2.id) {
                    return false;
                }
                this.chunks.put(c2.id, c2);
            }
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    void registerUnsavedPage(int memory) {
        this.unsavedMemory += memory;
        int newValue = this.unsavedMemory;
        if (newValue > this.autoCommitMemory && this.autoCommitMemory > 0) {
            this.saveNeeded = true;
        }
    }

    void beforeWrite(MVMap<?, ?> map) {
        if (this.saveNeeded) {
            if (map == this.meta) {
                return;
            }
            this.saveNeeded = false;
            if (this.unsavedMemory > this.autoCommitMemory && this.autoCommitMemory > 0) {
                this.commitAndSave();
            }
        }
    }

    public int getStoreVersion() {
        this.checkOpen();
        String x = this.meta.get("setting.storeVersion");
        return x == null ? 0 : DataUtils.parseHexInt(x);
    }

    public synchronized void setStoreVersion(int version) {
        this.checkOpen();
        this.markMetaChanged();
        this.meta.put("setting.storeVersion", Integer.toHexString(version));
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    public synchronized void rollbackTo(long version) {
        this.checkOpen();
        if (version == 0L) {
            for (MVMap<?, ?> m : this.maps.values()) {
                m.close();
            }
            this.meta.clear();
            this.chunks.clear();
            if (this.fileStore != null) {
                this.fileStore.clear();
            }
            this.maps.clear();
            this.freedPageSpace.clear();
            this.currentVersion = version;
            this.setWriteVersion(version);
            this.metaChanged = false;
            return;
        }
        DataUtils.checkArgument(this.isKnownVersion(version), "Unknown version {0}", version);
        for (MVMap<?, ?> m : this.maps.values()) {
            m.rollbackTo(version);
        }
        for (long v = this.currentVersion; v >= version && this.freedPageSpace.size() != 0; --v) {
            this.freedPageSpace.remove(v);
        }
        this.meta.rollbackTo(version);
        this.metaChanged = false;
        boolean loadFromFile = false;
        ArrayList<Integer> remove = new ArrayList<Integer>();
        Chunk keep = null;
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.version > version) {
                remove.add(chunk.id);
                continue;
            }
            if (keep != null && keep.id >= chunk.id) continue;
            keep = chunk;
        }
        if (remove.size() > 0) {
            Collections.sort(remove, Collections.reverseOrder());
            this.revertTemp(version);
            loadFromFile = true;
            Iterator<Object> iterator = remove.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                Chunk c = this.chunks.remove(n);
                long start = c.block * 4096L;
                int length = c.len * 4096;
                this.fileStore.free(start, length);
                WriteBuffer buff = this.getWriteBuffer();
                buff.limit(length);
                Arrays.fill(buff.getBuffer().array(), (byte)0);
                this.write(start, buff.getBuffer());
                this.releaseWriteBuffer(buff);
                this.sync();
            }
            this.lastChunk = keep;
            this.writeStoreHeader();
            this.readStoreHeader();
        }
        for (MVMap mVMap : New.arrayList(this.maps.values())) {
            int id = mVMap.getId();
            if (mVMap.getCreateVersion() >= version) {
                mVMap.close();
                this.maps.remove(id);
                continue;
            }
            if (!loadFromFile) continue;
            mVMap.setRootPos(MVStore.getRootPos(this.meta, id), -1L);
        }
        if (this.lastChunk != null) {
            for (Chunk chunk : this.chunks.values()) {
                this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
            }
        }
        this.currentVersion = version;
        this.setWriteVersion(version);
    }

    private static long getRootPos(MVMap<String, String> map, int mapId) {
        String root = map.get(MVMap.getMapRootKey(mapId));
        return root == null ? 0L : DataUtils.parseHexLong(root);
    }

    private void revertTemp(long storeVersion) {
        Iterator it = ((ConcurrentHashMap.KeySetView)this.freedPageSpace.keySet()).iterator();
        while (it.hasNext()) {
            long v = (Long)it.next();
            if (v > storeVersion) continue;
            it.remove();
        }
        for (MVMap<?, ?> m : this.maps.values()) {
            m.removeUnusedOldVersions();
        }
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (this.closed) {
            throw DataUtils.newIllegalStateException(4, "This store is closed", this.panicException);
        }
    }

    public synchronized void renameMap(MVMap<?, ?> map, String newName) {
        this.checkOpen();
        DataUtils.checkArgument(map != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int id = map.getId();
        String oldName = this.getMapName(id);
        if (oldName.equals(newName)) {
            return;
        }
        DataUtils.checkArgument(!this.meta.containsKey("name." + newName), "A map named {0} already exists", newName);
        this.markMetaChanged();
        String x = Integer.toHexString(id);
        this.meta.remove("name." + oldName);
        this.meta.put(MVMap.getMapKey(id), map.asString(newName));
        this.meta.put("name." + newName, x);
    }

    public synchronized void removeMap(MVMap<?, ?> map) {
        this.checkOpen();
        DataUtils.checkArgument(map != this.meta, "Removing the meta map is not allowed", new Object[0]);
        map.clear();
        int id = map.getId();
        String name = this.getMapName(id);
        this.markMetaChanged();
        this.meta.remove(MVMap.getMapKey(id));
        this.meta.remove("name." + name);
        this.meta.remove(MVMap.getMapRootKey(id));
        this.maps.remove(id);
    }

    public synchronized String getMapName(int id) {
        this.checkOpen();
        String m = this.meta.get(MVMap.getMapKey(id));
        return m == null ? null : DataUtils.parseMap(m).get("name");
    }

    void writeInBackground() {
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                long time = this.getTimeSinceCreation();
                if (time <= this.lastCommitTime + (long)this.autoCommitDelay) {
                    return;
                }
                if (this.hasUnsavedChanges()) {
                    try {
                        this.commitAndSave();
                    }
                    catch (Exception e) {
                        if (this.backgroundExceptionHandler == null) break block8;
                        this.backgroundExceptionHandler.uncaughtException(null, e);
                        return;
                    }
                }
            }
            if (this.autoCompactFillRate > 0) {
                try {
                    long fileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
                    boolean fileOps = this.autoCompactLastFileOpCount != fileOpCount;
                    int fillRate = fileOps ? this.autoCompactFillRate / 3 : this.autoCompactFillRate;
                    this.compact(fillRate, this.autoCommitMemory);
                    this.autoCompactLastFileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
                }
                catch (Exception e) {
                    if (this.backgroundExceptionHandler == null) break block9;
                    this.backgroundExceptionHandler.uncaughtException(null, e);
                }
            }
        }
    }

    public void setCacheSize(int mb) {
        if (this.cache != null) {
            this.cache.setMaxMemory((long)mb * 1024L * 1024L);
            this.cache.clear();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread() {
        BackgroundWriterThread t = this.backgroundWriterThread;
        if (t == null) {
            return;
        }
        this.backgroundWriterThread = null;
        if (Thread.currentThread() == t) {
            return;
        }
        Object object = t.sync;
        synchronized (object) {
            t.sync.notifyAll();
        }
        if (Thread.holdsLock(this)) {
            return;
        }
        try {
            t.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAutoCommitDelay(int millis) {
        if (this.autoCommitDelay == millis) {
            return;
        }
        this.autoCommitDelay = millis;
        if (this.fileStore == null || this.fileStore.isReadOnly()) {
            return;
        }
        this.stopBackgroundThread();
        if (millis > 0) {
            int sleep = Math.max(1, millis / 10);
            BackgroundWriterThread t = new BackgroundWriterThread(this, sleep, this.fileStore.toString());
            t.start();
            this.backgroundWriterThread = t;
        }
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    void cachePage(long pos, Page page, int memory) {
        if (this.cache != null) {
            this.cache.put(pos, page, memory);
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() / 1024L / 1024L);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() / 1024L / 1024L);
    }

    public CacheLongKeyLIRS<Page> getCache() {
        return this.cache;
    }

    public boolean isReadOnly() {
        return this.fileStore == null ? false : this.fileStore.isReadOnly();
    }

    public static class Builder {
        private final HashMap<String, Object> config = New.hashMap();

        private Builder set(String key, Object value) {
            this.config.put(key, value);
            return this;
        }

        public Builder autoCommitDisabled() {
            this.set("autoCommitBufferSize", 0);
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int kb) {
            return this.set("autoCommitBufferSize", kb);
        }

        public Builder autoCompactFillRate(int percent) {
            return this.set("autoCompactFillRate", percent);
        }

        public Builder fileName(String fileName) {
            return this.set("fileName", fileName);
        }

        public Builder encryptionKey(char[] password) {
            return this.set("encryptionKey", password);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder cacheSize(int mb) {
            return this.set("cacheSize", mb);
        }

        public Builder cacheConcurrency(int concurrency) {
            return this.set("cacheConcurrency", concurrency);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int pageSplitSize) {
            return this.set("pageSplitSize", pageSplitSize);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
            return this.set("backgroundExceptionHandler", exceptionHandler);
        }

        public Builder fileStore(FileStore store) {
            return this.set("fileStore", store);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String s) {
            HashMap<String, String> config = DataUtils.parseMap(s);
            Builder builder = new Builder();
            builder.config.putAll(config);
            return builder;
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore store, int sleep, String fileStoreName) {
            super("MVStore background writer " + fileStoreName);
            this.store = store;
            this.sleep = sleep;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BackgroundWriterThread t;
            while ((t = this.store.backgroundWriterThread) != null) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                this.store.writeInBackground();
            }
        }
    }
}

