/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.TransactionStore;
import org.h2.mvstore.db.ValueDataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

public class MVSecondaryIndex
extends BaseIndex
implements MVIndex {
    final MVTable mvTable;
    private final int keyColumns;
    private final String mapName;
    private TransactionStore.TransactionMap<Value, Value> dataMap;

    public MVSecondaryIndex(Database db, MVTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        this.mvTable = table;
        this.initBaseIndex(table, id, indexName, columns, indexType);
        if (!this.database.isStarting()) {
            MVSecondaryIndex.checkIndexColumnTypes(columns);
        }
        this.keyColumns = columns.length + 1;
        this.mapName = "index." + this.getId();
        int[] sortTypes = new int[this.keyColumns];
        for (int i = 0; i < columns.length; ++i) {
            sortTypes[i] = columns[i].sortType;
        }
        sortTypes[this.keyColumns - 1] = 0;
        ValueDataType keyType = new ValueDataType(db.getCompareMode(), db, sortTypes);
        ValueDataType valueType = new ValueDataType(null, null, null);
        TransactionStore.Transaction t = this.mvTable.getTransaction(null);
        this.dataMap = t.openMap(this.mapName, keyType, valueType);
        t.commit();
        if (!keyType.equals(this.dataMap.getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type");
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        MVMap<Value, Value> map = this.openMap(bufferName);
        for (Row row : rows) {
            ValueArray key = this.convertToKey(row);
            map.put(key, ValueNull.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBufferedRows(List<String> bufferNames) {
        Iterator<Object> it;
        ArrayList<String> mapNames = New.arrayList(bufferNames);
        final CompareMode compareMode = this.database.getCompareMode();
        class Source
        implements Comparable<Source> {
            Value value;
            Iterator<Value> next;
            int sourceId;

            Source() {
            }

            @Override
            public int compareTo(Source o) {
                int comp = this.value.compareTo(o.value, compareMode);
                if (comp == 0) {
                    comp = this.sourceId - o.sourceId;
                }
                return comp;
            }
        }
        TreeSet<Source> sources = new TreeSet<Source>();
        for (int i = 0; i < bufferNames.size(); ++i) {
            MVMap<Value, Value> map = this.openMap(bufferNames.get(i));
            it = map.keyIterator(null);
            if (!it.hasNext()) continue;
            Source s = new Source();
            s.value = (Value)it.next();
            s.next = it;
            s.sourceId = i;
            sources.add(s);
        }
        try {
            while (true) {
                Source s = (Source)sources.first();
                Value v = s.value;
                if (this.indexType.isUnique()) {
                    Value[] array = ((ValueArray)v).getList();
                    array = (Value[])array.clone();
                    array[this.keyColumns - 1] = ValueLong.get(Long.MIN_VALUE);
                    ValueArray unique = ValueArray.get(array);
                    SearchRow row = this.convertToSearchRow((ValueArray)v);
                    this.checkUnique(row, this.dataMap, unique);
                }
                this.dataMap.putCommitted(v, ValueNull.INSTANCE);
                it = s.next;
                if (!it.hasNext()) {
                    sources.remove(s);
                    if (sources.size() != 0) continue;
                    break;
                }
                Value nextValue = (Value)it.next();
                sources.remove(s);
                s.value = nextValue;
                sources.add(s);
            }
        }
        finally {
            for (String tempMapName : mapNames) {
                MVMap<Value, Value> map = this.openMap(tempMapName);
                map.getStore().removeMap(map);
            }
        }
    }

    private MVMap<Value, Value> openMap(String mapName) {
        int[] sortTypes = new int[this.keyColumns];
        for (int i = 0; i < this.indexColumns.length; ++i) {
            sortTypes[i] = this.indexColumns[i].sortType;
        }
        sortTypes[this.keyColumns - 1] = 0;
        ValueDataType keyType = new ValueDataType(this.database.getCompareMode(), this.database, sortTypes);
        ValueDataType valueType = new ValueDataType(null, null, null);
        MVMap.Builder builder = new MVMap.Builder().keyType(keyType).valueType(valueType);
        Object map = this.database.getMvStore().getStore().openMap(mapName, builder);
        if (!keyType.equals(((MVMap)map).getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type");
        }
        return map;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        ValueArray array = this.convertToKey(row);
        ValueArray unique = null;
        if (this.indexType.isUnique()) {
            unique = this.convertToKey(row);
            unique.getList()[this.keyColumns - 1] = ValueLong.get(Long.MIN_VALUE);
            this.checkUnique(row, map, unique);
        }
        try {
            map.put(array, ValueNull.INSTANCE);
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
        if (this.indexType.isUnique()) {
            ValueArray k;
            SearchRow r2;
            Iterator<Value> it = map.keyIterator(unique, true);
            while (it.hasNext() && this.compareRows(row, r2 = this.convertToSearchRow(k = (ValueArray)it.next())) == 0) {
                if (this.containsNullAndAllowMultipleNull(r2) || map.isSameTransaction(k)) continue;
                if (map.get(k) != null) {
                    throw this.getDuplicateKeyException(k.toString());
                }
                throw DbException.get(90131, this.table.getName());
            }
        }
    }

    private void checkUnique(SearchRow row, TransactionStore.TransactionMap<Value, Value> map, ValueArray unique) {
        ValueArray k;
        SearchRow r2;
        Iterator<Value> it = map.keyIterator(unique, true);
        while (it.hasNext() && this.compareRows(row, r2 = this.convertToSearchRow(k = (ValueArray)it.next())) == 0) {
            if (map.get(k) == null || this.containsNullAndAllowMultipleNull(r2)) continue;
            throw this.getDuplicateKeyException(k.toString());
        }
    }

    @Override
    public void remove(Session session, Row row) {
        ValueArray array = this.convertToKey(row);
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        try {
            Value old = map.remove(array);
            if (old == null) {
                throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
            }
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return this.find(session, first, false, last);
    }

    private Cursor find(Session session, SearchRow first, boolean bigger, SearchRow last) {
        TransactionStore.TransactionMap<Value, Value> map;
        ValueArray min;
        block8: {
            block9: {
                ValueArray v;
                block7: {
                    min = this.convertToKey(first);
                    if (min != null) {
                        min.getList()[this.keyColumns - 1] = ValueLong.get(Long.MIN_VALUE);
                    }
                    map = this.getMap(session);
                    if (!bigger || min == null) break block8;
                    int offset = 1;
                    while (true) {
                        if ((v = (ValueArray)map.relativeKey(min, offset)) != null) {
                            int idx;
                            Value b;
                            boolean foundHigher = false;
                            for (int i = 0; i < this.keyColumns - 1 && (b = first.getValue(idx = this.columnIds[i])) != null; ++i) {
                                Value a = v.getList()[i];
                                if (this.database.compare(a, b) <= 0) continue;
                                foundHigher = true;
                                break;
                            }
                            if (!foundHigher) {
                                offset += offset;
                                min = v;
                                continue;
                            }
                        }
                        if (offset > 1) {
                            offset /= 2;
                            continue;
                        }
                        if (map.get(v) != null) break block7;
                        if ((min = (ValueArray)map.higherKey(min)) == null) break;
                    }
                    break block9;
                }
                min = v;
            }
            if (min == null) {
                return new MVStoreCursor(session, Collections.emptyList().iterator(), null);
            }
        }
        return new MVStoreCursor(session, map.keyIterator(min), last);
    }

    private ValueArray convertToKey(SearchRow r) {
        if (r == null) {
            return null;
        }
        Value[] array = new Value[this.keyColumns];
        for (int i = 0; i < this.columns.length; ++i) {
            Column c = this.columns[i];
            int idx = c.getColumnId();
            Value v = r.getValue(idx);
            if (v == null) continue;
            array[i] = v.convertTo(c.getType());
        }
        array[this.keyColumns - 1] = ValueLong.get(r.getKey());
        return ValueArray.get(array);
    }

    SearchRow convertToSearchRow(ValueArray key) {
        Value[] array = key.getList();
        Row searchRow = this.mvTable.getTemplateRow();
        searchRow.setKey(array[array.length - 1].getLong());
        Column[] cols = this.getColumns();
        for (int i = 0; i < array.length - 1; ++i) {
            Column c = cols[i];
            int idx = c.getColumnId();
            Value v = array[i];
            searchRow.setValue(idx, v);
        }
        return searchRow;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        try {
            return 10L * this.getCostRangeIndex(masks, this.dataMap.sizeAsLongMax(), filters, filter, sortOrder, false, allColumnsSet);
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public void remove(Session session) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        if (!map.isClosed()) {
            TransactionStore.Transaction t = this.mvTable.getTransaction(session);
            t.removeMap(map);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        map.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        Value key;
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        Value value = key = first ? map.firstKey() : map.lastKey();
        while (true) {
            if (key == null) {
                return new MVStoreCursor(session, Collections.emptyList().iterator(), null);
            }
            if (((ValueArray)key).getList()[0] != ValueNull.INSTANCE) break;
            key = first ? map.higherKey(key) : map.lowerKey(key);
        }
        ArrayList list = New.arrayList();
        list.add(key);
        MVStoreCursor cursor = new MVStoreCursor(session, list.iterator(), null);
        cursor.next();
        return cursor;
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        return map.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean canFindNext() {
        return true;
    }

    @Override
    public Cursor findNext(Session session, SearchRow higherThan, SearchRow last) {
        return this.find(session, higherThan, true, last);
    }

    @Override
    public void checkRename() {
    }

    TransactionStore.TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        TransactionStore.Transaction t = this.mvTable.getTransaction(session);
        return this.dataMap.getInstance(t, Long.MAX_VALUE);
    }

    class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Value> it;
        private final SearchRow last;
        private Value current;
        private SearchRow searchRow;
        private Row row;

        public MVStoreCursor(Session session, Iterator<Value> it, SearchRow last) {
            this.session = session;
            this.it = it;
            this.last = last;
        }

        @Override
        public Row get() {
            SearchRow r;
            if (this.row == null && (r = this.getSearchRow()) != null) {
                this.row = MVSecondaryIndex.this.mvTable.getRow(this.session, r.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = MVSecondaryIndex.this.convertToSearchRow((ValueArray)this.current);
            }
            return this.searchRow;
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.searchRow = null;
            if (this.current != null && this.last != null && MVSecondaryIndex.this.compareRows(this.getSearchRow(), this.last) > 0) {
                this.searchRow = null;
                this.current = null;
            }
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

