/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.engine.Database;
import org.h2.engine.SessionInterface;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.store.CountingReaderInputStream;
import org.h2.store.LobStorageInterface;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLobDb;

public class LobStorageBackend
implements LobStorageInterface {
    public static final String LOB_DATA_TABLE = "LOB_DATA";
    private static final String LOB_SCHEMA = "INFORMATION_SCHEMA";
    private static final String LOBS = "INFORMATION_SCHEMA.LOBS";
    private static final String LOB_MAP = "INFORMATION_SCHEMA.LOB_MAP";
    private static final String LOB_DATA = "INFORMATION_SCHEMA.LOB_DATA";
    private static final int BLOCK_LENGTH = 20000;
    private static final int HASH_CACHE_SIZE = 4096;
    JdbcConnection conn;
    final Database database;
    private final HashMap<String, PreparedStatement> prepared = New.hashMap();
    private long nextBlock;
    private final CompressTool compress = CompressTool.getInstance();
    private long[] hashBlocks;
    private boolean init;

    public LobStorageBackend(Database database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.init) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.init) {
                return;
            }
            this.init = true;
            this.conn = this.database.getLobConnectionForRegularUse();
            JdbcConnection initConn = this.database.getLobConnectionForInit();
            try {
                Statement stat = initConn.createStatement();
                boolean create = true;
                PreparedStatement prep = initConn.prepareStatement("SELECT ZERO() FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND COLUMN_NAME=?");
                prep.setString(1, LOB_SCHEMA);
                prep.setString(2, "LOB_MAP");
                prep.setString(3, "POS");
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    prep = initConn.prepareStatement("SELECT ZERO() FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?");
                    prep.setString(1, LOB_SCHEMA);
                    prep.setString(2, LOB_DATA_TABLE);
                    rs = prep.executeQuery();
                    if (rs.next()) {
                        create = false;
                    }
                }
                if (create) {
                    stat.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOBS(ID BIGINT PRIMARY KEY, BYTE_COUNT BIGINT, TABLE INT) HIDDEN");
                    stat.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_TABLE ON INFORMATION_SCHEMA.LOBS(TABLE)");
                    stat.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_MAP(LOB BIGINT, SEQ INT, POS BIGINT, HASH INT, BLOCK BIGINT, PRIMARY KEY(LOB, SEQ)) HIDDEN");
                    stat.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP RENAME TO INFORMATION_SCHEMA.LOB_MAP HIDDEN");
                    stat.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP ADD IF NOT EXISTS POS BIGINT BEFORE HASH");
                    stat.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP DROP COLUMN IF EXISTS \"OFFSET\"");
                    stat.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_MAP_DATA_LOB ON INFORMATION_SCHEMA.LOB_MAP(BLOCK, LOB)");
                    stat.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_DATA(BLOCK BIGINT PRIMARY KEY, COMPRESSED INT, DATA BINARY) HIDDEN");
                }
                rs = stat.executeQuery("SELECT MAX(BLOCK) FROM INFORMATION_SCHEMA.LOB_DATA");
                rs.next();
                this.nextBlock = rs.getLong(1) + 1L;
                stat.close();
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
    }

    private long getNextLobId() throws SQLException {
        String sql = "SELECT MAX(LOB) FROM INFORMATION_SCHEMA.LOB_MAP";
        PreparedStatement prep = this.prepare(sql);
        ResultSet rs = prep.executeQuery();
        rs.next();
        long x = rs.getLong(1) + 1L;
        this.reuse(sql, prep);
        sql = "SELECT MAX(ID) FROM INFORMATION_SCHEMA.LOBS";
        prep = this.prepare(sql);
        rs = prep.executeQuery();
        rs.next();
        x = Math.max(x, rs.getLong(1) + 1L);
        this.reuse(sql, prep);
        return x;
    }

    @Override
    public void removeAllForTable(int tableId) {
        this.init();
        try {
            String sql = "SELECT ID FROM INFORMATION_SCHEMA.LOBS WHERE TABLE = ?";
            PreparedStatement prep = this.prepare(sql);
            prep.setInt(1, tableId);
            ResultSet rs = prep.executeQuery();
            while (rs.next()) {
                this.removeLob(rs.getLong(1));
            }
            this.reuse(sql, prep);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
        if (tableId == -1) {
            this.removeAllForTable(-2);
            this.removeAllForTable(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readBlock(long block) throws SQLException {
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                String sql = "SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
                PreparedStatement prep = this.prepare(sql);
                prep.setLong(1, block);
                ResultSet rs = prep.executeQuery();
                if (!rs.next()) {
                    throw DbException.get(90028, "Missing lob entry, block: " + block).getSQLException();
                }
                int compressed = rs.getInt(1);
                byte[] buffer = rs.getBytes(2);
                if (compressed != 0) {
                    buffer = this.compress.expand(buffer);
                }
                this.reuse(sql, prep);
                return buffer;
            }
        }
    }

    PreparedStatement prepare(String sql) throws SQLException {
        if (SysProperties.CHECK2 && !Thread.holdsLock(this.database)) {
            throw DbException.throwInternalError();
        }
        PreparedStatement prep = this.prepared.remove(sql);
        if (prep == null) {
            prep = this.conn.prepareStatement(sql);
        }
        return prep;
    }

    void reuse(String sql, PreparedStatement prep) {
        if (SysProperties.CHECK2 && !Thread.holdsLock(this.database)) {
            throw DbException.throwInternalError();
        }
        this.prepared.put(sql, prep);
    }

    @Override
    public void removeLob(ValueLobDb lob) {
        this.removeLob(lob.getLobId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLob(long lobId) {
        try {
            LobStorageBackend.assertNotHolds(this.conn.getSession());
            Database database = this.database;
            synchronized (database) {
                SessionInterface sessionInterface = this.conn.getSession();
                synchronized (sessionInterface) {
                    String sql = "SELECT BLOCK, HASH FROM INFORMATION_SCHEMA.LOB_MAP D WHERE D.LOB = ? AND NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.LOB_MAP O WHERE O.BLOCK = D.BLOCK AND O.LOB <> ?)";
                    PreparedStatement prep = this.prepare(sql);
                    prep.setLong(1, lobId);
                    prep.setLong(2, lobId);
                    ResultSet rs = prep.executeQuery();
                    ArrayList blocks = New.arrayList();
                    while (rs.next()) {
                        blocks.add(rs.getLong(1));
                        int hash = rs.getInt(2);
                        this.setHashCacheBlock(hash, -1L);
                    }
                    this.reuse(sql, prep);
                    sql = "DELETE FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
                    prep = this.prepare(sql);
                    prep.setLong(1, lobId);
                    prep.execute();
                    this.reuse(sql, prep);
                    sql = "DELETE FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
                    prep = this.prepare(sql);
                    Iterator iterator = blocks.iterator();
                    while (iterator.hasNext()) {
                        long block = (Long)iterator.next();
                        prep.setLong(1, block);
                        prep.execute();
                    }
                    this.reuse(sql, prep);
                    sql = "DELETE FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                    prep = this.prepare(sql);
                    prep.setLong(1, lobId);
                    prep.execute();
                    this.reuse(sql, prep);
                }
            }
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(ValueLobDb lob, byte[] hmac, long byteCount) throws IOException {
        try {
            this.init();
            LobStorageBackend.assertNotHolds(this.conn.getSession());
            Database database = this.database;
            synchronized (database) {
                SessionInterface sessionInterface = this.conn.getSession();
                synchronized (sessionInterface) {
                    long lobId = lob.getLobId();
                    return new LobInputStream(lobId, byteCount);
                }
            }
        }
        catch (SQLException e) {
            throw DbException.convertToIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueLobDb addLob(InputStream in, long maxLength, int type, CountingReaderInputStream countingReaderForClob) {
        try {
            byte[] buff = new byte[20000];
            if (maxLength < 0L) {
                maxLength = Long.MAX_VALUE;
            }
            long length = 0L;
            long lobId = -1L;
            int maxLengthInPlaceLob = this.database.getMaxLengthInplaceLob();
            String compressAlgorithm = this.database.getLobCompressionAlgorithm(type);
            try {
                byte[] small = null;
                int seq = 0;
                while (maxLength > 0L) {
                    byte[] b;
                    int len = (int)Math.min(20000L, maxLength);
                    if ((len = IOUtils.readFully(in, buff, len)) <= 0) break;
                    maxLength -= (long)len;
                    if (len != buff.length) {
                        b = new byte[len];
                        System.arraycopy(buff, 0, b, 0, len);
                    } else {
                        b = buff;
                    }
                    if (seq == 0 && b.length < 20000 && b.length <= maxLengthInPlaceLob) {
                        small = b;
                        break;
                    }
                    LobStorageBackend.assertNotHolds(this.conn.getSession());
                    Database database = this.database;
                    synchronized (database) {
                        SessionInterface sessionInterface = this.conn.getSession();
                        synchronized (sessionInterface) {
                            if (seq == 0) {
                                lobId = this.getNextLobId();
                            }
                            this.storeBlock(lobId, seq, length, b, compressAlgorithm);
                        }
                    }
                    length += (long)len;
                    ++seq;
                }
                if (lobId == -1L && small == null) {
                    small = new byte[]{};
                }
                if (small != null) {
                    long precision = countingReaderForClob == null ? (long)small.length : countingReaderForClob.getLength();
                    ValueLobDb v = ValueLobDb.createSmallLob(type, small, precision);
                    return v;
                }
                long precision = countingReaderForClob == null ? length : countingReaderForClob.getLength();
                return this.registerLob(type, lobId, -2, length, precision);
            }
            catch (IOException e) {
                if (lobId != -1L) {
                    this.removeLob(lobId);
                }
                throw DbException.convertIOException(e, null);
            }
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueLobDb registerLob(int type, long lobId, int tableId, long byteCount, long precision) throws SQLException {
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                String sql = "INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) VALUES(?, ?, ?)";
                PreparedStatement prep = this.prepare(sql);
                prep.setLong(1, lobId);
                prep.setLong(2, byteCount);
                prep.setInt(3, tableId);
                prep.execute();
                this.reuse(sql, prep);
                ValueLobDb v = ValueLobDb.create(type, this.database, tableId, lobId, null, precision);
                return v;
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb old, int tableId, long length) {
        int type = old.getType();
        long oldLobId = old.getLobId();
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                try {
                    this.init();
                    long lobId = this.getNextLobId();
                    String sql = "INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, POS, HASH, BLOCK) SELECT ?, SEQ, POS, HASH, BLOCK FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
                    PreparedStatement prep = this.prepare(sql);
                    prep.setLong(1, lobId);
                    prep.setLong(2, oldLobId);
                    prep.executeUpdate();
                    this.reuse(sql, prep);
                    sql = "INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) SELECT ?, BYTE_COUNT, ? FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                    prep = this.prepare(sql);
                    prep.setLong(1, lobId);
                    prep.setLong(2, tableId);
                    prep.setLong(3, oldLobId);
                    prep.executeUpdate();
                    this.reuse(sql, prep);
                    ValueLobDb v = ValueLobDb.create(type, this.database, tableId, lobId, null, length);
                    return v;
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
            }
        }
    }

    private long getHashCacheBlock(int hash) {
        this.initHashCache();
        int index = hash & 0xFFF;
        long oldHash = this.hashBlocks[index];
        if (oldHash == (long)hash) {
            return this.hashBlocks[index + 4096];
        }
        return -1L;
    }

    private void setHashCacheBlock(int hash, long block) {
        this.initHashCache();
        int index = hash & 0xFFF;
        this.hashBlocks[index] = hash;
        this.hashBlocks[index + 4096] = block;
    }

    private void initHashCache() {
        if (this.hashBlocks == null) {
            this.hashBlocks = new long[8192];
        }
    }

    void storeBlock(long lobId, int seq, long pos, byte[] b, String compressAlgorithm) throws SQLException {
        PreparedStatement prep;
        String sql;
        boolean blockExists = false;
        if (compressAlgorithm != null) {
            b = this.compress.compress(b, compressAlgorithm);
        }
        int hash = Arrays.hashCode(b);
        LobStorageBackend.assertHoldsLock(this.conn.getSession());
        LobStorageBackend.assertHoldsLock(this.database);
        long block = this.getHashCacheBlock(hash);
        if (block != -1L) {
            sql = "SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
            prep = this.prepare(sql);
            prep.setLong(1, block);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                boolean compressed = rs.getInt(1) != 0;
                byte[] compare = rs.getBytes(2);
                if (compressed == (compressAlgorithm != null) && Arrays.equals(b, compare)) {
                    blockExists = true;
                }
            }
            this.reuse(sql, prep);
        }
        if (!blockExists) {
            block = this.nextBlock++;
            this.setHashCacheBlock(hash, block);
            sql = "INSERT INTO INFORMATION_SCHEMA.LOB_DATA(BLOCK, COMPRESSED, DATA) VALUES(?, ?, ?)";
            prep = this.prepare(sql);
            prep.setLong(1, block);
            prep.setInt(2, compressAlgorithm == null ? 0 : 1);
            prep.setBytes(3, b);
            prep.execute();
            this.reuse(sql, prep);
        }
        sql = "INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, POS, HASH, BLOCK) VALUES(?, ?, ?, ?, ?)";
        prep = this.prepare(sql);
        prep.setLong(1, lobId);
        prep.setInt(2, seq);
        prep.setLong(3, pos);
        prep.setLong(4, hash);
        prep.setLong(5, block);
        prep.execute();
        this.reuse(sql, prep);
    }

    @Override
    public Value createBlob(InputStream in, long maxLength) {
        this.init();
        return this.addLob(in, maxLength, 15, null);
    }

    @Override
    public Value createClob(Reader reader, long maxLength) {
        this.init();
        long max = maxLength == -1L ? Long.MAX_VALUE : maxLength;
        CountingReaderInputStream in = new CountingReaderInputStream(reader, max);
        ValueLobDb lob = this.addLob(in, Long.MAX_VALUE, 16, in);
        return lob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTable(ValueLobDb lob, int table) {
        long lobId = lob.getLobId();
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                try {
                    this.init();
                    String sql = "UPDATE INFORMATION_SCHEMA.LOBS SET TABLE = ? WHERE ID = ?";
                    PreparedStatement prep = this.prepare(sql);
                    prep.setInt(1, table);
                    prep.setLong(2, lobId);
                    prep.executeUpdate();
                    this.reuse(sql, prep);
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
            }
        }
    }

    private static void assertNotHolds(Object lock) {
        if (Thread.holdsLock(lock)) {
            throw DbException.throwInternalError();
        }
    }

    static void assertHoldsLock(Object lock) {
        if (!Thread.holdsLock(lock)) {
            throw DbException.throwInternalError();
        }
    }

    public class LobInputStream
    extends InputStream {
        private final long[] lobMapBlocks;
        private int lobMapIndex;
        private long remainingBytes;
        private byte[] buffer;
        private int bufferPos;

        public LobInputStream(long lobId, long byteCount) throws SQLException {
            ResultSet rs;
            PreparedStatement prep;
            String sql;
            LobStorageBackend.assertHoldsLock(LobStorageBackend.this.conn.getSession());
            LobStorageBackend.assertHoldsLock(LobStorageBackend.this.database);
            if (byteCount == -1L) {
                sql = "SELECT BYTE_COUNT FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                prep = LobStorageBackend.this.prepare(sql);
                prep.setLong(1, lobId);
                rs = prep.executeQuery();
                if (!rs.next()) {
                    throw DbException.get(90028, "Missing lob entry: " + lobId).getSQLException();
                }
                byteCount = rs.getLong(1);
                LobStorageBackend.this.reuse(sql, prep);
            }
            this.remainingBytes = byteCount;
            sql = "SELECT COUNT(*) FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
            prep = LobStorageBackend.this.prepare(sql);
            prep.setLong(1, lobId);
            rs = prep.executeQuery();
            rs.next();
            int lobMapCount = rs.getInt(1);
            if (lobMapCount == 0) {
                throw DbException.get(90028, "Missing lob entry: " + lobId).getSQLException();
            }
            LobStorageBackend.this.reuse(sql, prep);
            this.lobMapBlocks = new long[lobMapCount];
            sql = "SELECT BLOCK FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ? ORDER BY SEQ";
            prep = LobStorageBackend.this.prepare(sql);
            prep.setLong(1, lobId);
            rs = prep.executeQuery();
            int i = 0;
            while (rs.next()) {
                this.lobMapBlocks[i] = rs.getLong(1);
                ++i;
            }
            LobStorageBackend.this.reuse(sql, prep);
        }

        @Override
        public int read() throws IOException {
            this.fillBuffer();
            if (this.remainingBytes <= 0L) {
                return -1;
            }
            --this.remainingBytes;
            return this.buffer[this.bufferPos++] & 0xFF;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            long remaining = n;
            if ((remaining -= (long)this.skipSmall(remaining)) > 20000L) {
                while (remaining > 20000L) {
                    remaining -= 20000L;
                    this.remainingBytes -= 20000L;
                    ++this.lobMapIndex;
                }
                this.bufferPos = 0;
                this.buffer = null;
            }
            this.fillBuffer();
            remaining -= (long)this.skipSmall(remaining);
            remaining -= super.skip(remaining);
            return n - remaining;
        }

        private int skipSmall(long n) {
            if (this.buffer != null && this.bufferPos < this.buffer.length) {
                int x = MathUtils.convertLongToInt(Math.min(n, (long)(this.buffer.length - this.bufferPos)));
                this.bufferPos += x;
                this.remainingBytes -= (long)x;
                return x;
            }
            return 0;
        }

        @Override
        public int available() throws IOException {
            return MathUtils.convertLongToInt(this.remainingBytes);
        }

        @Override
        public int read(byte[] buff) throws IOException {
            return this.readFully(buff, 0, buff.length);
        }

        @Override
        public int read(byte[] buff, int off, int length) throws IOException {
            return this.readFully(buff, off, length);
        }

        private int readFully(byte[] buff, int off, int length) throws IOException {
            if (length == 0) {
                return 0;
            }
            int read = 0;
            while (length > 0) {
                this.fillBuffer();
                if (this.remainingBytes <= 0L) break;
                int len = (int)Math.min((long)length, this.remainingBytes);
                len = Math.min(len, this.buffer.length - this.bufferPos);
                System.arraycopy(this.buffer, this.bufferPos, buff, off, len);
                this.bufferPos += len;
                read += len;
                this.remainingBytes -= (long)len;
                off += len;
                length -= len;
            }
            return read == 0 ? -1 : read;
        }

        private void fillBuffer() throws IOException {
            if (this.buffer != null && this.bufferPos < this.buffer.length) {
                return;
            }
            if (this.remainingBytes <= 0L) {
                return;
            }
            if (this.lobMapIndex >= this.lobMapBlocks.length) {
                System.out.println("halt!");
            }
            try {
                this.buffer = LobStorageBackend.this.readBlock(this.lobMapBlocks[this.lobMapIndex]);
                ++this.lobMapIndex;
                this.bufferPos = 0;
            }
            catch (SQLException e) {
                throw DbException.convertToIOException(e);
            }
        }
    }
}

