/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.util.StringUtils;

public class ToChar {
    private static final long JULIAN_EPOCH;

    private ToChar() {
    }

    public static String toChar(BigDecimal number, String format, String nlsParam) {
        int i;
        int separator;
        int formatScale;
        boolean fillMode;
        Integer power;
        int v;
        boolean angleBrackets;
        boolean trailingMinus;
        boolean trailingSign;
        String formatUp;
        String string = formatUp = format != null ? format.toUpperCase() : null;
        if (formatUp == null || formatUp.equals("TM") || formatUp.equals("TM9")) {
            String s = number.toPlainString();
            return s.startsWith("0.") ? s.substring(1) : s;
        }
        if (formatUp.equals("TME")) {
            int pow = number.precision() - number.scale() - 1;
            number = number.movePointLeft(pow);
            return number.toPlainString() + "E" + (pow < 0 ? (char)'-' : '+') + (Math.abs(pow) < 10 ? "0" : "") + Math.abs(pow);
        }
        if (formatUp.equals("RN")) {
            boolean lowercase = format.startsWith("r");
            String rn = StringUtils.pad(ToChar.toRomanNumeral(number.intValue()), 15, " ", false);
            return lowercase ? rn.toLowerCase() : rn;
        }
        if (formatUp.equals("FMRN")) {
            boolean lowercase = format.charAt(2) == 'r';
            String rn = ToChar.toRomanNumeral(number.intValue());
            return lowercase ? rn.toLowerCase() : rn;
        }
        if (formatUp.endsWith("X")) {
            return ToChar.toHex(number, format);
        }
        String originalFormat = format;
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        char localGrouping = symbols.getGroupingSeparator();
        char localDecimal = symbols.getDecimalSeparator();
        boolean leadingSign = formatUp.startsWith("S");
        if (leadingSign) {
            format = format.substring(1);
        }
        if (trailingSign = formatUp.endsWith("S")) {
            format = format.substring(0, format.length() - 1);
        }
        if (trailingMinus = formatUp.endsWith("MI")) {
            format = format.substring(0, format.length() - 2);
        }
        if (angleBrackets = formatUp.endsWith("PR")) {
            format = format.substring(0, format.length() - 2);
        }
        if ((v = formatUp.indexOf("V")) >= 0) {
            int digits = 0;
            for (int i2 = v + 1; i2 < format.length(); ++i2) {
                char c = format.charAt(i2);
                if (c != '0' && c != '9') continue;
                ++digits;
            }
            number = number.movePointRight(digits);
            format = format.substring(0, v) + format.substring(v + 1);
        }
        if (format.endsWith("EEEE")) {
            power = number.precision() - number.scale() - 1;
            number = number.movePointLeft(power);
            format = format.substring(0, format.length() - 4);
        } else {
            power = null;
        }
        int maxLength = 1;
        boolean bl = fillMode = !formatUp.startsWith("FM");
        if (!fillMode) {
            format = format.substring(2);
        }
        if ((formatScale = ToChar.calculateScale(format = format.replaceAll("[Bb]", ""), separator = ToChar.findDecimalSeparator(format))) < number.scale()) {
            number = number.setScale(formatScale, 4);
        }
        for (int i3 = format.indexOf(48); i3 >= 0 && i3 < separator; ++i3) {
            if (format.charAt(i3) != '9') continue;
            format = format.substring(0, i3) + "0" + format.substring(i3 + 1);
        }
        StringBuilder output = new StringBuilder();
        String unscaled = (number.abs().compareTo(BigDecimal.ONE) < 0 ? ToChar.zeroesAfterDecimalSeparator(number) : "") + number.unscaledValue().abs().toString();
        int j = unscaled.length() - number.scale() - 1;
        for (i = separator - 1; i >= 0; --i) {
            char c = format.charAt(i);
            ++maxLength;
            if (c == '9' || c == '0') {
                if (j >= 0) {
                    char digit = unscaled.charAt(j);
                    output.insert(0, digit);
                    --j;
                    continue;
                }
                if (c != '0' || power != null) continue;
                output.insert(0, '0');
                continue;
            }
            if (c == ',') {
                if (j < 0 && (i <= 0 || format.charAt(i - 1) != '0')) continue;
                output.insert(0, c);
                continue;
            }
            if (c == 'G' || c == 'g') {
                if (j < 0 && (i <= 0 || format.charAt(i - 1) != '0')) continue;
                output.insert(0, localGrouping);
                continue;
            }
            if (c == 'C' || c == 'c') {
                Currency currency = Currency.getInstance(Locale.getDefault());
                output.insert(0, currency.getCurrencyCode());
                maxLength += 6;
                continue;
            }
            if (c == 'L' || c == 'l' || c == 'U' || c == 'u') {
                Currency currency = Currency.getInstance(Locale.getDefault());
                output.insert(0, currency.getSymbol());
                maxLength += 9;
                continue;
            }
            if (c == '$') {
                Currency currency = Currency.getInstance(Locale.getDefault());
                String cs = currency.getSymbol();
                output.insert(0, cs);
                continue;
            }
            throw DbException.get(90010, originalFormat);
        }
        if (j >= 0) {
            return StringUtils.pad("", format.length() + 1, "#", true);
        }
        if (separator < format.length()) {
            ++maxLength;
            char pt = format.charAt(separator);
            if (pt == 'd' || pt == 'D') {
                output.append(localDecimal);
            } else {
                output.append(pt);
            }
            j = unscaled.length() - number.scale();
            for (i = separator + 1; i < format.length(); ++i) {
                char c = format.charAt(i);
                ++maxLength;
                if (c == '9' || c == '0') {
                    if (j < unscaled.length()) {
                        char digit = unscaled.charAt(j);
                        output.append(digit);
                        ++j;
                        continue;
                    }
                    if (c != '0' && !fillMode) continue;
                    output.append('0');
                    continue;
                }
                throw DbException.get(90010, originalFormat);
            }
        }
        ToChar.addSign(output, number.signum(), leadingSign, trailingSign, trailingMinus, angleBrackets, fillMode);
        if (power != null) {
            output.append('E');
            output.append(power < 0 ? (char)'-' : '+');
            output.append(Math.abs(power) < 10 ? "0" : "");
            output.append(Math.abs(power));
        }
        if (fillMode) {
            if (power != null) {
                output.insert(0, ' ');
            } else {
                while (output.length() < maxLength) {
                    output.insert(0, ' ');
                }
            }
        }
        return output.toString();
    }

    private static String zeroesAfterDecimalSeparator(BigDecimal number) {
        int i;
        String numberStr = number.toString();
        int idx = numberStr.indexOf(46);
        if (idx < 0) {
            return "";
        }
        boolean allZeroes = true;
        for (i = idx + 1; i < numberStr.length(); ++i) {
            if (numberStr.charAt(i) == '0') continue;
            allZeroes = false;
            break;
        }
        char[] zeroes = new char[allZeroes ? numberStr.length() - idx - 1 : i - 1 - idx];
        Arrays.fill(zeroes, '0');
        return String.valueOf(zeroes);
    }

    private static void addSign(StringBuilder output, int signum, boolean leadingSign, boolean trailingSign, boolean trailingMinus, boolean angleBrackets, boolean fillMode) {
        if (angleBrackets) {
            if (signum < 0) {
                output.insert(0, '<');
                output.append('>');
            } else if (fillMode) {
                output.insert(0, ' ');
                output.append(' ');
            }
        } else {
            String sign = signum == 0 ? "" : (signum < 0 ? "-" : (leadingSign || trailingSign ? "+" : (fillMode ? " " : "")));
            if (trailingMinus || trailingSign) {
                output.append(sign);
            } else {
                output.insert(0, sign);
            }
        }
    }

    private static int findDecimalSeparator(String format) {
        int index = format.indexOf(46);
        if (index == -1 && (index = format.indexOf(68)) == -1 && (index = format.indexOf(100)) == -1) {
            index = format.length();
        }
        return index;
    }

    private static int calculateScale(String format, int separator) {
        int scale = 0;
        for (int i = separator; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c != '0' && c != '9') continue;
            ++scale;
        }
        return scale;
    }

    private static String toRomanNumeral(int number) {
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] numerals = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            String numeral = numerals[i];
            while (number >= value) {
                result.append(numeral);
                number -= value;
            }
        }
        return result.toString();
    }

    private static String toHex(BigDecimal number, String format) {
        int i;
        boolean fillMode = !format.toUpperCase().startsWith("FM");
        boolean uppercase = !format.contains("x");
        boolean zeroPadded = format.startsWith("0");
        int digits = 0;
        for (i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c != '0' && c != 'X' && c != 'x') continue;
            ++digits;
        }
        i = number.setScale(0, 4).intValue();
        String hex = Integer.toHexString(i);
        if (digits < hex.length()) {
            hex = StringUtils.pad("", digits + 1, "#", true);
        } else {
            if (uppercase) {
                hex = hex.toUpperCase();
            }
            if (zeroPadded) {
                hex = StringUtils.pad(hex, digits, "0", false);
            }
            if (fillMode) {
                hex = StringUtils.pad(hex, format.length() + 1, " ", false);
            }
        }
        return hex;
    }

    public static String toChar(Timestamp ts, String format, String nlsParam) {
        if (format == null) {
            format = "DD-MON-YY HH.MI.SS.FF PM";
        }
        GregorianCalendar cal = new GregorianCalendar(Locale.ENGLISH);
        cal.setTimeInMillis(ts.getTime());
        StringBuilder output = new StringBuilder();
        boolean fillMode = true;
        int i = 0;
        block0: while (i < format.length()) {
            Capitalization cap = ToChar.containsAt(format, i, "A.D.", "B.C.");
            if (cap != null) {
                String era = cal.get(0) == 1 ? "A.D." : "B.C.";
                output.append(cap.apply(era));
                i += 4;
                continue;
            }
            cap = ToChar.containsAt(format, i, "AD", "BC");
            if (cap != null) {
                String era = cal.get(0) == 1 ? "AD" : "BC";
                output.append(cap.apply(era));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "A.M.", "P.M.");
            if (cap != null) {
                String am = cal.get(9) == 0 ? "A.M." : "P.M.";
                output.append(cap.apply(am));
                i += 4;
                continue;
            }
            cap = ToChar.containsAt(format, i, "AM", "PM");
            if (cap != null) {
                String am = cal.get(9) == 0 ? "AM" : "PM";
                output.append(cap.apply(am));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "DL");
            if (cap != null) {
                output.append(new SimpleDateFormat("EEEE, MMMM d, yyyy").format(ts));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "DS");
            if (cap != null) {
                output.append(new SimpleDateFormat("MM/dd/yyyy").format(ts));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "TS");
            if (cap != null) {
                output.append(new SimpleDateFormat("h:mm:ss aa").format(ts));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "DDD");
            if (cap != null) {
                output.append(cal.get(6));
                i += 3;
                continue;
            }
            cap = ToChar.containsAt(format, i, "DD");
            if (cap != null) {
                output.append(String.format("%02d", cal.get(5)));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "DY");
            if (cap != null) {
                String day = new SimpleDateFormat("EEE").format(ts).toUpperCase();
                output.append(cap.apply(day));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "DAY");
            if (cap != null) {
                String day = new SimpleDateFormat("EEEE").format(ts);
                if (fillMode) {
                    day = StringUtils.pad(day, "Wednesday".length(), " ", true);
                }
                output.append(cap.apply(day));
                i += 3;
                continue;
            }
            cap = ToChar.containsAt(format, i, "D");
            if (cap != null) {
                output.append(cal.get(7));
                ++i;
                continue;
            }
            cap = ToChar.containsAt(format, i, "J");
            if (cap != null) {
                long millis = ts.getTime() - JULIAN_EPOCH;
                long days = (long)Math.floor(millis / 86400000L);
                output.append(days);
                ++i;
                continue;
            }
            cap = ToChar.containsAt(format, i, "HH24");
            if (cap != null) {
                output.append(new DecimalFormat("00").format(cal.get(11)));
                i += 4;
                continue;
            }
            cap = ToChar.containsAt(format, i, "HH12");
            if (cap != null) {
                output.append(new DecimalFormat("00").format(cal.get(10)));
                i += 4;
                continue;
            }
            cap = ToChar.containsAt(format, i, "HH");
            if (cap != null) {
                output.append(new DecimalFormat("00").format(cal.get(10)));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "MI");
            if (cap != null) {
                output.append(new DecimalFormat("00").format(cal.get(12)));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "SSSSS");
            if (cap != null) {
                int seconds = cal.get(11) * 60 * 60;
                seconds += cal.get(12) * 60;
                output.append(seconds += cal.get(13));
                i += 5;
                continue;
            }
            cap = ToChar.containsAt(format, i, "SS");
            if (cap != null) {
                output.append(new DecimalFormat("00").format(cal.get(13)));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "FF1", "FF2", "FF3", "FF4", "FF5", "FF6", "FF7", "FF8", "FF9");
            if (cap != null) {
                int x = Integer.parseInt(format.substring(i + 2, i + 3));
                int ff = (int)((double)cal.get(14) * Math.pow(10.0, x - 3));
                output.append(ff);
                i += 3;
                continue;
            }
            cap = ToChar.containsAt(format, i, "FF");
            if (cap != null) {
                output.append(cal.get(14) * 1000);
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "TZR");
            if (cap != null) {
                TimeZone tz = TimeZone.getDefault();
                output.append(tz.getID());
                i += 3;
                continue;
            }
            cap = ToChar.containsAt(format, i, "TZD");
            if (cap != null) {
                TimeZone tz = TimeZone.getDefault();
                boolean daylight = tz.inDaylightTime(new java.util.Date());
                output.append(tz.getDisplayName(daylight, 0));
                i += 3;
                continue;
            }
            cap = ToChar.containsAt(format, i, "IW", "WW");
            if (cap != null) {
                output.append(cal.get(3));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "W");
            if (cap != null) {
                int w = (int)(1.0 + Math.floor(cal.get(5) / 7));
                output.append(w);
                ++i;
                continue;
            }
            cap = ToChar.containsAt(format, i, "Y,YYY");
            if (cap != null) {
                output.append(new DecimalFormat("#,###").format(ToChar.getYear(cal)));
                i += 5;
                continue;
            }
            cap = ToChar.containsAt(format, i, "SYYYY");
            if (cap != null) {
                if (cal.get(0) == 0) {
                    output.append('-');
                }
                output.append(new DecimalFormat("0000").format(ToChar.getYear(cal)));
                i += 5;
                continue;
            }
            cap = ToChar.containsAt(format, i, "YYYY", "IYYY", "RRRR");
            if (cap != null) {
                output.append(new DecimalFormat("0000").format(ToChar.getYear(cal)));
                i += 4;
                continue;
            }
            cap = ToChar.containsAt(format, i, "YYY", "IYY");
            if (cap != null) {
                output.append(new DecimalFormat("000").format(ToChar.getYear(cal) % 1000));
                i += 3;
                continue;
            }
            cap = ToChar.containsAt(format, i, "YY", "IY", "RR");
            if (cap != null) {
                output.append(new DecimalFormat("00").format(ToChar.getYear(cal) % 100));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "I", "Y");
            if (cap != null) {
                output.append(ToChar.getYear(cal) % 10);
                ++i;
                continue;
            }
            cap = ToChar.containsAt(format, i, "MONTH");
            if (cap != null) {
                String month = new SimpleDateFormat("MMMM").format(ts);
                if (fillMode) {
                    month = StringUtils.pad(month, "September".length(), " ", true);
                }
                output.append(cap.apply(month));
                i += 5;
                continue;
            }
            cap = ToChar.containsAt(format, i, "MON");
            if (cap != null) {
                String month = new SimpleDateFormat("MMM").format(ts);
                output.append(cap.apply(month));
                i += 3;
                continue;
            }
            cap = ToChar.containsAt(format, i, "MM");
            if (cap != null) {
                output.append(String.format("%02d", cal.get(2) + 1));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "RM");
            if (cap != null) {
                int month = cal.get(2) + 1;
                output.append(cap.apply(ToChar.toRomanNumeral(month)));
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "Q");
            if (cap != null) {
                int q = (int)(1.0 + Math.floor(cal.get(2) / 3));
                output.append(q);
                ++i;
                continue;
            }
            cap = ToChar.containsAt(format, i, "X");
            if (cap != null) {
                char c = DecimalFormatSymbols.getInstance().getDecimalSeparator();
                output.append(c);
                ++i;
                continue;
            }
            cap = ToChar.containsAt(format, i, "FM");
            if (cap != null) {
                fillMode = !fillMode;
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "FX");
            if (cap != null) {
                i += 2;
                continue;
            }
            cap = ToChar.containsAt(format, i, "\"");
            if (cap != null) {
                ++i;
                while (i < format.length()) {
                    char c = format.charAt(i);
                    if (c == '\"') {
                        ++i;
                        continue block0;
                    }
                    output.append(c);
                    ++i;
                }
                continue;
            }
            if (format.charAt(i) == '-' || format.charAt(i) == '/' || format.charAt(i) == ',' || format.charAt(i) == '.' || format.charAt(i) == ';' || format.charAt(i) == ':' || format.charAt(i) == ' ') {
                output.append(format.charAt(i));
                ++i;
                continue;
            }
            throw DbException.get(90010, format);
        }
        return output.toString();
    }

    private static int getYear(Calendar cal) {
        int year = cal.get(1);
        if (cal.get(0) == 0) {
            --year;
        }
        return year;
    }

    private static Capitalization containsAt(String s, int index, String ... substrings) {
        for (String substring : substrings) {
            if (index + substring.length() > s.length()) continue;
            boolean found = true;
            Boolean up1 = null;
            Boolean up2 = null;
            for (int i = 0; i < substring.length(); ++i) {
                char c2;
                char c1 = s.charAt(index + i);
                if (c1 != (c2 = substring.charAt(i)) && Character.toUpperCase(c1) != Character.toUpperCase(c2)) {
                    found = false;
                    break;
                }
                if (!Character.isLetter(c1)) continue;
                if (up1 == null) {
                    up1 = Character.isUpperCase(c1);
                    continue;
                }
                if (up2 != null) continue;
                up2 = Character.isUpperCase(c1);
            }
            if (!found) continue;
            return Capitalization.toCapitalization(up1, up2);
        }
        return null;
    }

    static {
        GregorianCalendar epoch = new GregorianCalendar(Locale.ENGLISH);
        epoch.setGregorianChange(new Date(Long.MAX_VALUE));
        epoch.clear();
        epoch.set(4713, 0, 1, 0, 0, 0);
        epoch.set(0, 0);
        JULIAN_EPOCH = epoch.getTimeInMillis();
    }

    private static enum Capitalization {
        UPPERCASE,
        LOWERCASE,
        CAPITALIZE;


        public static Capitalization toCapitalization(Boolean up1, Boolean up2) {
            if (up1 == null) {
                return CAPITALIZE;
            }
            if (up2 == null) {
                return up1 != false ? UPPERCASE : LOWERCASE;
            }
            if (up1.booleanValue()) {
                return up2 != false ? UPPERCASE : CAPITALIZE;
            }
            return LOWERCASE;
        }

        public String apply(String s) {
            if (s == null || s.isEmpty()) {
                return s;
            }
            switch (this) {
                case UPPERCASE: {
                    return s.toUpperCase();
                }
                case LOWERCASE: {
                    return s.toLowerCase();
                }
                case CAPITALIZE: {
                    return Character.toUpperCase(s.charAt(0)) + (s.length() > 1 ? s.toLowerCase().substring(1) : "");
                }
            }
            throw new IllegalArgumentException("Unknown capitalization strategy: " + (Object)((Object)this));
        }
    }
}

