/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueDecimal
extends Value {
    public static final Object ZERO = new ValueDecimal(BigDecimal.ZERO);
    public static final Object ONE = new ValueDecimal(BigDecimal.ONE);
    static final int DEFAULT_PRECISION = 65535;
    static final int DEFAULT_SCALE = Short.MAX_VALUE;
    static final int DEFAULT_DISPLAY_SIZE = 65535;
    private static final int DIVIDE_SCALE_ADD = 25;
    private static final int BIG_DECIMAL_SCALE_MAX = 100000;
    private final BigDecimal value;
    private String valueString;
    private int precision;

    private ValueDecimal(BigDecimal value) {
        if (value == null) {
            throw new IllegalArgumentException("null");
        }
        if (!value.getClass().equals(BigDecimal.class)) {
            throw DbException.get(90125, BigDecimal.class.getName(), value.getClass().getName());
        }
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        return ValueDecimal.get(this.value.add(dec.value));
    }

    @Override
    public Value subtract(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        return ValueDecimal.get(this.value.subtract(dec.value));
    }

    @Override
    public Value negate() {
        return ValueDecimal.get(this.value.negate());
    }

    @Override
    public Value multiply(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        return ValueDecimal.get(this.value.multiply(dec.value));
    }

    @Override
    public Value divide(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        if (dec.value.signum() == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        BigDecimal bd = this.value.divide(dec.value, this.value.scale() + 25, 5);
        if (bd.signum() == 0) {
            bd = BigDecimal.ZERO;
        } else if (bd.scale() > 0 && !bd.unscaledValue().testBit(0)) {
            bd = bd.stripTrailingZeros();
        }
        return ValueDecimal.get(bd);
    }

    @Override
    public ValueDecimal modulus(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        if (dec.value.signum() == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        BigDecimal bd = this.value.remainder(dec.value);
        return ValueDecimal.get(bd);
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueDecimal v = (ValueDecimal)o;
        return this.value.compareTo(v.value);
    }

    @Override
    public int getSignum() {
        return this.value.signum();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.value;
    }

    @Override
    public String getString() {
        if (this.valueString == null) {
            String p = this.value.toPlainString();
            this.valueString = p.length() < 40 ? p : this.value.toString();
        }
        return this.valueString;
    }

    @Override
    public long getPrecision() {
        if (this.precision == 0) {
            this.precision = this.value.precision();
        }
        return this.precision;
    }

    @Override
    public boolean checkPrecision(long prec) {
        if (prec == 65535L) {
            return true;
        }
        return this.getPrecision() <= prec;
    }

    @Override
    public int getScale() {
        return this.value.scale();
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBigDecimal(parameterIndex, this.value);
    }

    @Override
    public Value convertScale(boolean onlyToSmallerScale, int targetScale) {
        if (this.value.scale() == targetScale) {
            return this;
        }
        if ((onlyToSmallerScale || targetScale >= Short.MAX_VALUE) && this.value.scale() < targetScale) {
            return this;
        }
        BigDecimal bd = ValueDecimal.setScale(this.value, targetScale);
        return ValueDecimal.get(bd);
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if (this.getPrecision() <= precision) {
            return this;
        }
        if (force) {
            return ValueDecimal.get(BigDecimal.valueOf(this.value.doubleValue()));
        }
        throw DbException.get(22003, Long.toString(precision));
    }

    public static ValueDecimal get(BigDecimal dec) {
        if (BigDecimal.ZERO.equals(dec)) {
            return (ValueDecimal)ZERO;
        }
        if (BigDecimal.ONE.equals(dec)) {
            return (ValueDecimal)ONE;
        }
        return (ValueDecimal)Value.cache(new ValueDecimal(dec));
    }

    @Override
    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision() + 2L);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueDecimal && this.value.equals(((ValueDecimal)other).value);
    }

    @Override
    public int getMemory() {
        return this.value.precision() + 120;
    }

    public static BigDecimal setScale(BigDecimal bd, int scale) {
        if (scale > 100000 || scale < -100000) {
            throw DbException.getInvalidValueException("scale", scale);
        }
        return bd.setScale(scale, 4);
    }
}

