/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.bridge.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.core.model.bridge.local.ClassLoaderObjectConverter;
import org.jboss.as.core.model.bridge.local.OperationTransactionControlProxy;
import org.jboss.as.core.model.test.KernelServices;
import org.jboss.as.host.controller.ignored.IgnoreDomainResourceTypeResource;
import org.jboss.as.model.test.ModelTestLegacyControllerKernelServicesProxy;
import org.jboss.dmr.ModelNode;

public class LegacyControllerKernelServicesProxy
extends ModelTestLegacyControllerKernelServicesProxy
implements KernelServices {
    private final ClassLoaderObjectConverter converter;
    private Method applyMasterDomainModel;

    public LegacyControllerKernelServicesProxy(ClassLoader childFirstClassLoader, Object childFirstClassLoaderServices, ClassLoaderObjectConverter converter) {
        super(childFirstClassLoader, childFirstClassLoaderServices);
        this.converter = converter;
    }

    public KernelServices getLegacyServices(ModelVersion modelVersion) {
        throw new IllegalStateException("Can only be called for the main controller");
    }

    public void applyMasterDomainModel(ModelNode resources, List<IgnoreDomainResourceTypeResource> ignoredResources) {
        try {
            if (this.applyMasterDomainModel == null) {
                this.applyMasterDomainModel = this.childFirstClassLoaderServices.getClass().getMethod("applyMasterDomainModel", this.childFirstClassLoader.loadClass(resources.getClass().getName()), List.class);
            }
            ArrayList<Object> convertedResources = new ArrayList<Object>();
            if (ignoredResources != null) {
                for (IgnoreDomainResourceTypeResource resource : ignoredResources) {
                    convertedResources.add(this.converter.convertIgnoreDomainTypeResourceToChildCl(resource));
                }
            }
            this.applyMasterDomainModel.invoke(this.childFirstClassLoaderServices, this.converter.convertModelNodeToChildCl(resources), convertedResources);
        }
        catch (Exception e) {
            this.unwrapInvocationTargetRuntimeException(e);
            throw new RuntimeException(e);
        }
    }

    protected Object convertModelNodeToChildCl(ModelNode modelNode) {
        return this.converter.convertModelNodeToChildCl(modelNode);
    }

    protected ModelNode convertModelNodeFromChildCl(Object object) {
        return this.converter.convertModelNodeFromChildCl(object);
    }

    protected String getOperationTransactionProxyClassName() {
        return OperationTransactionControlProxy.class.getName();
    }

    @Override
    public void applyMasterDomainModel(ModelVersion modelVersion, List<IgnoreDomainResourceTypeResource> ignoredResources) {
        throw new IllegalStateException("Can only be called for the main controller");
    }
}

