/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.util.List;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformerOperationAttachment;
import org.jboss.as.core.model.test.AbstractKernelServicesImpl;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.ignored.IgnoreDomainResourceTypeResource;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResource;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.repository.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceContainer;

public class LegacyKernelServicesImpl
extends AbstractKernelServicesImpl {
    private final ContentRepository contentRepository;

    public LegacyKernelServicesImpl(ServiceContainer container, ModelTestModelControllerService controllerService, StringConfigurationPersister persister, ManagementResourceRegistration rootRegistration, OperationValidator operationValidator, ModelVersion legacyModelVersion, boolean successfulBoot, Throwable bootError, ExtensionRegistry extensionRegistry, ContentRepository contentRepository) {
        super(container, controllerService, persister, rootRegistration, operationValidator, legacyModelVersion, successfulBoot, bootError, extensionRegistry);
        this.contentRepository = contentRepository;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(ModelVersion modelVersion, ModelNode operation) throws OperationFailedException {
        this.checkIsMainController();
        return null;
    }

    public OperationTransformer.TransformedOperation transformOperation(ModelVersion modelVersion, ModelNode operation, TransformerOperationAttachment attachment) throws OperationFailedException {
        this.checkIsMainController();
        return null;
    }

    @Override
    public ModelNode readTransformedModel(ModelVersion modelVersion) {
        this.checkIsMainController();
        return null;
    }

    @Override
    public ModelNode executeOperation(ModelVersion modelVersion, OperationTransformer.TransformedOperation op) {
        this.checkIsMainController();
        return null;
    }

    @Override
    public ModelNode callReadMasterDomainModelHandler(ModelVersion modelVersion) {
        this.checkIsMainController();
        return null;
    }

    @Override
    public void applyMasterDomainModel(ModelVersion modelVersion, List<IgnoreDomainResourceTypeResource> ignoredResources) {
        this.checkIsMainController();
    }

    public void applyMasterDomainModel(ModelNode resources, List<IgnoreDomainResourceTypeResource> ignoredResources) {
        ModelNode applyDomainModel = new ModelNode();
        applyDomainModel.get("operation").set("apply-remote-domain-model");
        applyDomainModel.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
        applyDomainModel.get("address").setEmptyList();
        applyDomainModel.get("domain-model").set(resources);
        final IgnoredDomainResourceRegistry ignoredResourceRegistry = this.createIgnoredDomainResourceRegistry(ignoredResources);
        ModelNode response = this.internalExecute(applyDomainModel, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                try {
                    ModelNode domainModel = operation.get("domain-model");
                    ModelNode startRoot = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS));
                    Resource rootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
                    for (ModelNode resourceDescription : domainModel.asList()) {
                        PathAddress resourceAddress = PathAddress.pathAddress((ModelNode)resourceDescription.require("domain-resource-address"));
                        if (ignoredResourceRegistry.isResourceExcluded(resourceAddress)) continue;
                        Resource resource = this.getResource(resourceAddress, rootResource, context);
                        if (resourceAddress.size() == 1 && resourceAddress.getElement(0).getKey().equals("extension")) continue;
                        resource.writeModel(resourceDescription.get("domain-resource-model"));
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                        }
                    });
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getMessage());
                }
            }

            private Resource getResource(PathAddress resourceAddress, Resource rootResource, OperationContext context) {
                if (resourceAddress.size() == 0) {
                    return rootResource;
                }
                Resource temp = rootResource;
                int idx = 0;
                for (PathElement element : resourceAddress) {
                    if ((temp = temp.getChild(element)) == null) {
                        if (idx == 0) {
                            String type = element.getKey();
                            if (type.equals("extension")) continue;
                            if (type.equals("management-client-content") && element.getValue().equals("rollout-plans")) {
                                temp = new ManagedDMRContentTypeResource(element, "rollout-plan", null, LegacyKernelServicesImpl.this.contentRepository);
                                context.addResource(resourceAddress, temp);
                            }
                        }
                        if (temp != null) break;
                        temp = context.createResource(resourceAddress);
                        break;
                    }
                    ++idx;
                }
                return temp;
            }
        });
        if (!"success".equals(response.get("outcome").asString())) {
            throw new RuntimeException(response.get("failure-description").asString());
        }
    }

    private IgnoredDomainResourceRegistry createIgnoredDomainResourceRegistry(List<IgnoreDomainResourceTypeResource> ignoredResources) {
        IgnoredDomainResourceRegistry reg = new IgnoredDomainResourceRegistry(new LocalHostControllerInfo(){

            public boolean isMasterDomainController() {
                return false;
            }

            public String getRemoteDomainControllerUsername() {
                return null;
            }

            public List<DiscoveryOption> getRemoteDomainControllerDiscoveryOptions() {
                return null;
            }

            public ControlledProcessState.State getProcessState() {
                return null;
            }

            public int getNativeManagementPort() {
                return 0;
            }

            public String getNativeManagementInterface() {
                return null;
            }

            public String getLocalHostName() {
                return null;
            }

            public int getHttpManagementSecurePort() {
                return 0;
            }

            public int getHttpManagementPort() {
                return 0;
            }

            public String getHttpManagementInterface() {
                return null;
            }

            public String getHttpManagementSecureInterface() {
                return null;
            }

            public boolean isRemoteDomainControllerIgnoreUnaffectedConfiguration() {
                return false;
            }

            public boolean isBackupDc() {
                return false;
            }

            public boolean isUsingCachedDc() {
                return false;
            }
        });
        for (IgnoreDomainResourceTypeResource resource : ignoredResources) {
            reg.getRootResource().registerChild(PathElement.pathElement((String)"ignored-resource-type", (String)resource.getName()), (Resource)resource);
        }
        return reg;
    }
}

