/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.util.Locale;
import java.util.Map;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.jboss.logging.Logger;

public class LobTypeMappings {
    private static final Logger log = Logger.getLogger(LobTypeMappings.class);
    public static final LobTypeMappings INSTANCE = new LobTypeMappings();
    private final Map<Integer, Integer> lobCodeByNonLobCode = new BoundedConcurrentHashMap<Integer, Integer>();

    private LobTypeMappings() {
        this.lobCodeByNonLobCode.put(2004, 2004);
        this.lobCodeByNonLobCode.put(-2, 2004);
        this.lobCodeByNonLobCode.put(-3, 2004);
        this.lobCodeByNonLobCode.put(-4, 2004);
        this.lobCodeByNonLobCode.put(2005, 2005);
        this.lobCodeByNonLobCode.put(1, 2005);
        this.lobCodeByNonLobCode.put(12, 2005);
        this.lobCodeByNonLobCode.put(-1, 2005);
        this.lobCodeByNonLobCode.put(2011, 2011);
        this.lobCodeByNonLobCode.put(-15, 2011);
        this.lobCodeByNonLobCode.put(-9, 2011);
        this.lobCodeByNonLobCode.put(-16, 2011);
    }

    public boolean hasCorrespondingLobCode(int jdbcTypeCode) {
        return this.lobCodeByNonLobCode.containsKey(jdbcTypeCode);
    }

    public int getCorrespondingLobCode(int jdbcTypeCode) {
        Integer lobTypeCode = this.lobCodeByNonLobCode.get(jdbcTypeCode);
        if (lobTypeCode == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "JDBC type-code [%s (%s)] not known to have a corresponding LOB equivalent", jdbcTypeCode, JdbcTypeNameMapper.getTypeName(jdbcTypeCode)));
        }
        return lobTypeCode;
    }
}

