/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.handlers.DisallowedMethodsHandler;
import io.undertow.server.handlers.PeerNameResolvingHandler;
import io.undertow.servlet.handlers.MarkSecureHandler;
import io.undertow.util.HttpString;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.io.OptionList;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

abstract class ListenerAdd
extends AbstractAddStepHandler {
    ListenerAdd(ListenerResourceDefinition definition) {
        super(definition.getAttributes());
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        String ourCap = ListenerResourceDefinition.LISTENER_CAPABILITY.getDynamicName(context.getCurrentAddress());
        String serverCap = ServerDefinition.SERVER_CAPABILITY.getDynamicName(context.getCurrentAddress().getParent());
        context.registerAdditionalCapabilityRequirement(serverCap, ourCap, null);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        List disallowedMethods;
        PathAddress address = context.getCurrentAddress();
        PathAddress parent = address.getParent();
        String name = context.getCurrentAddressValue();
        String bindingRef = ListenerResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asString();
        String workerName = ListenerResourceDefinition.WORKER.resolveModelAttribute(context, model).asString();
        String bufferPoolName = ListenerResourceDefinition.BUFFER_POOL.resolveModelAttribute(context, model).asString();
        boolean enabled = ListenerResourceDefinition.ENABLED.resolveModelAttribute(context, model).asBoolean();
        boolean peerHostLookup = ListenerResourceDefinition.RESOLVE_PEER_ADDRESS.resolveModelAttribute(context, model).asBoolean();
        boolean secure = ListenerResourceDefinition.SECURE.resolveModelAttribute(context, model).asBoolean();
        OptionMap listenerOptions = OptionList.resolveOptions((ExpressionResolver)context, (ModelNode)model, ListenerResourceDefinition.LISTENER_OPTIONS);
        OptionMap.Builder builder = OptionMap.builder().addAll(listenerOptions);
        boolean preservePath = Boolean.parseBoolean(System.getProperty("io.undertow.servlet.dispatch.preserve_path_of_forward", "false"));
        builder.set(UndertowOptions.PRESERVE_PATH_ON_FORWARD, preservePath);
        listenerOptions = builder.getMap();
        OptionMap socketOptions = OptionList.resolveOptions((ExpressionResolver)context, (ModelNode)model, ListenerResourceDefinition.SOCKET_OPTIONS);
        String serverName = parent.getLastElement().getValue();
        ListenerService service = this.createService(name, serverName, context, model, listenerOptions, socketOptions);
        if (peerHostLookup) {
            service.addWrapperHandler(PeerNameResolvingHandler::new);
        }
        service.setEnabled(enabled);
        if (secure) {
            service.addWrapperHandler(MarkSecureHandler.WRAPPER);
        }
        if (!(disallowedMethods = ListenerResourceDefinition.DISALLOWED_METHODS.unwrap((ExpressionResolver)context, model)).isEmpty()) {
            HashSet<HttpString> methodSet = new HashSet<HttpString>();
            for (String i : disallowedMethods) {
                HttpString httpString = new HttpString(i.trim());
                methodSet.add(httpString);
            }
            service.addWrapperHandler(handler -> new DisallowedMethodsHandler(handler, methodSet));
        }
        CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(ListenerResourceDefinition.LISTENER_CAPABILITY, (Service)service);
        serviceBuilder.addCapabilityRequirement("org.wildfly.io.worker", XnioWorker.class, service.getWorker(), new String[]{workerName}).addCapabilityRequirement("org.wildfly.network.socket-binding", SocketBinding.class, service.getBinding(), new String[]{bindingRef}).addCapabilityRequirement("org.wildfly.undertow.byte-buffer-pool", ByteBufferPool.class, service.getBufferPool(), new String[]{bufferPoolName}).addCapabilityRequirement("org.wildfly.undertow.server", Server.class, service.getServerService(), new String[]{serverName}).addAliases(new ServiceName[]{UndertowService.listenerName(name)});
        this.configureAdditionalDependencies(context, (CapabilityServiceBuilder<? extends UndertowListener>)serviceBuilder, model, service);
        serviceBuilder.install();
    }

    abstract ListenerService createService(String var1, String var2, OperationContext var3, ModelNode var4, OptionMap var5, OptionMap var6) throws OperationFailedException;

    abstract void configureAdditionalDependencies(OperationContext var1, CapabilityServiceBuilder<? extends UndertowListener> var2, ModelNode var3, ListenerService var4) throws OperationFailedException;
}

