/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.rar;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.bv.BeanValidationUtil;
import org.jboss.jca.core.rar.SecurityActions;
import org.jboss.jca.core.spi.rar.Endpoint;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class EndpointImpl
implements Endpoint {
    private WeakReference<ResourceAdapter> ra;
    private boolean is16;
    private Set<String> beanValidationGroups;
    private String productName;
    private String productVersion;
    private TransactionIntegration transactionIntegration;
    private boolean xa;
    private Map<ActivationSpec, XAResourceRecovery> recovery;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)Endpoint.class.getName());
    private static boolean bvEnabled = Boolean.valueOf(SecurityActions.getSystemProperty("ironjacamar.bv.inflow", "true"));

    EndpointImpl(WeakReference<ResourceAdapter> ra, boolean is16, Set<String> bvg, String productName, String productVersion, TransactionIntegration ti, boolean xa) {
        this.ra = ra;
        this.is16 = is16;
        this.beanValidationGroups = bvg;
        this.productName = productName;
        this.productVersion = productVersion;
        this.transactionIntegration = ti;
        this.xa = xa;
        this.recovery = new HashMap<ActivationSpec, XAResourceRecovery>();
    }

    public void activate(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        if (endpointFactory == null) {
            throw new IllegalArgumentException("MessageEndpointFactory is null");
        }
        if (spec == null) {
            throw new IllegalArgumentException("ActivationSpec is null");
        }
        ResourceAdapter rar = (ResourceAdapter)this.ra.get();
        if (rar == null) {
            throw new ResourceException(bundle.resourceAdapterInstanceNotActive());
        }
        if (this.is16 && bvEnabled) {
            ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
            try {
                Class[] vargs;
                Validator validator;
                Set errors;
                SecurityActions.setThreadContextClassLoader(SecurityActions.getClassLoader(rar.getClass()));
                ArrayList groups = new ArrayList(1);
                if (this.beanValidationGroups != null) {
                    for (String group : this.beanValidationGroups) {
                        try {
                            Class<?> clz = Class.forName(group, true, SecurityActions.getClassLoader(rar.getClass()));
                            groups.add(clz);
                        }
                        catch (Throwable t) {
                            log.debugf(t, "Unable to load bean validation group: %s", group);
                        }
                    }
                }
                if (groups.isEmpty()) {
                    groups.add(Default.class);
                }
                if ((errors = (validator = BeanValidationUtil.createValidator()).validate((Object)spec, vargs = groups.toArray(new Class[groups.size()]))) != null && errors.size() > 0) {
                    throw new ResourceException(bundle.validationException(), (Throwable)new ConstraintViolationException(errors));
                }
            }
            catch (RuntimeException re) {
                throw new ResourceException(bundle.validationException(), (Throwable)re);
            }
            finally {
                SecurityActions.setThreadContextClassLoader(oldTCCL);
            }
        }
        try {
            spec.validate();
        }
        catch (UnsupportedOperationException oldTCCL) {
            // empty catch block
        }
        rar.endpointActivation(endpointFactory, spec);
        if (this.transactionIntegration != null && this.transactionIntegration.getRecoveryRegistry() != null && this.xa) {
            XAResourceRecovery xrr = this.transactionIntegration.createXAResourceRecovery(rar, spec, this.productName, this.productVersion);
            log.tracef("Adding %s for recovery", xrr);
            try {
                xrr.initialize();
                this.transactionIntegration.getRecoveryRegistry().addXAResourceRecovery(xrr);
                this.recovery.put(spec, xrr);
            }
            catch (Exception e) {
                throw new ResourceException(bundle.errorDuringRecoveryInitialization(), (Throwable)e);
            }
        }
    }

    public void deactivate(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        XAResourceRecovery xrr;
        if (endpointFactory == null) {
            throw new IllegalArgumentException("MessageEndpointFactory is null");
        }
        if (spec == null) {
            throw new IllegalArgumentException("ActivationSpec is null");
        }
        ResourceAdapter rar = (ResourceAdapter)this.ra.get();
        if (rar == null) {
            throw new ResourceException(bundle.resourceAdapterInstanceNotActive());
        }
        if (this.transactionIntegration != null && this.transactionIntegration.getRecoveryRegistry() != null && this.xa && (xrr = this.recovery.remove(spec)) != null) {
            log.tracef("Removing %s for recovery", xrr);
            try {
                xrr.shutdown();
            }
            catch (Exception e) {
                throw new ResourceException(bundle.errorDuringRecoveryShutdown(), (Throwable)e);
            }
            finally {
                this.transactionIntegration.getRecoveryRegistry().removeXAResourceRecovery(xrr);
            }
        }
        rar.endpointDeactivation(endpointFactory, spec);
    }
}

