/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.rxjava2;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.Map;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyContextPropagatingOnObservableCreateAction
implements BiFunction<Observable, Observer, Observer> {
    public Observer apply(Observable t1, Observer t2) throws Exception {
        return new ContextCapturerObserver(t2);
    }

    static final class ContextCapturerObserver<T>
    implements Observer<T> {
        final Map<Class<?>, Object> contextDataMap = ResteasyProviderFactory.getContextDataMap();
        final Observer<T> actual;

        public ContextCapturerObserver(Observer<T> actual) {
            this.actual = actual;
        }

        public void onError(Throwable e) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onError(e);
            ResteasyProviderFactory.removeContextDataLevel();
        }

        public void onNext(T t) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onNext(t);
            ResteasyProviderFactory.removeContextDataLevel();
        }

        public void onComplete() {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onComplete();
            ResteasyProviderFactory.removeContextDataLevel();
        }

        public void onSubscribe(Disposable d) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onSubscribe(d);
            ResteasyProviderFactory.removeContextDataLevel();
        }
    }
}

