/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.cluster.ha.ColocatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.HAManager;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public class ColocatedHAManager
implements HAManager {
    private final ColocatedPolicy haPolicy;
    private final ActiveMQServer server;
    private final Map<String, ActiveMQServer> backupServers = new HashMap<String, ActiveMQServer>();
    private boolean started;

    public ColocatedHAManager(ColocatedPolicy haPolicy, ActiveMQServer activeMQServer) {
        this.haPolicy = haPolicy;
        this.server = activeMQServer;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.server.getActivation().haStarted();
        this.started = true;
    }

    public void stop() {
        for (ActiveMQServer activeMQServer : this.backupServers.values()) {
            try {
                activeMQServer.stop();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorStoppingServer(e);
            }
        }
        this.backupServers.clear();
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized boolean activateBackup(int backupSize, String journalDirectory, String bindingsDirectory, String largeMessagesDirectory, String pagingDirectory, SimpleString nodeID) throws Exception {
        if (this.backupServers.size() >= this.haPolicy.getMaxBackups() || backupSize != this.backupServers.size()) {
            return false;
        }
        if (this.haPolicy.getBackupPolicy().isSharedStore()) {
            return this.activateSharedStoreBackup(journalDirectory, bindingsDirectory, largeMessagesDirectory, pagingDirectory);
        }
        return this.activateReplicatedBackup(nodeID);
    }

    @Override
    public Map<String, ActiveMQServer> getBackupServers() {
        return this.backupServers;
    }

    public boolean requestBackup(Pair<TransportConfiguration, TransportConfiguration> connectorPair, int backupSize, boolean replicated) throws Exception {
        ClusterController clusterController = this.server.getClusterManager().getClusterController();
        try (ClusterControl clusterControl = clusterController.connectToNode((TransportConfiguration)connectorPair.getA());){
            clusterControl.authorize();
            if (replicated) {
                boolean bl = clusterControl.requestReplicatedBackup(backupSize, this.server.getNodeID());
                return bl;
            }
            boolean bl = clusterControl.requestSharedStoreBackup(backupSize, this.server.getConfiguration().getJournalLocation().getAbsolutePath(), this.server.getConfiguration().getBindingsLocation().getAbsolutePath(), this.server.getConfiguration().getLargeMessagesLocation().getAbsolutePath(), this.server.getConfiguration().getPagingLocation().getAbsolutePath());
            return bl;
        }
    }

    private synchronized boolean activateSharedStoreBackup(String journalDirectory, String bindingsDirectory, String largeMessagesDirectory, String pagingDirectory) throws Exception {
        Configuration configuration = this.server.getConfiguration().copy();
        ActiveMQServer backup = this.server.createBackupServer(configuration);
        try {
            int portOffset = this.haPolicy.getBackupPortOffset() * (this.backupServers.size() + 1);
            String name = "colocated_backup_" + this.backupServers.size() + 1;
            this.haPolicy.getBackupPolicy().setRestartBackup(false);
            backup.setHAPolicy(this.haPolicy.getBackupPolicy());
            ColocatedHAManager.updateSharedStoreConfiguration(configuration, name, portOffset, this.haPolicy.getExcludedConnectors(), journalDirectory, bindingsDirectory, largeMessagesDirectory, pagingDirectory, this.haPolicy.getBackupPolicy().getScaleDownPolicy() == null);
            this.backupServers.put(configuration.getName(), backup);
            backup.start();
        }
        catch (Exception e) {
            backup.stop();
            ActiveMQServerLogger.LOGGER.activateSharedStoreSlaveFailed(e);
            return false;
        }
        ActiveMQServerLogger.LOGGER.activatingSharedStoreSlave();
        return true;
    }

    private synchronized boolean activateReplicatedBackup(SimpleString nodeID) throws Exception {
        Configuration configuration = this.server.getConfiguration().copy();
        ActiveMQServer backup = this.server.createBackupServer(configuration);
        try {
            TopologyMemberImpl member = this.server.getClusterManager().getDefaultConnection(null).getTopology().getMember(nodeID.toString());
            int portOffset = this.haPolicy.getBackupPortOffset() * (this.backupServers.size() + 1);
            String name = "colocated_backup_" + this.backupServers.size() + 1;
            this.haPolicy.getBackupPolicy().setRestartBackup(false);
            backup.setHAPolicy(this.haPolicy.getBackupPolicy());
            ColocatedHAManager.updateReplicatedConfiguration(configuration, name, portOffset, this.haPolicy.getExcludedConnectors(), this.haPolicy.getBackupPolicy().getScaleDownPolicy() == null);
            backup.addActivationParam("REPLICATION_ENDPOINT", member);
            this.backupServers.put(configuration.getName(), backup);
            backup.start();
        }
        catch (Exception e) {
            backup.stop();
            ActiveMQServerLogger.LOGGER.activateReplicatedBackupFailed(e);
            return false;
        }
        ActiveMQServerLogger.LOGGER.activatingReplica(nodeID);
        return true;
    }

    private static void updateSharedStoreConfiguration(Configuration backupConfiguration, String name, int portOffset, List<String> remoteConnectors, String journalDirectory, String bindingsDirectory, String largeMessagesDirectory, String pagingDirectory, boolean fullServer) {
        backupConfiguration.setName(name);
        backupConfiguration.setJournalDirectory(journalDirectory);
        backupConfiguration.setBindingsDirectory(bindingsDirectory);
        backupConfiguration.setLargeMessagesDirectory(largeMessagesDirectory);
        backupConfiguration.setPagingDirectory(pagingDirectory);
        ColocatedHAManager.updateAcceptorsAndConnectors(backupConfiguration, portOffset, remoteConnectors, fullServer);
    }

    private static void updateReplicatedConfiguration(Configuration backupConfiguration, String name, int portOffset, List<String> remoteConnectors, boolean fullServer) {
        backupConfiguration.setName(name);
        backupConfiguration.setJournalDirectory(backupConfiguration.getJournalDirectory() + name);
        backupConfiguration.setPagingDirectory(backupConfiguration.getPagingDirectory() + name);
        backupConfiguration.setLargeMessagesDirectory(backupConfiguration.getLargeMessagesDirectory() + name);
        backupConfiguration.setBindingsDirectory(backupConfiguration.getBindingsDirectory() + name);
        ColocatedHAManager.updateAcceptorsAndConnectors(backupConfiguration, portOffset, remoteConnectors, fullServer);
    }

    private static void updateAcceptorsAndConnectors(Configuration backupConfiguration, int portOffset, List<String> remoteConnectors, boolean fullServer) {
        if (fullServer) {
            Set<TransportConfiguration> acceptors = backupConfiguration.getAcceptorConfigurations();
            for (TransportConfiguration acceptor : acceptors) {
                ColocatedHAManager.updatebackupParams(backupConfiguration.getName(), portOffset, acceptor.getParams());
            }
            Map<String, TransportConfiguration> connectorConfigurations = backupConfiguration.getConnectorConfigurations();
            for (Map.Entry<String, TransportConfiguration> entry : connectorConfigurations.entrySet()) {
                if (remoteConnectors.contains(entry.getValue().getName())) continue;
                ColocatedHAManager.updatebackupParams(backupConfiguration.getName(), portOffset, entry.getValue().getParams());
            }
        } else {
            backupConfiguration.getAcceptorConfigurations().clear();
        }
    }

    private static void updatebackupParams(String name, int portOffset, Map<String, Object> params) {
        if (params != null) {
            Object serverId;
            boolean httpUpgradeEnabled;
            Object port = params.get("port");
            if (port != null && !(httpUpgradeEnabled = ConfigurationHelper.getBooleanProperty((String)"httpUpgradeEnabled", (boolean)false, params))) {
                Integer integer = Integer.valueOf(port.toString());
                integer = integer + portOffset;
                params.put("port", integer.toString());
            }
            if ((serverId = params.get("serverId")) != null) {
                Integer newid = Integer.parseInt(serverId.toString()) + portOffset;
                params.put("serverId", newid.toString());
            }
            params.put("activemqServerName", name);
        }
    }
}

