/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.dmr.ValueExpression;
import org.jboss.migration.core.AbstractServer;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.jboss.AbsolutePathResolver;
import org.jboss.migration.core.jboss.Extension;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.jboss.ModuleIdentifier;
import org.jboss.migration.core.jboss.ModuleSpecification;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.util.xml.SimpleXMLFileMatcher;
import org.jboss.migration.core.util.xml.XMLFiles;

public abstract class JBossServer<S extends JBossServer<S>>
extends AbstractServer
implements AbsolutePathResolver {
    private final Environment environment = new Environment(this);
    private final Path domainBaseDir;
    private final Path domainConfigDir;
    private final Path domainDataDir;
    private final Path domainContentDir;
    private final Path standaloneServerDir;
    private final Path standaloneConfigDir;
    private final Path standaloneDataDir;
    private final Path standaloneContentDir;
    private final ValueExpressionResolver expressionResolver;
    private final Map<String, Path> pathResolver;
    private final Modules modules;
    private final Extensions extensions;

    public JBossServer(String migrationName, ProductInfo productInfo, Path baseDir, MigrationEnvironment migrationEnvironment, Extensions extensions) {
        super(migrationName, productInfo, baseDir, migrationEnvironment);
        this.domainBaseDir = this.getServerDir(this.environment.getDomainBaseDir(), baseDir);
        this.domainConfigDir = this.getServerDir(this.environment.getDomainConfigDir(), this.domainBaseDir);
        this.domainDataDir = this.getServerDir(this.environment.getDomainDataDir(), this.domainBaseDir);
        this.domainContentDir = this.getServerDir(this.environment.getDomainContentDir(), this.domainDataDir);
        this.standaloneServerDir = this.getServerDir(this.environment.getStandaloneServerDir(), baseDir);
        this.standaloneConfigDir = this.getServerDir(this.environment.getStandaloneConfigDir(), this.standaloneServerDir);
        this.standaloneDataDir = this.getServerDir(this.environment.getStandaloneDataDir(), this.standaloneServerDir);
        this.standaloneContentDir = this.getServerDir(this.environment.getStandaloneContentDir(), this.standaloneDataDir);
        this.expressionResolver = new ValueExpressionResolver();
        this.pathResolver = new HashMap<String, Path>();
        this.pathResolver.put("jboss.home.dir", baseDir);
        this.pathResolver.put("jboss.server.base.dir", this.standaloneServerDir);
        this.pathResolver.put("jboss.server.config.dir", this.standaloneConfigDir);
        this.pathResolver.put("jboss.server.content.dir", this.standaloneContentDir);
        this.pathResolver.put("jboss.server.data.dir", this.standaloneDataDir);
        this.pathResolver.put("jboss.server.deploy.dir", this.standaloneContentDir);
        this.pathResolver.put("jboss.server.log.dir", this.standaloneServerDir.resolve("log"));
        this.pathResolver.put("jboss.server.temp.dir", this.standaloneServerDir.resolve("tmp"));
        this.pathResolver.put("jboss.domain.base.dir", this.domainBaseDir);
        this.pathResolver.put("jboss.domain.config.dir", this.domainConfigDir);
        this.pathResolver.put("jboss.domain.content.dir", this.domainContentDir);
        this.pathResolver.put("jboss.domain.data.dir", this.domainDataDir);
        this.pathResolver.put("jboss.domain.deployment.dir", this.domainContentDir);
        this.pathResolver.put("jboss.domain.log.dir", this.domainBaseDir.resolve("log"));
        this.pathResolver.put("jboss.domain.servers.dir", this.domainBaseDir.resolve("servers"));
        this.pathResolver.put("jboss.domain.temp.dir", this.domainBaseDir.resolve("tmp"));
        this.modules = new Modules(baseDir);
        this.extensions = extensions;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    protected List<JBossServerConfiguration<S>> getConfigs(JBossServerConfiguration.Type configurationType) {
        String xmlDocumentElementName;
        List<String> envConfigs;
        ArrayList<JBossServerConfiguration<JBossServer>> configs = new ArrayList<JBossServerConfiguration<JBossServer>>();
        switch (configurationType) {
            case STANDALONE: {
                envConfigs = this.environment.getStandaloneConfigFiles();
                xmlDocumentElementName = "server";
                break;
            }
            case DOMAIN: {
                envConfigs = this.environment.getDomainConfigFiles();
                xmlDocumentElementName = "domain";
                break;
            }
            case HOST: {
                envConfigs = this.environment.getHostConfigFiles();
                xmlDocumentElementName = "host";
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown config type " + (Object)((Object)configurationType));
            }
        }
        if (envConfigs != null && !envConfigs.isEmpty()) {
            for (String envConfig : envConfigs) {
                Path config = Paths.get(envConfig, new String[0]);
                if (!config.isAbsolute()) {
                    config = this.getConfigurationDir(configurationType).resolve(config);
                }
                if (Files.exists(config, new LinkOption[0])) {
                    configs.add(new JBossServerConfiguration<JBossServer>(config, configurationType, this));
                    continue;
                }
                ServerMigrationLogger.ROOT_LOGGER.warnf("Config file %s, specified by the environment properties, does not exists.", config);
            }
        } else {
            SimpleXMLFileMatcher scanMatcher = new SimpleXMLFileMatcher(){

                @Override
                protected boolean documentElementLocalNameMatches(String localName) {
                    return xmlDocumentElementName.equals(localName);
                }

                @Override
                protected boolean documentNamespaceURIMatches(String namespaceURI) {
                    return namespaceURI.startsWith("urn:jboss:domain:");
                }
            };
            for (Path path : XMLFiles.scan(this.getConfigurationDir(configurationType), false, scanMatcher)) {
                configs.add(new JBossServerConfiguration<JBossServer>(path, configurationType, this));
            }
        }
        return Collections.unmodifiableList(configs);
    }

    public List<JBossServerConfiguration<S>> getStandaloneConfigs() {
        return this.getConfigs(JBossServerConfiguration.Type.STANDALONE);
    }

    public List<JBossServerConfiguration<S>> getDomainDomainConfigs() {
        return this.getConfigs(JBossServerConfiguration.Type.DOMAIN);
    }

    public List<JBossServerConfiguration<S>> getDomainHostConfigs() {
        return this.getConfigs(JBossServerConfiguration.Type.HOST);
    }

    private Path getServerDir(String name, Path relativeTo) {
        Path path = Paths.get(name, new String[0]);
        if (!path.isAbsolute()) {
            path = relativeTo.resolve(path);
        }
        return path;
    }

    public Path getDomainDir() {
        return this.domainBaseDir;
    }

    public Path getDefaultDomainDir() {
        return this.getServerDir(this.environment.getDefaultDomainBaseDir(), this.getBaseDir());
    }

    public Path getDomainConfigurationDir() {
        return this.domainConfigDir;
    }

    public Path getDefaultDomainConfigurationDir() {
        return this.getServerDir(this.environment.getDefaultDomainConfigDir(), this.getDefaultDomainDir());
    }

    public Path getDomainDataDir() {
        return this.domainDataDir;
    }

    public Path getDefaultDomainDataDir() {
        return this.getServerDir(this.environment.getDefaultDomainDataDir(), this.getDefaultDomainDir());
    }

    public Path getDomainContentDir() {
        return this.domainContentDir;
    }

    public Path getDefaultDomainContentDir() {
        return this.getServerDir(this.environment.getDefaultDomainContentDir(), this.getDefaultDomainDataDir());
    }

    public Path getStandaloneDir() {
        return this.standaloneServerDir;
    }

    public Path getDefaultStandaloneDir() {
        return this.getServerDir(this.environment.getDefaultStandaloneServerDir(), this.getBaseDir());
    }

    public Path getStandaloneConfigurationDir() {
        return this.standaloneConfigDir;
    }

    public Path getDefaultStandaloneConfigurationDir() {
        return this.getServerDir(this.environment.getDefaultStandaloneConfigDir(), this.getDefaultStandaloneDir());
    }

    public Path getStandaloneDataDir() {
        return this.standaloneDataDir;
    }

    public Path getDefaultStandaloneDataDir() {
        return this.getServerDir(this.environment.getDefaultStandaloneDataDir(), this.getDefaultStandaloneDir());
    }

    public Path getStandaloneContentDir() {
        return this.standaloneContentDir;
    }

    public Path getDefaultStandaloneContentDir() {
        return this.getServerDir(this.environment.getDefaultStandaloneContentDir(), this.getDefaultStandaloneDataDir());
    }

    public Path getConfigurationDir(JBossServerConfiguration.Type configurationType) {
        return configurationType == JBossServerConfiguration.Type.STANDALONE ? this.getStandaloneConfigurationDir() : this.getDomainConfigurationDir();
    }

    public Path getDataDir(JBossServerConfiguration.Type configurationType) {
        return configurationType == JBossServerConfiguration.Type.STANDALONE ? this.getStandaloneDataDir() : this.getDomainDataDir();
    }

    public Path getContentDir(JBossServerConfiguration.Type configurationType) {
        return configurationType == JBossServerConfiguration.Type.STANDALONE ? this.getStandaloneContentDir() : this.getDomainContentDir();
    }

    public String resolveExpression(String expression) {
        return this.expressionResolver.resolve(expression);
    }

    @Override
    public Path resolveNamedPath(String name) {
        String s;
        Path path = this.pathResolver.get(name);
        if (path == null && (s = this.expressionResolver.resolvePart(name)) != null) {
            path = Paths.get(s, new String[0]);
        }
        return path;
    }

    @Override
    public Path resolvePath(String path, String relativeTo) {
        Path resolvedPath;
        if ((path = this.resolveExpression(path)) == null && relativeTo == null) {
            return null;
        }
        if (relativeTo == null) {
            resolvedPath = Paths.get(path, new String[0]).toAbsolutePath();
        } else {
            Path resolvedRelativeTo = this.resolveNamedPath(relativeTo);
            if (resolvedRelativeTo == null) {
                return null;
            }
            resolvedPath = path != null ? resolvedRelativeTo.resolve(path).toAbsolutePath() : resolvedRelativeTo.toAbsolutePath();
        }
        return resolvedPath;
    }

    public Modules getModules() {
        return this.modules;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public static class Environment {
        public static String PROPERTIES_PREFIX = "server.";
        public static String PROPERTIES_DOMAIN_PREFIX = "domain.";
        public static String PROPERTY_DOMAIN_BASE_DIR = PROPERTIES_DOMAIN_PREFIX + "domainDir";
        public static String PROPERTY_DOMAIN_CONFIG_DIR = PROPERTIES_DOMAIN_PREFIX + "configDir";
        public static String PROPERTY_DOMAIN_DATA_DIR = PROPERTIES_DOMAIN_PREFIX + "dataDir";
        public static String PROPERTY_DOMAIN_CONTENT_DIR = PROPERTIES_DOMAIN_PREFIX + "contentDir";
        public static String PROPERTY_DOMAIN_DOMAIN_CONFIG_FILES = PROPERTIES_DOMAIN_PREFIX + "domainConfigFiles";
        public static String PROPERTY_DOMAIN_HOST_CONFIG_FILES = PROPERTIES_DOMAIN_PREFIX + "hostConfigFiles";
        public static String PROPERTIES_STANDALONE_PREFIX = "standalone.";
        public static String PROPERTY_STANDALONE_SERVER_DIR = PROPERTIES_STANDALONE_PREFIX + "serverDir";
        public static String PROPERTY_STANDALONE_CONFIG_DIR = PROPERTIES_STANDALONE_PREFIX + "configDir";
        public static String PROPERTY_STANDALONE_DATA_DIR = PROPERTIES_STANDALONE_PREFIX + "dataDir";
        public static String PROPERTY_STANDALONE_CONTENT_DIR = PROPERTIES_STANDALONE_PREFIX + "contentDir";
        public static String PROPERTY_STANDALONE_CONFIG_FILES = PROPERTIES_STANDALONE_PREFIX + "configFiles";
        private final String domainBaseDir;
        private final String domainConfigDir;
        private final String domainDataDir;
        private final String domainContentDir;
        private final List<String> domainConfigFiles;
        private final List<String> hostConfigFiles;
        private final String standaloneServerDir;
        private final String standaloneConfigDir;
        private final String standaloneDataDir;
        private final String standaloneContentDir;
        private final List<String> standaloneConfigFiles;

        public Environment(JBossServer server) {
            MigrationEnvironment migrationEnvironment = server.getMigrationEnvironment();
            String serverMigrationName = server.getMigrationName();
            this.domainBaseDir = migrationEnvironment.getPropertyAsString(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_DOMAIN_BASE_DIR));
            this.domainConfigDir = migrationEnvironment.getPropertyAsString(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_DOMAIN_CONFIG_DIR));
            this.domainDataDir = migrationEnvironment.getPropertyAsString(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_DOMAIN_DATA_DIR));
            this.domainContentDir = migrationEnvironment.getPropertyAsString(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_DOMAIN_CONTENT_DIR));
            this.domainConfigFiles = migrationEnvironment.getPropertyAsList(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_DOMAIN_DOMAIN_CONFIG_FILES));
            this.hostConfigFiles = migrationEnvironment.getPropertyAsList(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_DOMAIN_HOST_CONFIG_FILES));
            this.standaloneServerDir = migrationEnvironment.getPropertyAsString(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_STANDALONE_SERVER_DIR));
            this.standaloneConfigDir = migrationEnvironment.getPropertyAsString(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_STANDALONE_CONFIG_DIR));
            this.standaloneDataDir = migrationEnvironment.getPropertyAsString(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_STANDALONE_DATA_DIR));
            this.standaloneContentDir = migrationEnvironment.getPropertyAsString(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_STANDALONE_CONTENT_DIR));
            this.standaloneConfigFiles = migrationEnvironment.getPropertyAsList(Environment.getFullEnvironmentPropertyName(serverMigrationName, PROPERTY_STANDALONE_CONFIG_FILES));
        }

        public String getEnvironmentDomainBaseDir() {
            return this.domainBaseDir;
        }

        public String getEnvironmentDomainConfigDir() {
            return this.domainConfigDir;
        }

        public String getEnvironmentDomainDataDir() {
            return this.domainDataDir;
        }

        public String getEnvironmentDomainContentDir() {
            return this.domainContentDir;
        }

        public List<String> getEnvironmentDomainConfigFiles() {
            return this.domainConfigFiles;
        }

        public List<String> getEnvironmentHostConfigFiles() {
            return this.hostConfigFiles;
        }

        public String getEnvironmentStandaloneServerDir() {
            return this.standaloneServerDir;
        }

        public String getEnvironmentStandaloneConfigDir() {
            return this.standaloneConfigDir;
        }

        public String getEnvironmentStandaloneDataDir() {
            return this.standaloneDataDir;
        }

        public String getEnvironmentStandaloneContentDir() {
            return this.standaloneContentDir;
        }

        public List<String> getEnvironmentStandaloneConfigFiles() {
            return this.standaloneConfigFiles;
        }

        public String getDefaultDomainBaseDir() {
            return "domain";
        }

        public String getDefaultDomainConfigDir() {
            return "configuration";
        }

        public String getDefaultDomainDataDir() {
            return "data";
        }

        public String getDefaultDomainContentDir() {
            return "content";
        }

        public String getDefaultStandaloneServerDir() {
            return "standalone";
        }

        public String getDefaultStandaloneConfigDir() {
            return "configuration";
        }

        public String getDefaultStandaloneDataDir() {
            return "data";
        }

        public String getDefaultStandaloneContentDir() {
            return "content";
        }

        public String getDomainBaseDir() {
            return this.domainBaseDir == null ? this.getDefaultDomainBaseDir() : this.domainBaseDir;
        }

        public String getDomainConfigDir() {
            return this.domainConfigDir == null ? this.getDefaultDomainConfigDir() : this.domainConfigDir;
        }

        public String getDomainDataDir() {
            return this.domainDataDir == null ? this.getDefaultDomainDataDir() : this.domainDataDir;
        }

        public String getDomainContentDir() {
            return this.domainContentDir == null ? this.getDefaultDomainContentDir() : this.domainContentDir;
        }

        public List<String> getDomainConfigFiles() {
            return this.getEnvironmentDomainConfigFiles();
        }

        public List<String> getHostConfigFiles() {
            return this.getEnvironmentHostConfigFiles();
        }

        public String getStandaloneServerDir() {
            return this.standaloneServerDir == null ? this.getDefaultStandaloneServerDir() : this.standaloneServerDir;
        }

        public String getStandaloneConfigDir() {
            return this.standaloneConfigDir == null ? this.getDefaultStandaloneConfigDir() : this.standaloneConfigDir;
        }

        public String getStandaloneDataDir() {
            return this.standaloneDataDir == null ? this.getDefaultStandaloneDataDir() : this.standaloneDataDir;
        }

        public String getStandaloneContentDir() {
            return this.standaloneContentDir == null ? this.getDefaultStandaloneContentDir() : this.standaloneContentDir;
        }

        public List<String> getStandaloneConfigFiles() {
            return this.getEnvironmentStandaloneConfigFiles();
        }

        public boolean isDefaultDomainBaseDir() {
            return this.getEnvironmentDomainBaseDir() == null || this.getEnvironmentDomainBaseDir().equals(this.getDefaultDomainBaseDir());
        }

        public boolean isDefaultDomainConfigDir() {
            return this.getEnvironmentDomainConfigDir() == null || this.getEnvironmentDomainConfigDir().equals(this.getDefaultDomainConfigDir());
        }

        public boolean isDefaultDomainDataDir() {
            return this.getEnvironmentDomainDataDir() == null || this.getEnvironmentDomainDataDir().equals(this.getDefaultDomainDataDir());
        }

        public boolean isDefaultDomainContentDir() {
            return this.getEnvironmentDomainContentDir() == null || this.getEnvironmentDomainContentDir().equals(this.getDefaultDomainContentDir());
        }

        public boolean isDefaultStandaloneServerDir() {
            return this.getEnvironmentStandaloneServerDir() == null || this.getEnvironmentStandaloneServerDir().equals(this.getDefaultStandaloneServerDir());
        }

        public boolean isDefaultStandaloneConfigDir() {
            return this.getEnvironmentStandaloneConfigDir() == null || this.getEnvironmentStandaloneConfigDir().equals(this.getDefaultStandaloneConfigDir());
        }

        public boolean isDefaultStandaloneDataDir() {
            return this.getEnvironmentStandaloneDataDir() == null || this.getEnvironmentStandaloneDataDir().equals(this.getDefaultStandaloneDataDir());
        }

        public boolean isDefaultStandaloneContentDir() {
            return this.getEnvironmentStandaloneContentDir() == null || this.getEnvironmentStandaloneContentDir().equals(this.getDefaultStandaloneContentDir());
        }

        public static String getFullEnvironmentPropertyName(String serverMigrationName, String propertyName) {
            return PROPERTIES_PREFIX + serverMigrationName + "." + propertyName;
        }
    }

    public static class Extensions {
        private final Map<String, Extension> extensionMap;

        protected Extensions(Builder builder) {
            this.extensionMap = Collections.unmodifiableMap(builder.extensionMap);
        }

        public Collection<Extension> getExtensions() {
            return this.extensionMap.values();
        }

        public Set<String> getExtensionModuleNames() {
            return this.extensionMap.keySet();
        }

        public Extension getExtension(String moduleName) {
            return this.extensionMap.get(moduleName);
        }

        public static Builder builder() {
            return new DefaultBuilder();
        }

        private static class DefaultBuilder
        extends Builder {
            private DefaultBuilder() {
            }

            protected DefaultBuilder getThis() {
                return this;
            }
        }

        public static abstract class Builder<T extends Builder<T>> {
            private final Map<String, Extension> extensionMap = new HashMap<String, Extension>();

            protected abstract T getThis();

            public T extension(Extension extension) {
                this.extensionMap.put(extension.getModule(), extension);
                return this.getThis();
            }

            public T extension(Extension.Builder extensionBuilder) {
                return this.extension(extensionBuilder.build());
            }

            public T extensions(Extensions extensions) {
                this.extensionMap.putAll(extensions.extensionMap);
                return this.getThis();
            }

            public Extensions build() {
                return new Extensions(this);
            }
        }
    }

    public static class Modules {
        private final Path modulesDir;
        private final Path systemLayersBaseDir;
        private final Path overlayDir;

        public Modules(Path serverBaseDir) {
            this.modulesDir = serverBaseDir.resolve("modules");
            this.systemLayersBaseDir = this.modulesDir.resolve("system").resolve("layers").resolve("base");
            Path overlaysDir = this.systemLayersBaseDir.resolve(".overlays");
            Path overlaysFile = overlaysDir.resolve(".overlays");
            if (Files.exists(overlaysFile, new LinkOption[0])) {
                try {
                    String activeOverlayFileName = new String(Files.readAllBytes(overlaysFile)).trim();
                    if (!activeOverlayFileName.isEmpty()) {
                        this.overlayDir = overlaysDir.resolve(activeOverlayFileName);
                    }
                    this.overlayDir = null;
                }
                catch (IOException e) {
                    throw new ServerMigrationFailureException("failed to read overlays file", e);
                }
            } else {
                this.overlayDir = null;
            }
        }

        public Path getModulesDir() {
            return this.modulesDir;
        }

        public Module getModule(ModuleIdentifier moduleId) throws ServerMigrationFailureException {
            ModuleSpecification moduleSpecification;
            Path moduleDir = this.getModuleDir(moduleId);
            if (!Files.exists(moduleDir, new LinkOption[0])) {
                return null;
            }
            Path moduleSpecPath = moduleDir.resolve("module.xml");
            if (!Files.exists(moduleSpecPath, new LinkOption[0])) {
                return null;
            }
            try {
                moduleSpecification = ModuleSpecification.Parser.parse(moduleSpecPath);
            }
            catch (IOException | XMLStreamException e) {
                throw new ServerMigrationFailureException(e);
            }
            return new Module(moduleDir, moduleSpecification);
        }

        public Module getModule(String moduleId) throws ServerMigrationFailureException {
            return this.getModule(ModuleIdentifier.fromString(moduleId));
        }

        public Path getModuleDir(ModuleIdentifier moduleId) {
            Path overlayModuleDir;
            if (moduleId == null) {
                throw new IllegalArgumentException("The module identifier cannot be null.");
            }
            Path modulePath = Paths.get(moduleId.getName().replace('.', File.separatorChar) + File.separator + moduleId.getSlot(), new String[0]);
            if (this.overlayDir != null && Files.exists(overlayModuleDir = this.overlayDir.resolve(modulePath), new LinkOption[0])) {
                return overlayModuleDir;
            }
            Path systemLayersBaseModuleDir = this.systemLayersBaseDir.resolve(modulePath);
            if (Files.exists(systemLayersBaseModuleDir, new LinkOption[0])) {
                return systemLayersBaseModuleDir;
            }
            return this.modulesDir.resolve(modulePath);
        }
    }

    public static class Module {
        private final Path moduleDir;
        private final ModuleSpecification moduleSpecification;

        public Module(Path moduleDir, ModuleSpecification moduleSpecification) {
            this.moduleDir = moduleDir;
            this.moduleSpecification = moduleSpecification;
        }

        public ModuleSpecification getModuleSpecification() {
            return this.moduleSpecification;
        }

        public Path getModuleDir() {
            return this.moduleDir;
        }
    }

    public class ValueExpressionResolver
    extends org.jboss.dmr.ValueExpressionResolver {
        protected String resolvePart(String name) {
            Path path = (Path)JBossServer.this.pathResolver.get(name);
            if (path != null) {
                return path.toAbsolutePath().toString();
            }
            return super.resolvePart(name);
        }

        public String resolve(String value) {
            return this.isExpression(value) ? this.resolve(new ValueExpression(value)) : value;
        }

        protected boolean isExpression(String value) {
            int openIdx = value.indexOf("${");
            return openIdx > -1 && value.lastIndexOf(125) > openIdx;
        }
    }
}

