/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model.customization.ordering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.model.customization.ordering.PropOrderStrategy;

public class PropertyOrdering {
    private PropOrderStrategy propertyOrderStrategy;

    public PropertyOrdering(PropOrderStrategy propertyOrderStrategy) {
        Objects.requireNonNull(propertyOrderStrategy);
        this.propertyOrderStrategy = propertyOrderStrategy;
    }

    public List<PropertyModel> orderProperties(Map<String, Property> properties, ClassModel classModel, JsonbContext jsonbContext) {
        String[] order = classModel.getClassCustomization().getPropertyOrder();
        ArrayList<PropertyModel> sortedProperties = new ArrayList<PropertyModel>();
        if (order != null) {
            for (String propName : order) {
                Property remove = properties.remove(propName);
                if (remove == null) continue;
                sortedProperties.add(new PropertyModel(classModel, remove, jsonbContext));
            }
        }
        return Stream.of(sortedProperties, this.propertyOrderStrategy.sortProperties(properties.values().stream().map(prop -> new PropertyModel(classModel, (Property)prop, jsonbContext)).collect(Collectors.toList()))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public PropOrderStrategy getPropertyOrderStrategy() {
        return this.propertyOrderStrategy;
    }
}

