/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.Collection;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ManagementHelper {
    static AbstractAddStepHandler createAddOperation(final String childType, final boolean allowSibling, Collection<? extends AttributeDefinition> attributes) {
        return new ActiveMQReloadRequiredHandlers.AddStepHandler(attributes){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                super.execute(context, operation);
                if (!allowSibling) {
                    context.addStep(ManagementHelper.checkNoOtherSibling(childType), OperationContext.Stage.MODEL);
                }
            }
        };
    }

    static OperationStepHandler checkNoOtherSibling(final String childType) {
        return new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress parentAddress = context.getCurrentAddress().getParent();
                Resource parent = context.readResourceFromRoot(parentAddress, false);
                Set children = parent.getChildrenNames(childType);
                if (children.size() > 1) {
                    throw MessagingLogger.ROOT_LOGGER.onlyOneChildIsAllowed(childType, children);
                }
            }
        };
    }
}

