package org.wildfly.extension.elytron._private;

import java.util.Locale;
import java.security.Policy;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.net.UnknownHostException;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.x500.cert.acme.AcmeException;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.RuntimeException;
import javax.xml.stream.XMLStreamException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceController.State;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import java.util.Arrays;
import java.security.NoSuchProviderException;
import java.lang.IllegalArgumentException;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-25T13:36:48+0000")
public class ElytronSubsystemMessages_$logger extends DelegatingBasicLogger implements ElytronSubsystemMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronSubsystemMessages_$logger.class.getName();
    public ElytronSubsystemMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String duplicateRealmInjection = "WFLYELY00002: Can not inject the same realm '%s' in a single security domain.";
    protected String duplicateRealmInjection$str() {
        return duplicateRealmInjection;
    }
    @Override
    public final OperationFailedException duplicateRealmInjection(final String realmName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), duplicateRealmInjection$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationAddressMissingKey = "WFLYELY00003: The operation did not contain an address with a value for '%s'.";
    protected String operationAddressMissingKey$str() {
        return operationAddressMissingKey;
    }
    @Override
    public final IllegalArgumentException operationAddressMissingKey(final String key) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), operationAddressMissingKey$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToStartService = "WFLYELY00004: Unable to start the service.";
    protected String unableToStartService$str() {
        return unableToStartService;
    }
    @Override
    public final StartException unableToStartService(final Exception cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToStartService$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToAccessKeyStore = "WFLYELY00005: Unable to access KeyStore to complete the requested operation.";
    protected String unableToAccessKeyStore$str() {
        return unableToAccessKeyStore;
    }
    @Override
    public final OperationFailedException unableToAccessKeyStore(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToAccessKeyStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredServiceNotUp = "WFLYELY00007: The required service '%s' is not UP, it is currently '%s'.";
    protected String requiredServiceNotUp$str() {
        return requiredServiceNotUp;
    }
    @Override
    public final OperationFailedException requiredServiceNotUp(final ServiceName serviceName, final State state) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), requiredServiceNotUp$str(), serviceName, state));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOperationName = "WFLYELY00008: Invalid operation name '%s', expected one of '%s'";
    protected String invalidOperationName$str() {
        return invalidOperationName;
    }
    @Override
    public final OperationFailedException invalidOperationName(final String actualName, final String... expectedNames) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidOperationName$str(), actualName, Arrays.toString(expectedNames)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCompleteOperation = "WFLYELY00009: Unable to complete operation. '%s'";
    protected String unableToCompleteOperation$str() {
        return unableToCompleteOperation;
    }
    @Override
    public final RuntimeException unableToCompleteOperation(final Throwable cause, final String causeMessage) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unableToCompleteOperation$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cantSaveWithoutFile = "WFLYELY00010: Unable to save KeyStore - KeyStore file '%s' does not exist.";
    protected String cantSaveWithoutFile$str() {
        return cantSaveWithoutFile;
    }
    @Override
    public final OperationFailedException cantSaveWithoutFile(final String file) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cantSaveWithoutFile$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuitableProvider = "WFLYELY00012: No suitable provider found for type '%s'";
    protected String noSuitableProvider$str() {
        return noSuitableProvider;
    }
    @Override
    public final StartException noSuitableProvider(final String type) {
        final StartException result = new StartException(String.format(getLoggingLocale(), noSuitableProvider$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String defaultRealmNotReferenced = "WFLYELY00013: The default-realm '%s' is not in the list of realms [%s] referenced by this domain.";
    protected String defaultRealmNotReferenced$str() {
        return defaultRealmNotReferenced;
    }
    @Override
    public final OperationFailedException defaultRealmNotReferenced(final String defaultRealm, final String realms) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), defaultRealmNotReferenced$str(), defaultRealm, realms));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadPropertiesFiles = "WFLYELY00014: Unable to load the properties files required to start the properties file backed realm: Users file: '%s' Groups file: '%s'";
    protected String unableToLoadPropertiesFiles$str() {
        return unableToLoadPropertiesFiles;
    }
    @Override
    public final StartException unableToLoadPropertiesFiles(final Exception cause, final String usersFile, final String groupsFile) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToLoadPropertiesFiles$str(), usersFile, groupsFile), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentNotConfigurable = "WFLYELY00015: The custom component implementation '%s' doe not implement method initialize(Map<String, String>), however configuration has been supplied.";
    protected String componentNotConfigurable$str() {
        return componentNotConfigurable;
    }
    @Override
    public final StartException componentNotConfigurable(final String className, final Exception cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), componentNotConfigurable$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRegularExpression = "WFLYELY00016: The supplied regular expression '%s' is invalid.";
    protected String invalidRegularExpression$str() {
        return invalidRegularExpression;
    }
    @Override
    public final OperationFailedException invalidRegularExpression(final String pattern, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidRegularExpression$str(), pattern), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertyFilesDoesNotExist = "WFLYELY00017: Property file referenced in properties-realm does not exist: %s";
    protected String propertyFilesDoesNotExist$str() {
        return propertyFilesDoesNotExist;
    }
    @Override
    public final StartException propertyFilesDoesNotExist(final String file) {
        final StartException result = new StartException(String.format(getLoggingLocale(), propertyFilesDoesNotExist$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateManagerFactory = "WFLYELY00018: Unable to create %s for algorithm '%s'.";
    protected String unableToCreateManagerFactory$str() {
        return unableToCreateManagerFactory;
    }
    @Override
    public final StartException unableToCreateManagerFactory(final String type, final String algorithm) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToCreateManagerFactory$str(), type, algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTypeFound = "WFLYELY00019: No '%s' found in injected value.";
    protected String noTypeFound$str() {
        return noTypeFound;
    }
    @Override
    public final StartException noTypeFound(final String type) {
        final StartException result = new StartException(String.format(getLoggingLocale(), noTypeFound$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReLoadPropertiesFiles = "WFLYELY00020: Unable to reload the properties files required to by the properties file backed realm.";
    protected String unableToReLoadPropertiesFiles$str() {
        return unableToReLoadPropertiesFiles;
    }
    @Override
    public final OperationFailedException unableToReLoadPropertiesFiles(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToReLoadPropertiesFiles$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionWhileCreatingPermission = "WFLYELY00021: Exception while creating the permission object for the permission mapping. Please check [class-name], [target-name] (name of permission) and [action] of [%s].";
    protected String exceptionWhileCreatingPermission$str() {
        return exceptionWhileCreatingPermission;
    }
    @Override
    public final StartException exceptionWhileCreatingPermission(final String permissionClassName, final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), exceptionWhileCreatingPermission$str(), permissionClassName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreFileNotExists = "WFLYELY00022: KeyStore file '%s' does not exist and required.";
    protected String keyStoreFileNotExists$str() {
        return keyStoreFileNotExists;
    }
    @Override
    public final StartException keyStoreFileNotExists(final String file) {
        final StartException result = new StartException(String.format(getLoggingLocale(), keyStoreFileNotExists$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void keyStoreFileNotExistsButIgnored(final String file) {
        super.log.logf(FQCN, WARN, null, keyStoreFileNotExistsButIgnored$str(), file);
    }
    private static final String keyStoreFileNotExistsButIgnored = "WFLYELY00023: KeyStore file '%s' does not exist. Used blank.";
    protected String keyStoreFileNotExistsButIgnored$str() {
        return keyStoreFileNotExistsButIgnored;
    }
    @Override
    public final void certificateNotValid(final String alias, final Exception cause) {
        super.log.logf(FQCN, WARN, cause, certificateNotValid$str(), alias);
    }
    private static final String certificateNotValid = "WFLYELY00024: Certificate [%s] in KeyStore is not valid";
    protected String certificateNotValid$str() {
        return certificateNotValid;
    }
    private static final String propertyFileIsInvalid = "WFLYELY00025: Referenced property file is invalid: %s";
    protected String propertyFileIsInvalid$str() {
        return propertyFileIsInvalid;
    }
    @Override
    public final StartException propertyFileIsInvalid(final String message, final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), propertyFileIsInvalid$str(), message), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainOidForX500Attribute = "WFLYELY00027: Unable to obtain OID for X.500 attribute '%s'";
    protected String unableToObtainOidForX500Attribute$str() {
        return unableToObtainOidForX500Attribute;
    }
    @Override
    public final OperationFailedException unableToObtainOidForX500Attribute(final String attribute) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToObtainOidForX500Attribute$str(), attribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String x500AttributeMustBeDefined = "WFLYELY00028: The X.500 attribute must be defined by name or by OID";
    protected String x500AttributeMustBeDefined$str() {
        return x500AttributeMustBeDefined;
    }
    @Override
    public final OperationFailedException x500AttributeMustBeDefined() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), x500AttributeMustBeDefined$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidURL = "WFLYELY00029: Failed to parse URL '%s'";
    protected String invalidURL$str() {
        return invalidURL;
    }
    @Override
    public final OperationFailedException invalidURL(final String url, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidURL$str(), url), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmDoesNotSupportCache = "WFLYELY00030: Realm '%s' does not support cache";
    protected String realmDoesNotSupportCache$str() {
        return realmDoesNotSupportCache;
    }
    @Override
    public final StartException realmDoesNotSupportCache(final String realmName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), realmDoesNotSupportCache$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToAccessCRL = "WFLYELY00031: Unable to access CRL file.";
    protected String unableToAccessCRL$str() {
        return unableToAccessCRL;
    }
    @Override
    public final StartException unableToAccessCRL(final Exception cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToAccessCRL$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReloadCRL = "WFLYELY00032: Unable to reload CRL file.";
    protected String unableToReloadCRL$str() {
        return unableToReloadCRL;
    }
    @Override
    public final RuntimeException unableToReloadCRL(final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unableToReloadCRL$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToAccessEntryFromKeyStore = "WFLYELY00033: Unable to access entry [%s] from key store [%s].";
    protected String unableToAccessEntryFromKeyStore$str() {
        return unableToAccessEntryFromKeyStore;
    }
    @Override
    public final RuntimeException unableToAccessEntryFromKeyStore(final String alias, final String keyStore) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unableToAccessEntryFromKeyStore$str(), alias, keyStore));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jdbcRealmOnlySingleKeyMapperAllowed = "WFLYELY00034: A principal query can only have a single key mapper";
    protected String jdbcRealmOnlySingleKeyMapperAllowed$str() {
        return jdbcRealmOnlySingleKeyMapperAllowed;
    }
    @Override
    public final OperationFailedException jdbcRealmOnlySingleKeyMapperAllowed() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), jdbcRealmOnlySingleKeyMapperAllowed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadModule = "WFLYELY00035: Unable to load module '%s'.";
    protected String unableToLoadModule$str() {
        return unableToLoadModule;
    }
    @Override
    public final OperationFailedException unableToLoadModule(final String module, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToLoadModule$str(), module), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmRefererencedTwice = "WFLYELY00036: Security realm '%s' has been referenced twice in the same security domain.";
    protected String realmRefererencedTwice$str() {
        return realmRefererencedTwice;
    }
    @Override
    public final OperationFailedException realmRefererencedTwice(final String realmName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), realmRefererencedTwice$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTypeInjected = "WFLYELY00037: Injected value is not of '%s' type.";
    protected String invalidTypeInjected$str() {
        return invalidTypeInjected;
    }
    @Override
    public final StartException invalidTypeInjected(final String type) {
        final StartException result = new StartException(String.format(getLoggingLocale(), invalidTypeInjected$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPermissionClass = "WFLYELY00038: Could not load permission class \"%s\"";
    protected String invalidPermissionClass$str() {
        return invalidPermissionClass;
    }
    @Override
    public final StartException invalidPermissionClass(final String className) {
        final StartException result = new StartException(String.format(getLoggingLocale(), invalidPermissionClass$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReloadCRLNotReloadable = "WFLYELY00039: Unable to reload CRL file - TrustManager is not reloadable";
    protected String unableToReloadCRLNotReloadable$str() {
        return unableToReloadCRLNotReloadable;
    }
    @Override
    public final OperationFailedException unableToReloadCRLNotReloadable() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToReloadCRLNotReloadable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPermissionModule = "WFLYELY00040: Unable to load the permission module \"%s\" for the permission mapping";
    protected String invalidPermissionModule$str() {
        return invalidPermissionModule;
    }
    @Override
    public final StartException invalidPermissionModule(final String module, final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), invalidPermissionModule$str(), module), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialStoreEntryTypeNotSupported = "WFLYELY00909: Credential store '%s' does not support given credential store entry type '%s'";
    protected String credentialStoreEntryTypeNotSupported$str() {
        return credentialStoreEntryTypeNotSupported;
    }
    @Override
    public final OperationFailedException credentialStoreEntryTypeNotSupported(final String credentialStoreName, final String entryType) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), credentialStoreEntryTypeNotSupported$str(), credentialStoreName, entryType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStorePasswordCannotBeResolved = "WFLYELY00910: Password cannot be resolved for key-store '%s'";
    protected String keyStorePasswordCannotBeResolved$str() {
        return keyStorePasswordCannotBeResolved;
    }
    @Override
    public final IOException keyStorePasswordCannotBeResolved(final String path) {
        final IOException result = new IOException(String.format(getLoggingLocale(), keyStorePasswordCannotBeResolved$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialStoreProtectionParameterCannotBeResolved = "WFLYELY00911: Credential store '%s' protection parameter cannot be resolved";
    protected String credentialStoreProtectionParameterCannotBeResolved$str() {
        return credentialStoreProtectionParameterCannotBeResolved;
    }
    @Override
    public final IOException credentialStoreProtectionParameterCannotBeResolved(final String name) {
        final IOException result = new IOException(String.format(getLoggingLocale(), credentialStoreProtectionParameterCannotBeResolved$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialAlreadyExists = "WFLYELY00913: Credential alias '%s' of credential type '%s' already exists in the store";
    protected String credentialAlreadyExists$str() {
        return credentialAlreadyExists;
    }
    @Override
    public final OperationFailedException credentialAlreadyExists(final String alias, final String credentialType) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), credentialAlreadyExists$str(), alias, credentialType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String providerLoaderCannotSupplyProvider = "WFLYELY00914: Provider loader '%s' cannot supply Credential Store provider of type '%s'";
    protected String providerLoaderCannotSupplyProvider$str() {
        return providerLoaderCannotSupplyProvider;
    }
    @Override
    public final NoSuchProviderException providerLoaderCannotSupplyProvider(final String providerLoader, final String type) {
        final NoSuchProviderException result = new NoSuchProviderException(String.format(getLoggingLocale(), providerLoaderCannotSupplyProvider$str(), providerLoader, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialCannotBeResolved = "WFLYELY00916: Credential cannot be resolved";
    protected String credentialCannotBeResolved$str() {
        return credentialCannotBeResolved;
    }
    @Override
    public final IllegalStateException credentialCannotBeResolved() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), credentialCannotBeResolved$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String dirContextPasswordCannotBeResolved = "WFLYELY00917: Password cannot be resolved for dir-context";
    protected String dirContextPasswordCannotBeResolved$str() {
        return dirContextPasswordCannotBeResolved;
    }
    @Override
    public final StartException dirContextPasswordCannotBeResolved(final Exception cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), dirContextPasswordCannotBeResolved$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialDoesNotExist = "WFLYELY00920: Credential alias '%s' of credential type '%s' does not exist in the store";
    protected String credentialDoesNotExist$str() {
        return credentialDoesNotExist;
    }
    @Override
    public final OperationFailedException credentialDoesNotExist(final String alias, final String credentialType) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), credentialDoesNotExist$str(), alias, credentialType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String filebasedKeystoreLocationMissing = "WFLYELY00921: Location parameter is not specified for filebased keystore type '%s'";
    protected String filebasedKeystoreLocationMissing$str() {
        return filebasedKeystoreLocationMissing;
    }
    @Override
    public final OperationFailedException filebasedKeystoreLocationMissing(final String type) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), filebasedKeystoreLocationMissing$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String reloadDependantServices = "Reload dependent services which might already have cached the secret value";
    protected String reloadDependantServices$str() {
        return reloadDependantServices;
    }
    @Override
    public final String reloadDependantServices() {
        return String.format(getLoggingLocale(), reloadDependantServices$str());
    }
    private static final String updateDependantServices = "Update dependent resources as alias \"%s\" does not exist anymore";
    protected String updateDependantServices$str() {
        return updateDependantServices;
    }
    @Override
    public final String updateDependantServices(final String alias) {
        return String.format(getLoggingLocale(), updateDependantServices$str(), alias);
    }
    private static final String identityAlreadyExists = "WFLYELY01000: Identity with name [%s] already exists.";
    protected String identityAlreadyExists$str() {
        return identityAlreadyExists;
    }
    @Override
    public final OperationFailedException identityAlreadyExists(final String principalName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), identityAlreadyExists$str(), principalName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateIdentity = "WFLYELY01001: Could not create identity with name [%s].";
    protected String couldNotCreateIdentity$str() {
        return couldNotCreateIdentity;
    }
    @Override
    public final RuntimeException couldNotCreateIdentity(final String principalName, final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotCreateIdentity$str(), principalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String identityNotFound = "WFLYELY01002: Identity with name [%s] not found.";
    protected String identityNotFound$str() {
        return identityNotFound;
    }
    @Override
    public final String identityNotFound(final String principalName) {
        return String.format(getLoggingLocale(), identityNotFound$str(), principalName);
    }
    private static final String couldNotDeleteIdentity = "WFLYELY01003: Could not delete identity with name [%s].";
    protected String couldNotDeleteIdentity$str() {
        return couldNotDeleteIdentity;
    }
    @Override
    public final RuntimeException couldNotDeleteIdentity(final String principalName, final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotDeleteIdentity$str(), principalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String identityNotAuthorized = "WFLYELY01004: Identity with name [%s] not authorized.";
    protected String identityNotAuthorized$str() {
        return identityNotAuthorized;
    }
    @Override
    public final String identityNotAuthorized(final String principalName) {
        return String.format(getLoggingLocale(), identityNotAuthorized$str(), principalName);
    }
    private static final String couldNotReadIdentity2 = "WFLYELY01005: Could not read identity [%s] from security domain [%s].";
    protected String couldNotReadIdentity2$str() {
        return couldNotReadIdentity2;
    }
    @Override
    public final RuntimeException couldNotReadIdentity(final String principalName, final ServiceName domainServiceName, final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotReadIdentity2$str(), principalName, domainServiceName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotReadIdentity1 = "WFLYELY01007: Could not read identity with name [%s].";
    protected String couldNotReadIdentity1$str() {
        return couldNotReadIdentity1;
    }
    @Override
    public final RuntimeException couldNotReadIdentity(final String principalName, final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotReadIdentity1$str(), principalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainAuthorizationIdentity = "WFLYELY01008: Failed to obtain the authorization identity.";
    protected String couldNotObtainAuthorizationIdentity$str() {
        return couldNotObtainAuthorizationIdentity;
    }
    @Override
    public final RuntimeException couldNotObtainAuthorizationIdentity(final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotObtainAuthorizationIdentity$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotAddAttribute = "WFLYELY01009: Failed to add attribute.";
    protected String couldNotAddAttribute$str() {
        return couldNotAddAttribute;
    }
    @Override
    public final RuntimeException couldNotAddAttribute(final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotAddAttribute$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotRemoveAttribute = "WFLYELY01010: Failed to remove attribute.";
    protected String couldNotRemoveAttribute$str() {
        return couldNotRemoveAttribute;
    }
    @Override
    public final RuntimeException couldNotRemoveAttribute(final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotRemoveAttribute$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreatePassword = "WFLYELY01011: Could not create password.";
    protected String couldNotCreatePassword$str() {
        return couldNotCreatePassword;
    }
    @Override
    public final RuntimeException couldNotCreatePassword(final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotCreatePassword$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedPasswordType = "WFLYELY01012: Unexpected password type [%s].";
    protected String unexpectedPasswordType$str() {
        return unexpectedPasswordType;
    }
    @Override
    public final OperationFailedException unexpectedPasswordType(final String passwordType) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unexpectedPasswordType$str(), passwordType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patternRequiresCaptureGroup = "WFLYELY01013: Pattern [%s] requires a capture group";
    protected String patternRequiresCaptureGroup$str() {
        return patternRequiresCaptureGroup;
    }
    @Override
    public final OperationFailedException patternRequiresCaptureGroup(final String pattern) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), patternRequiresCaptureGroup$str(), pattern));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDefinition = "WFLYELY01014: Invalid [%s] definition. Only one of '%s' or '%s' can be set in one Object in the list of filters.";
    protected String invalidDefinition$str() {
        return invalidDefinition;
    }
    @Override
    public final OperationFailedException invalidDefinition(final String property, final String filterNameOne, final String filterNameTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidDefinition$str(), property, filterNameOne, filterNameTwo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToPerformOutflow = "WFLYELY01015: Unable to perform automatic outflow for '%s'";
    protected String unableToPerformOutflow$str() {
        return unableToPerformOutflow;
    }
    @Override
    public final IllegalStateException unableToPerformOutflow(final String identityName, final Exception cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToPerformOutflow$str(), identityName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverNotKnown = "WFLYELY01016: Server '%s' not known";
    protected String serverNotKnown$str() {
        return serverNotKnown;
    }
    @Override
    public final OperationFailedException serverNotKnown(final String server, final UnknownHostException e) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), serverNotKnown$str(), server), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCipherSuiteFilter = "WFLYELY01017: Invalid value for cipher-suite-filter. %s";
    protected String invalidCipherSuiteFilter$str() {
        return invalidCipherSuiteFilter;
    }
    @Override
    public final OperationFailedException invalidCipherSuiteFilter(final Throwable cause, final String causeMessage) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidCipherSuiteFilter$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSize = "WFLYELY01018: Invalid size %s";
    protected String invalidSize$str() {
        return invalidSize;
    }
    @Override
    public final OperationFailedException invalidSize(final String size) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidSize$str(), size));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String suffixContainsMillis = "WFLYELY01019: The suffix (%s) can not contain seconds or milliseconds.";
    protected String suffixContainsMillis$str() {
        return suffixContainsMillis;
    }
    @Override
    public final OperationFailedException suffixContainsMillis(final String suffix) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), suffixContainsMillis$str(), suffix));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSuffix = "WFLYELY01020: The suffix (%s) is invalid. A suffix must be a valid date format.";
    protected String invalidSuffix$str() {
        return invalidSuffix;
    }
    @Override
    public final OperationFailedException invalidSuffix(final String suffix) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidSuffix$str(), suffix));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToSetPolicy = "WFLYELY01022: Failed to set policy [%s]";
    protected String failedToSetPolicy$str() {
        return failedToSetPolicy;
    }
    @Override
    public final RuntimeException failedToSetPolicy(final Policy policy, final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToSetPolicy$str(), policy), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindPolicyProvider = "WFLYELY01023: Could not find policy provider with name [%s]";
    protected String cannotFindPolicyProvider$str() {
        return cannotFindPolicyProvider;
    }
    @Override
    public final XMLStreamException cannotFindPolicyProvider(final String policyProvider, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), cannotFindPolicyProvider$str(), policyProvider), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToRegisterPolicyHandlers = "WFLYELY01024: Failed to register policy context handlers";
    protected String failedToRegisterPolicyHandlers$str() {
        return failedToRegisterPolicyHandlers;
    }
    @Override
    public final RuntimeException failedToRegisterPolicyHandlers(final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToRegisterPolicyHandlers$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreatePolicy = "WFLYELY01025: Failed to create policy [%s]";
    protected String failedToCreatePolicy$str() {
        return failedToCreatePolicy;
    }
    @Override
    public final RuntimeException failedToCreatePolicy(final String className, final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToCreatePolicy$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void discardingUnusedPolicy(final String element, final String attr, final String name) {
        super.log.logf(FQCN, WARN, null, discardingUnusedPolicy$str(), element, attr, name);
    }
    private static final String discardingUnusedPolicy = "WFLYELY01026: Element '%s' with attribute '%s' set to '%s' is unused. Since unused policy configurations can no longer be stored in the configuration model this item is being discarded.";
    protected String discardingUnusedPolicy$str() {
        return discardingUnusedPolicy;
    }
    private static final String keyPasswordCannotBeResolved = "WFLYELY01027: Key password cannot be resolved for key-store '%s'";
    protected String keyPasswordCannotBeResolved$str() {
        return keyPasswordCannotBeResolved;
    }
    @Override
    public final IOException keyPasswordCannotBeResolved(final String path) {
        final IOException result = new IOException(String.format(getLoggingLocale(), keyPasswordCannotBeResolved$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNotBefore = "WFLYELY01028: Invalid value for not-before. %s";
    protected String invalidNotBefore$str() {
        return invalidNotBefore;
    }
    @Override
    public final OperationFailedException invalidNotBefore(final Throwable cause, final String causeMessage) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidNotBefore$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreAliasDoesNotExist = "WFLYELY01029: Alias '%s' does not exist in KeyStore";
    protected String keyStoreAliasDoesNotExist$str() {
        return keyStoreAliasDoesNotExist;
    }
    @Override
    public final OperationFailedException keyStoreAliasDoesNotExist(final String alias) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), keyStoreAliasDoesNotExist$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreAliasDoesNotIdentifyPrivateKeyEntry = "WFLYELY01030: Alias '%s' does not identify a PrivateKeyEntry in KeyStore";
    protected String keyStoreAliasDoesNotIdentifyPrivateKeyEntry$str() {
        return keyStoreAliasDoesNotIdentifyPrivateKeyEntry;
    }
    @Override
    public final OperationFailedException keyStoreAliasDoesNotIdentifyPrivateKeyEntry(final String alias) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), keyStoreAliasDoesNotIdentifyPrivateKeyEntry$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainPrivateKey = "WFLYELY01031: Unable to obtain PrivateKey for alias '%s'";
    protected String unableToObtainPrivateKey$str() {
        return unableToObtainPrivateKey;
    }
    @Override
    public final OperationFailedException unableToObtainPrivateKey(final String alias) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToObtainPrivateKey$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainCertificate = "WFLYELY01032: Unable to obtain Certificate for alias '%s'";
    protected String unableToObtainCertificate$str() {
        return unableToObtainCertificate;
    }
    @Override
    public final OperationFailedException unableToObtainCertificate(final String alias) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToObtainCertificate$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noCertificatesFoundInCertificateReply = "WFLYELY01033: No certificates found in certificate reply";
    protected String noCertificatesFoundInCertificateReply$str() {
        return noCertificatesFoundInCertificateReply;
    }
    @Override
    public final OperationFailedException noCertificatesFoundInCertificateReply() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noCertificatesFoundInCertificateReply$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String publicKeyFromCertificateReplyDoesNotMatchKeyStore = "WFLYELY01034: Public key from certificate reply does not match public key from certificate in KeyStore";
    protected String publicKeyFromCertificateReplyDoesNotMatchKeyStore$str() {
        return publicKeyFromCertificateReplyDoesNotMatchKeyStore;
    }
    @Override
    public final OperationFailedException publicKeyFromCertificateReplyDoesNotMatchKeyStore() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), publicKeyFromCertificateReplyDoesNotMatchKeyStore$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateReplySameAsCertificateFromKeyStore = "WFLYELY01035: Certificate reply is the same as the certificate from PrivateKeyEntry in KeyStore";
    protected String certificateReplySameAsCertificateFromKeyStore$str() {
        return certificateReplySameAsCertificateFromKeyStore;
    }
    @Override
    public final OperationFailedException certificateReplySameAsCertificateFromKeyStore() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), certificateReplySameAsCertificateFromKeyStore$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreAliasAlreadyExists = "WFLYELY01036: Alias '%s' already exists in KeyStore";
    protected String keyStoreAliasAlreadyExists$str() {
        return keyStoreAliasAlreadyExists;
    }
    @Override
    public final OperationFailedException keyStoreAliasAlreadyExists(final String alias) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), keyStoreAliasAlreadyExists$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String topMostCertificateFromCertificateReplyNotTrusted = "WFLYELY01037: Top-most certificate from certificate reply is not trusted. Inspect the certificate carefully and if it is valid, execute import-certificate again with validate set to false.";
    protected String topMostCertificateFromCertificateReplyNotTrusted$str() {
        return topMostCertificateFromCertificateReplyNotTrusted;
    }
    @Override
    public final OperationFailedException topMostCertificateFromCertificateReplyNotTrusted() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), topMostCertificateFromCertificateReplyNotTrusted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String trustedCertificateAlreadyInKeyStore = "WFLYELY01038: Trusted certificate is already in KeyStore under alias '%s'";
    protected String trustedCertificateAlreadyInKeyStore$str() {
        return trustedCertificateAlreadyInKeyStore;
    }
    @Override
    public final OperationFailedException trustedCertificateAlreadyInKeyStore(final String alias) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), trustedCertificateAlreadyInKeyStore$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String trustedCertificateAlreadyInCacertsKeyStore = "WFLYELY01039: Trusted certificate is already in cacerts KeyStore under alias '%s'";
    protected String trustedCertificateAlreadyInCacertsKeyStore$str() {
        return trustedCertificateAlreadyInCacertsKeyStore;
    }
    @Override
    public final OperationFailedException trustedCertificateAlreadyInCacertsKeyStore(final String alias) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), trustedCertificateAlreadyInCacertsKeyStore$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDetermineIfCertificateIsTrusted = "WFLYELY01040: Unable to determine if the certificate is trusted. Inspect the certificate carefully and if it is valid, execute import-certificate again with validate set to false.";
    protected String unableToDetermineIfCertificateIsTrusted$str() {
        return unableToDetermineIfCertificateIsTrusted;
    }
    @Override
    public final OperationFailedException unableToDetermineIfCertificateIsTrusted() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToDetermineIfCertificateIsTrusted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateFileDoesNotExist = "WFLYELY01041: Certificate file does not exist";
    protected String certificateFileDoesNotExist$str() {
        return certificateFileDoesNotExist;
    }
    @Override
    public final OperationFailedException certificateFileDoesNotExist(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), certificateFileDoesNotExist$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainEntry = "WFLYELY01042: Unable to obtain Entry for alias '%s'";
    protected String unableToObtainEntry$str() {
        return unableToObtainEntry;
    }
    @Override
    public final OperationFailedException unableToObtainEntry(final String alias) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToObtainEntry$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateAccountWithCertificateAuthority = "WFLYELY01043: Unable to create an account with the certificate authority: %s";
    protected String unableToCreateAccountWithCertificateAuthority$str() {
        return unableToCreateAccountWithCertificateAuthority;
    }
    @Override
    public final OperationFailedException unableToCreateAccountWithCertificateAuthority(final Exception cause, final String causeMessage) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToCreateAccountWithCertificateAuthority$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToChangeAccountKeyWithCertificateAuthority = "WFLYELY01044: Unable to change the account key associated with the certificate authority: %s";
    protected String unableToChangeAccountKeyWithCertificateAuthority$str() {
        return unableToChangeAccountKeyWithCertificateAuthority;
    }
    @Override
    public final OperationFailedException unableToChangeAccountKeyWithCertificateAuthority(final Exception cause, final String causeMessage) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToChangeAccountKeyWithCertificateAuthority$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDeactivateAccountWithCertificateAuthority = "WFLYELY01045: Unable to deactivate the account associated with the certificate authority: %s";
    protected String unableToDeactivateAccountWithCertificateAuthority$str() {
        return unableToDeactivateAccountWithCertificateAuthority;
    }
    @Override
    public final OperationFailedException unableToDeactivateAccountWithCertificateAuthority(final Exception cause, final String causeMessage) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToDeactivateAccountWithCertificateAuthority$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainCertificateAuthorityAccountCertificate = "WFLYELY01046: Unable to obtain certificate authority account Certificate for alias '%s'";
    protected String unableToObtainCertificateAuthorityAccountCertificate$str() {
        return unableToObtainCertificateAuthorityAccountCertificate;
    }
    @Override
    public final StartException unableToObtainCertificateAuthorityAccountCertificate(final String alias) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToObtainCertificateAuthorityAccountCertificate$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainCertificateAuthorityAccountPrivateKey = "WFLYELY01047: Unable to obtain certificate authority account PrivateKey for alias '%s'";
    protected String unableToObtainCertificateAuthorityAccountPrivateKey$str() {
        return unableToObtainCertificateAuthorityAccountPrivateKey;
    }
    @Override
    public final StartException unableToObtainCertificateAuthorityAccountPrivateKey(final String alias) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToObtainCertificateAuthorityAccountPrivateKey$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToUpdateCertificateAuthorityAccountKeyStore = "WFLYELY01048: Unable to update certificate authority account key store: %s";
    protected String unableToUpdateCertificateAuthorityAccountKeyStore$str() {
        return unableToUpdateCertificateAuthorityAccountKeyStore;
    }
    @Override
    public final OperationFailedException unableToUpdateCertificateAuthorityAccountKeyStore(final Exception cause, final String causeMessage) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToUpdateCertificateAuthorityAccountKeyStore$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToRespondToCertificateAuthorityChallenge = "WFLYELY01049: Unable to respond to challenge from certificate authority: %s";
    protected String unableToRespondToCertificateAuthorityChallenge$str() {
        return unableToRespondToCertificateAuthorityChallenge;
    }
    @Override
    public final AcmeException unableToRespondToCertificateAuthorityChallenge(final Exception cause, final String causeMessage) {
        final AcmeException result = new AcmeException(String.format(getLoggingLocale(), unableToRespondToCertificateAuthorityChallenge$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCertificateAuthorityChallenge = "WFLYELY01050: Invalid certificate authority challenge";
    protected String invalidCertificateAuthorityChallenge$str() {
        return invalidCertificateAuthorityChallenge;
    }
    @Override
    public final AcmeException invalidCertificateAuthorityChallenge() {
        final AcmeException result = new AcmeException(String.format(getLoggingLocale(), invalidCertificateAuthorityChallenge$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCertificateRevocationReason = "WFLYELY01051: Invalid certificate revocation reason '%s'";
    protected String invalidCertificateRevocationReason$str() {
        return invalidCertificateRevocationReason;
    }
    @Override
    public final OperationFailedException invalidCertificateRevocationReason(final String reason) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidCertificateRevocationReason$str(), reason));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInstatiateAcmeClientSpiImplementation = "WFLYELY01052: Unable to instantiate AcmeClientSpi implementation";
    protected String unableToInstatiateAcmeClientSpiImplementation$str() {
        return unableToInstatiateAcmeClientSpiImplementation;
    }
    @Override
    public final IllegalStateException unableToInstatiateAcmeClientSpiImplementation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToInstatiateAcmeClientSpiImplementation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToUpdateAccountWithCertificateAuthority = "WFLYELY01053: Unable to update the account with the certificate authority: %s";
    protected String unableToUpdateAccountWithCertificateAuthority$str() {
        return unableToUpdateAccountWithCertificateAuthority;
    }
    @Override
    public final OperationFailedException unableToUpdateAccountWithCertificateAuthority(final Exception cause, final String causeMessage) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToUpdateAccountWithCertificateAuthority$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToGetCertificateAuthorityMetadata = "WFLYELY01054: Unable to get the metadata associated with the certificate authority: %s";
    protected String unableToGetCertificateAuthorityMetadata$str() {
        return unableToGetCertificateAuthorityMetadata;
    }
    @Override
    public final OperationFailedException unableToGetCertificateAuthorityMetadata(final Exception cause, final String causeMessage) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToGetCertificateAuthorityMetadata$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySize = "WFLYELY01055: Invalid key size: %d";
    protected String invalidKeySize$str() {
        return invalidKeySize;
    }
    @Override
    public final OperationFailedException invalidKeySize(final int keySize) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidKeySize$str(), keySize));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateAuthorityAccountAlreadyExists = "WFLYELY01056: A certificate authority account with this account key already exists. To update the contact information associated with this existing account, use %s. To change the key associated with this existing account, use %s.";
    protected String certificateAuthorityAccountAlreadyExists$str() {
        return certificateAuthorityAccountAlreadyExists;
    }
    @Override
    public final OperationFailedException certificateAuthorityAccountAlreadyExists(final String updateAccount, final String changeAccountKey) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), certificateAuthorityAccountAlreadyExists$str(), updateAccount, changeAccountKey));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
