package org.jboss.as.logging.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logmanager.Configurator;
import java.io.Closeable;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logmanager.LogContext;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.as.controller.registry.Resource.NoSuchResourceException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import java.util.concurrent.atomic.AtomicBoolean;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.PathAddress;
import java.lang.Throwable;
import java.util.Arrays;
import java.io.File;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-25T13:22:01+0000")
public class LoggingLogger_$logger extends DelegatingBasicLogger implements LoggingLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LoggingLogger_$logger.class.getName();
    public LoggingLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void failedToCloseResource(final Throwable cause, final Closeable closeable) {
        super.log.logf(FQCN, ERROR, cause, failedToCloseResource$str(), closeable);
    }
    private static final String failedToCloseResource = "WFLYLOG0006: Failed to close resource %s";
    protected String failedToCloseResource$str() {
        return failedToCloseResource;
    }
    @Override
    public final void invalidPropertyAttribute(final String name) {
        super.log.logf(FQCN, WARN, null, invalidPropertyAttribute$str(), name);
    }
    private static final String invalidPropertyAttribute = "WFLYLOG0007: The attribute %s could not be set as it is not a configurable property value.";
    protected String invalidPropertyAttribute$str() {
        return invalidPropertyAttribute;
    }
    private static final String pathManagerServiceNotStarted = "WFLYLOG0008: The path manager service does not appear to be started. Any changes may be lost as a result of this.";
    protected String pathManagerServiceNotStarted$str() {
        return pathManagerServiceNotStarted;
    }
    @Override
    public final String pathManagerServiceNotStarted() {
        return String.format(getLoggingLocale(), pathManagerServiceNotStarted$str());
    }
    @Override
    public final void loggingProfileNotFound(final String loggingProfile, final ResourceRoot deployment) {
        super.log.logf(FQCN, WARN, null, loggingProfileNotFound$str(), loggingProfile, deployment);
    }
    private static final String loggingProfileNotFound = "WFLYLOG0010: Logging profile '%s' was specified for deployment '%s' but was not found. Using system logging configuration.";
    protected String loggingProfileNotFound$str() {
        return loggingProfileNotFound;
    }
    @Override
    public final void julConfigurationFileFound(final String fileName) {
        super.log.logf(FQCN, WARN, null, julConfigurationFileFound$str(), fileName);
    }
    private static final String julConfigurationFileFound = "WFLYLOG0011: The configuration file in '%s' appears to be a J.U.L. configuration file. The log manager does not allow this type of configuration file.";
    protected String julConfigurationFileFound$str() {
        return julConfigurationFileFound;
    }
    @Override
    public final void replacingNamedHandler(final String name) {
        super.log.logf(FQCN, WARN, null, replacingNamedHandler$str(), name);
    }
    private static final String replacingNamedHandler = "WFLYLOG0012: Replacing handler '%s' during add operation. Either the handler type or the module name differs from the initial configuration.";
    protected String replacingNamedHandler$str() {
        return replacingNamedHandler;
    }
    @Override
    public final void replacingConfigurator(final Configurator c) {
        if (super.log.isEnabled(WARN)) {
            final Class<?> cClass;
            if (c == null) {
                cClass = null;
            }
            else cClass = c.getClass();

            super.log.logf(FQCN, WARN, null, replacingConfigurator$str(), cClass);
        }

    }
    private static final String replacingConfigurator = "WFLYLOG0013: A configurator class, '%s', is not a known configurator and will be replaced.";
    protected String replacingConfigurator$str() {
        return replacingConfigurator;
    }
    @Override
    public final void logContextNotRemoved(final LogContext logContext, final String deploymentName) {
        super.log.logf(FQCN, ERROR, null, logContextNotRemoved$str(), logContext, deploymentName);
    }
    private static final String logContextNotRemoved = "WFLYLOG0014: The log context (%s) could not be removed for deployment %s";
    protected String logContextNotRemoved$str() {
        return logContextNotRemoved;
    }
    @Override
    public final void perDeploymentPropertyDeprecated(final String propertyName, final String attributeName) {
        super.log.logf(FQCN, WARN, null, perDeploymentPropertyDeprecated$str(), propertyName, attributeName);
    }
    private static final String perDeploymentPropertyDeprecated = "WFLYLOG0015: The per-logging deployment property (%s) has been deprecated. Please use the %s attribute to enable/disable per-deployment logging.";
    protected String perDeploymentPropertyDeprecated$str() {
        return perDeploymentPropertyDeprecated;
    }
    @Override
    public final void perLoggingDeploymentIgnored(final String propertyName, final String attributeName, final String deploymentName) {
        super.log.logf(FQCN, WARN, null, perLoggingDeploymentIgnored$str(), propertyName, attributeName, deploymentName);
    }
    private static final String perLoggingDeploymentIgnored = "WFLYLOG0016: The per-logging deployment property (%s) is being ignored because the attribute %s has been set to ignore configuration files in the deployment %s.";
    protected String perLoggingDeploymentIgnored$str() {
        return perLoggingDeploymentIgnored;
    }
    private static final String cannotLoadModule = "WFLYLOG0019: Failed to load module '%s' for %s '%s'";
    protected String cannotLoadModule$str() {
        return cannotLoadModule;
    }
    @Override
    public final IllegalArgumentException cannotLoadModule(final Throwable cause, final String moduleName, final String description, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotLoadModule$str(), moduleName, description, name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classNotFound = "WFLYLOG0021: Class '%s' could not be found.";
    protected String classNotFound$str() {
        return classNotFound;
    }
    @Override
    public final String classNotFound(final Throwable cause, final String className) {
        return String.format(getLoggingLocale(), classNotFound$str(), className);
    }
    private static final String handlerAlreadyDefined = "WFLYLOG0023: Handler %s is already assigned.";
    protected String handlerAlreadyDefined$str() {
        return handlerAlreadyDefined;
    }
    @Override
    public final String handlerAlreadyDefined(final String name) {
        return String.format(getLoggingLocale(), handlerAlreadyDefined$str(), name);
    }
    private static final String invalidFilter = "WFLYLOG0025: Filter %s is invalid";
    protected String invalidFilter$str() {
        return invalidFilter;
    }
    @Override
    public final String invalidFilter(final String name) {
        return String.format(getLoggingLocale(), invalidFilter$str(), name);
    }
    private static final String invalidLogLevel = "WFLYLOG0026: Log level %s is invalid.";
    protected String invalidLogLevel$str() {
        return invalidLogLevel;
    }
    @Override
    public final String invalidLogLevel(final String level) {
        return String.format(getLoggingLocale(), invalidLogLevel$str(), level);
    }
    private static final String invalidOverflowAction = "WFLYLOG0027: Overflow action %s is invalid.";
    protected String invalidOverflowAction$str() {
        return invalidOverflowAction;
    }
    @Override
    public final String invalidOverflowAction(final String overflowAction) {
        return String.format(getLoggingLocale(), invalidOverflowAction$str(), overflowAction);
    }
    private static final String invalidSize = "WFLYLOG0028: Invalid size %s";
    protected String invalidSize$str() {
        return invalidSize;
    }
    @Override
    public final String invalidSize(final String size) {
        return String.format(getLoggingLocale(), invalidSize$str(), size);
    }
    private static final String loggerNotFound = "WFLYLOG0035: Logger '%s' was not found.";
    protected String loggerNotFound$str() {
        return loggerNotFound;
    }
    @Override
    public final String loggerNotFound(final String name) {
        return String.format(getLoggingLocale(), loggerNotFound$str(), name);
    }
    private static final String invalidRelativeTo = "WFLYLOG0039: An absolute path (%s) cannot be specified for relative-to.";
    protected String invalidRelativeTo$str() {
        return invalidRelativeTo;
    }
    @Override
    public final String invalidRelativeTo(final String relativeTo) {
        return String.format(getLoggingLocale(), invalidRelativeTo$str(), relativeTo);
    }
    private static final String invalidSuffix = "WFLYLOG0041: The suffix (%s) is invalid. A suffix must be a valid date format.";
    protected String invalidSuffix$str() {
        return invalidSuffix;
    }
    @Override
    public final String invalidSuffix(final String suffix) {
        return String.format(getLoggingLocale(), invalidSuffix$str(), suffix);
    }
    private static final String failedToConfigureLogging = "WFLYLOG0042: Failed to configure logging using '%s' configuration file.";
    protected String failedToConfigureLogging$str() {
        return failedToConfigureLogging;
    }
    @Override
    public final DeploymentUnitProcessingException failedToConfigureLogging(final Throwable cause, final String fileName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToConfigureLogging$str(), fileName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorProcessingLoggingConfiguration = "WFLYLOG0043: Error occurred while searching for logging configuration files.";
    protected String errorProcessingLoggingConfiguration$str() {
        return errorProcessingLoggingConfiguration;
    }
    @Override
    public final DeploymentUnitProcessingException errorProcessingLoggingConfiguration(final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), errorProcessingLoggingConfiguration$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerAttachedToHandlers = "WFLYLOG0044: Handler %s is attached to the following handlers and cannot be removed; %s";
    protected String handlerAttachedToHandlers$str() {
        return handlerAttachedToHandlers;
    }
    @Override
    public final OperationFailedException handlerAttachedToHandlers(final String handlerName, final java.util.Collection<String> handlers) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), handlerAttachedToHandlers$str(), handlerName, handlers));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerAttachedToLoggers = "WFLYLOG0045: Handler %s is attached to the following loggers and cannot be removed; %s";
    protected String handlerAttachedToLoggers$str() {
        return handlerAttachedToLoggers;
    }
    @Override
    public final OperationFailedException handlerAttachedToLoggers(final String handlerName, final java.util.Collection<String> loggers) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), handlerAttachedToLoggers$str(), handlerName, loggers));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddHandlerToSelf = "WFLYLOG0046: Cannot add handler (%s) to itself";
    protected String cannotAddHandlerToSelf$str() {
        return cannotAddHandlerToSelf;
    }
    @Override
    public final String cannotAddHandlerToSelf(final String handlerName) {
        return String.format(getLoggingLocale(), cannotAddHandlerToSelf$str(), handlerName);
    }
    private static final String handlerClosed = "WFLYLOG0047: The handler is closed, cannot publish to a closed handler";
    protected String handlerClosed$str() {
        return handlerClosed;
    }
    @Override
    public final IllegalStateException handlerClosed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), handlerClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerConfigurationNotFound = "WFLYLOG0048: Configuration for handler '%s' could not be found.";
    protected String handlerConfigurationNotFound$str() {
        return handlerConfigurationNotFound;
    }
    @Override
    public final String handlerConfigurationNotFound(final String name) {
        return String.format(getLoggingLocale(), handlerConfigurationNotFound$str(), name);
    }
    private static final String loggerConfigurationNotFound = "WFLYLOG0049: Configuration for logger '%s' could not be found.";
    protected String loggerConfigurationNotFound$str() {
        return loggerConfigurationNotFound;
    }
    @Override
    public final String loggerConfigurationNotFound(final String name) {
        return String.format(getLoggingLocale(), loggerConfigurationNotFound$str(), name);
    }
    private static final String unsupportedMethod = "WFLYLOG0050: Method %s on class %s is not supported";
    protected String unsupportedMethod$str() {
        return unsupportedMethod;
    }
    @Override
    public final UnsupportedOperationException unsupportedMethod(final String methodName, final String className) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedMethod$str(), methodName, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToWriteConfigurationFile = "WFLYLOG0051: Failed to write configuration file %s";
    protected String failedToWriteConfigurationFile$str() {
        return failedToWriteConfigurationFile;
    }
    @Override
    public final RuntimeException failedToWriteConfigurationFile(final Throwable e, final File fileName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToWriteConfigurationFile$str(), fileName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String formatterNotFound = "WFLYLOG0061: Formatter '%s' is not found";
    protected String formatterNotFound$str() {
        return formatterNotFound;
    }
    @Override
    public final String formatterNotFound(final String name) {
        return String.format(getLoggingLocale(), formatterNotFound$str(), name);
    }
    private static final String truncatedFilterExpression = "WFLYLOG0070: Truncated filter expression string";
    protected String truncatedFilterExpression$str() {
        return truncatedFilterExpression;
    }
    @Override
    public final IllegalArgumentException truncatedFilterExpression() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), truncatedFilterExpression$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEscapeFoundInFilterExpression = "WFLYLOG0071: Invalid escape found in filter expression string";
    protected String invalidEscapeFoundInFilterExpression$str() {
        return invalidEscapeFoundInFilterExpression;
    }
    @Override
    public final IllegalArgumentException invalidEscapeFoundInFilterExpression() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidEscapeFoundInFilterExpression$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String filterNotFound = "WFLYLOG0072: Filter '%s' is not found";
    protected String filterNotFound$str() {
        return filterNotFound;
    }
    @Override
    public final IllegalArgumentException filterNotFound(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), filterNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedIdentifier = "WFLYLOG0073: Expected identifier next in filter expression";
    protected String expectedIdentifier$str() {
        return expectedIdentifier;
    }
    @Override
    public final IllegalArgumentException expectedIdentifier() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expectedIdentifier$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedString = "WFLYLOG0074: Expected string next in filter expression";
    protected String expectedString$str() {
        return expectedString;
    }
    @Override
    public final IllegalArgumentException expectedString() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expectedString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expected1 = "WFLYLOG0075: Expected '%s' next in filter expression";
    protected String expected1$str() {
        return expected1;
    }
    @Override
    public final IllegalArgumentException expected(final String token) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expected1$str(), token));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expected2 = "WFLYLOG0075: Expected '%s' or '%s' next in filter expression";
    protected String expected2$str() {
        return expected2;
    }
    @Override
    public final IllegalArgumentException expected(final String trueToken, final String falseToken) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expected2$str(), trueToken, falseToken));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedEnd = "WFLYLOG0076: Unexpected end of filter expression";
    protected String unexpectedEnd$str() {
        return unexpectedEnd;
    }
    @Override
    public final IllegalArgumentException unexpectedEnd() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unexpectedEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extensionNotInitialized = "WFLYLOG0078: The logging subsystem requires the log manager to be org.jboss.logmanager.LogManager. The subsystem has not be initialized and cannot be used. To use JBoss Log Manager you must add the system property \"java.util.logging.manager\" and set it to \"org.jboss.logmanager.LogManager\"";
    protected String extensionNotInitialized$str() {
        return extensionNotInitialized;
    }
    @Override
    public final IllegalStateException extensionNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), extensionNotInitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReadLogFile = "WFLYLOG0079: Failed to read the log file '%s'";
    protected String failedToReadLogFile$str() {
        return failedToReadLogFile;
    }
    @Override
    public final RuntimeException failedToReadLogFile(final Throwable cause, final String name) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToReadLogFile$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String logFileNotFound = "WFLYLOG0080: File '%s' was not found and cannot be found in the %s directory.";
    protected String logFileNotFound$str() {
        return logFileNotFound;
    }
    @Override
    public final NoSuchResourceException logFileNotFound(final String name, final String directoryProperty) {
        final NoSuchResourceException result = new NoSuchResourceException(String.format(getLoggingLocale(), logFileNotFound$str(), name, directoryProperty));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readNotAllowed = "WFLYLOG0081: File '%s' is not allowed to be read.";
    protected String readNotAllowed$str() {
        return readNotAllowed;
    }
    @Override
    public final OperationFailedException readNotAllowed(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), readNotAllowed$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String suffixContainsMillis = "WFLYLOG0082: The suffix (%s) can not contain seconds or milliseconds.";
    protected String suffixContainsMillis$str() {
        return suffixContainsMillis;
    }
    @Override
    public final String suffixContainsMillis(final String suffix) {
        return String.format(getLoggingLocale(), suffixContainsMillis$str(), suffix);
    }
    private static final String invalidLogFile = "WFLYLOG0083: Path '%s' is a directory and cannot be used as a log file.";
    protected String invalidLogFile$str() {
        return invalidLogFile;
    }
    @Override
    public final OperationFailedException invalidLogFile(final String path) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidLogFile$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRegisterResourceOfType = "WFLYLOG0084: Resources of type %s cannot be registered";
    protected String cannotRegisterResourceOfType$str() {
        return cannotRegisterResourceOfType;
    }
    @Override
    public final UnsupportedOperationException cannotRegisterResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), cannotRegisterResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveResourceOfType = "WFLYLOG0085: Resources of type %s cannot be removed";
    protected String cannotRemoveResourceOfType$str() {
        return cannotRemoveResourceOfType;
    }
    @Override
    public final UnsupportedOperationException cannotRemoveResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), cannotRemoveResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentNameNotFound = "WFLYLOG0086: Could not determine deployment name from the address %s.";
    protected String deploymentNameNotFound$str() {
        return deploymentNameNotFound;
    }
    @Override
    public final IllegalArgumentException deploymentNameNotFound(final PathAddress address) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), deploymentNameNotFound$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorProcessingLogDirectory(final String logDir) {
        super.log.logf(FQCN, ERROR, null, errorProcessingLogDirectory$str(), logDir);
    }
    private static final String errorProcessingLogDirectory = "WFLYLOG0087: Failed to process logging directory %s. Log files cannot be listed.";
    protected String errorProcessingLogDirectory$str() {
        return errorProcessingLogDirectory;
    }
    @Override
    public final void errorDeterminingChildrenExist(final Throwable cause, final String childType) {
        super.log.logf(FQCN, ERROR, cause, errorDeterminingChildrenExist$str(), childType);
    }
    private static final String errorDeterminingChildrenExist = "WFLYLOG0088: Could not determine %s had any children resources.";
    protected String errorDeterminingChildrenExist$str() {
        return errorDeterminingChildrenExist;
    }
    @Override
    public final void unknownLogManager(final String logManagerName) {
        super.log.logf(FQCN, WARN, null, unknownLogManager$str(), logManagerName);
    }
    private static final String unknownLogManager = "WFLYLOG0089: The log manager check was skipped and the log manager system property, \"java.util.logging.manager\", does not appear to be set to \"org.jboss.logmanager.LogManager\". The current value is \"%s\". Some behavior of the logged output such as MDC and NDC may not work as expected.";
    protected String unknownLogManager$str() {
        return unknownLogManager;
    }
    @Override
    public final void unresolvablePathExpressions(final java.util.Set<String> unresolvableExpressions) {
        if (super.log.isEnabled(WARN) && unresolvablePathExpressions_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, unresolvablePathExpressions$str(), unresolvableExpressions);
        }

    }
    private static final String unresolvablePathExpressions = "WFLYLOG0090: The following path expressions could not be resolved while attempting to determine which log files are available to be read: %s";
    protected String unresolvablePathExpressions$str() {
        return unresolvablePathExpressions;
    }
    private static final AtomicBoolean unresolvablePathExpressions_$Once = new AtomicBoolean(false);
    private static final String invalidExceptionOutputType = "WFLYLOG0091: Exception output type %s is invalid.";
    protected String invalidExceptionOutputType$str() {
        return invalidExceptionOutputType;
    }
    @Override
    public final OperationFailedException invalidExceptionOutputType(final String value) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidExceptionOutputType$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidType = "WFLYLOG0092: Invalid type found. Expected %s but found %s.";
    protected String invalidType$str() {
        return invalidType;
    }
    @Override
    public final OperationFailedException invalidType(final Class<?> expected, final Class<?> found) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidType$str(), expected, found));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToConfigureSslContext = "WFLYLOG0093: Failed to configure SSL context for %s %s.";
    protected String failedToConfigureSslContext$str() {
        return failedToConfigureSslContext;
    }
    @Override
    public final OperationFailedException failedToConfigureSslContext(final Throwable cause, final String resourceName, final String resourceValue) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), failedToConfigureSslContext$str(), resourceName, resourceValue), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
