package org.jboss.migration.core.logger;

import java.util.Locale;
import java.lang.IllegalStateException;
import org.jboss.migration.core.ProductInfo;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-27T13:13:10+0000")
public class ServerMigrationLogger_$logger extends DelegatingBasicLogger implements ServerMigrationLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServerMigrationLogger_$logger.class.getName();
    public ServerMigrationLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String noConsoleAvailable = "WFCMTOOL000001: No java.io.Console available to interact with user.";
    protected String noConsoleAvailable$str() {
        return noConsoleAvailable;
    }
    @Override
    public final IllegalStateException noConsoleAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noConsoleAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String yes = "yes";
    protected String yes$str() {
        return yes;
    }
    @Override
    public final String yes() {
        return String.format(getLoggingLocale(), yes$str());
    }
    private static final String shortYes = "y";
    protected String shortYes$str() {
        return shortYes;
    }
    @Override
    public final String shortYes() {
        return String.format(getLoggingLocale(), shortYes$str());
    }
    private static final String no = "no";
    protected String no$str() {
        return no;
    }
    @Override
    public final String no() {
        return String.format(getLoggingLocale(), no$str());
    }
    private static final String shortNo = "n";
    protected String shortNo$str() {
        return shortNo;
    }
    @Override
    public final String shortNo() {
        return String.format(getLoggingLocale(), shortNo$str());
    }
    private static final String other = "other";
    protected String other$str() {
        return other;
    }
    @Override
    public final String other() {
        return String.format(getLoggingLocale(), other$str());
    }
    private static final String invalidResponse = "WFCMTOOL000002: Invalid response. (Valid responses are %s and %s)";
    protected String invalidResponse$str() {
        return invalidResponse;
    }
    @Override
    public final String invalidResponse(final String firstValues, final String secondValues) {
        return String.format(getLoggingLocale(), invalidResponse$str(), firstValues, secondValues);
    }
    private static final String invalidEmptyResponse = "WFCMTOOL000003: Invalid empty response.";
    protected String invalidEmptyResponse$str() {
        return invalidEmptyResponse;
    }
    @Override
    public final String invalidEmptyResponse() {
        return String.format(getLoggingLocale(), invalidEmptyResponse$str());
    }
    private static final String errorHeader = "Error";
    protected String errorHeader$str() {
        return errorHeader;
    }
    @Override
    public final String errorHeader() {
        return String.format(getLoggingLocale(), errorHeader$str());
    }
    private static final String yesNo = "yes/no?";
    protected String yesNo$str() {
        return yesNo;
    }
    @Override
    public final String yesNo() {
        return String.format(getLoggingLocale(), yesNo$str());
    }
    private static final String otherChoice = "Other choice?";
    protected String otherChoice$str() {
        return otherChoice;
    }
    @Override
    public final String otherChoice() {
        return String.format(getLoggingLocale(), otherChoice$str());
    }
    private static final String doesNotSupportsMigration = "WFCMTOOL000004: Server name = %s, version = %s does not support migration from server name = %s, version = %s.";
    protected String doesNotSupportsMigration$str() {
        return doesNotSupportsMigration;
    }
    @Override
    public final IllegalArgumentException doesNotSupportsMigration(final String targetName, final String targetVersion, final String sourceName, final String sourceVersion) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), doesNotSupportsMigration$str(), targetName, targetVersion, sourceName, sourceVersion));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverBaseDirNotSet = "WFCMTOOL000005: Migration %s server base dir not set.";
    protected String serverBaseDirNotSet$str() {
        return serverBaseDirNotSet;
    }
    @Override
    public final IllegalStateException serverBaseDirNotSet(final String serverName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverBaseDirNotSet$str(), serverName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToRetrieveServerFromBaseDir = "WFCMTOOL000006: Failed to retrieve server %s, from base dir %s.";
    protected String failedToRetrieveServerFromBaseDir$str() {
        return failedToRetrieveServerFromBaseDir;
    }
    @Override
    public final IllegalArgumentException failedToRetrieveServerFromBaseDir(final String serverName, final String baseDir) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), failedToRetrieveServerFromBaseDir$str(), serverName, baseDir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void serverProductInfo(final String name, final ProductInfo productInfo) {
        super.log.logf(FQCN, INFO, null, serverProductInfo$str(), name, productInfo);
    }
    private static final String serverProductInfo = "%s server %s.";
    protected String serverProductInfo$str() {
        return serverProductInfo;
    }
}
