package org.wildfly.extension.mod_cluster;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-05-01T09:06:46+0000")
public class ModClusterLogger_$logger extends DelegatingBasicLogger implements ModClusterLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ModClusterLogger_$logger.class.getName();
    public ModClusterLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void errorAddingMetrics(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorAddingMetrics$str());
    }
    private static final String errorAddingMetrics = "WFLYMODCLS0001: Error adding metrics.";
    protected String errorAddingMetrics$str() {
        return errorAddingMetrics;
    }
    @Override
    public final void multicastInterfaceNotAvailable() {
        super.log.logf(FQCN, ERROR, null, multicastInterfaceNotAvailable$str());
    }
    private static final String multicastInterfaceNotAvailable = "WFLYMODCLS0004: Mod_cluster requires Advertise but Multicast interface is not available";
    protected String multicastInterfaceNotAvailable$str() {
        return multicastInterfaceNotAvailable;
    }
    @Override
    public final void usingSimpleLoadProvider(final String proxyName) {
        super.log.logf(FQCN, WARN, null, usingSimpleLoadProvider$str(), proxyName);
    }
    private static final String usingSimpleLoadProvider = "WFLYMODCLS0005: No mod_cluster load balance factor provider specified for proxy '%s'! Using load balance factor provider with constant factor of '1'.";
    protected String usingSimpleLoadProvider$str() {
        return usingSimpleLoadProvider;
    }
    @Override
    public final void errorApplyingMetricProperties(final Throwable cause, final String metricClass) {
        super.log.logf(FQCN, ERROR, cause, errorApplyingMetricProperties$str(), metricClass);
    }
    private static final String errorApplyingMetricProperties = "WFLYMODCLS0006: Error applying properties to load metric class '%s'. Metric will not be loaded.";
    protected String errorApplyingMetricProperties$str() {
        return errorApplyingMetricProperties;
    }
    @Override
    public final void unsupportedMetric(final String metricType) {
        super.log.logf(FQCN, WARN, null, unsupportedMetric$str(), metricType);
    }
    private static final String unsupportedMetric = "WFLYMODCLS0007: Metric of type '%s' is no longer supported and will be ignored.";
    protected String unsupportedMetric$str() {
        return unsupportedMetric;
    }
    private static final String contextOrHostNotFound = "WFLYMODCLS0011: Virtual host '%s' or context '%s' not found.";
    protected String contextOrHostNotFound$str() {
        return contextOrHostNotFound;
    }
    @Override
    public final String contextOrHostNotFound(final String host, final String context) {
        return String.format(getLoggingLocale(), contextOrHostNotFound$str(), host, context);
    }
    private static final String needHostAndPort = "WFLYMODCLS0014: Need valid host and port in the form host:port, %s is not valid";
    protected String needHostAndPort$str() {
        return needHostAndPort;
    }
    @Override
    public final String needHostAndPort(final String value) {
        return String.format(getLoggingLocale(), needHostAndPort$str(), value);
    }
    private static final String couldNotResolveProxyIpAddress = "WFLYMODCLS0016: No IP address could be resolved for the specified host of the proxy.";
    protected String couldNotResolveProxyIpAddress$str() {
        return couldNotResolveProxyIpAddress;
    }
    @Override
    public final String couldNotResolveProxyIpAddress() {
        return String.format(getLoggingLocale(), couldNotResolveProxyIpAddress$str());
    }
    private static final String excludedContextsWrongFormat = "WFLYMODCLS0019: '%s' is not a valid value for excluded-contexts.";
    protected String excludedContextsWrongFormat$str() {
        return excludedContextsWrongFormat;
    }
    @Override
    public final IllegalArgumentException excludedContextsWrongFormat(final String trimmedContexts) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), excludedContextsWrongFormat$str(), trimmedContexts));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bothElytronAndLegacySslContextDefined = "WFLYMODCLS0020: Only one of 'ssl-context' attribute or 'ssl' resource can be defined!";
    protected String bothElytronAndLegacySslContextDefined$str() {
        return bothElytronAndLegacySslContextDefined;
    }
    @Override
    public final IllegalStateException bothElytronAndLegacySslContextDefined() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), bothElytronAndLegacySslContextDefined$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void excludedContextsUseSlashInsteadROOT() {
        super.log.logf(FQCN, WARN, null, excludedContextsUseSlashInsteadROOT$str());
    }
    private static final String excludedContextsUseSlashInsteadROOT = "WFLYMODCLS0021: Value 'ROOT' for excluded-contexts is deprecated, to exclude the root context use '/' instead.";
    protected String excludedContextsUseSlashInsteadROOT$str() {
        return excludedContextsUseSlashInsteadROOT;
    }
    private static final String legacyOperationsWithMultipleProxies = "WFLYMODCLS0022: Legacy operations cannot be used with multiple proxy configurations. Use non-deprecated operations at the correct proxy address.";
    protected String legacyOperationsWithMultipleProxies$str() {
        return legacyOperationsWithMultipleProxies;
    }
    @Override
    public final String legacyOperationsWithMultipleProxies() {
        return String.format(getLoggingLocale(), legacyOperationsWithMultipleProxies$str());
    }
    @Override
    public final void errorLoadingModuleForCustomMetric(final String moduleName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorLoadingModuleForCustomMetric$str(), moduleName);
    }
    private static final String errorLoadingModuleForCustomMetric = "WFLYMODCLS0023: Error loading module '%s' to load custom metric from.";
    protected String errorLoadingModuleForCustomMetric$str() {
        return errorLoadingModuleForCustomMetric;
    }
}
