package org.jboss.as.clustering.infinispan;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.Throwable;
import java.lang.String;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-05-01T09:05:07+0000")
public class InfinispanLogger_$logger extends DelegatingBasicLogger implements InfinispanLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InfinispanLogger_$logger.class.getName();
    public InfinispanLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str());
    }
    private static final String activatingSubsystem = "WFLYCLINF0001: Activating Infinispan subsystem.";
    protected String activatingSubsystem$str() {
        return activatingSubsystem;
    }
    @Override
    public final void cacheStarted(final String cacheName, final String containerName) {
        super.log.logf(FQCN, INFO, null, cacheStarted$str(), cacheName, containerName);
    }
    private static final String cacheStarted = "WFLYCLINF0002: Started %s cache from %s container";
    protected String cacheStarted$str() {
        return cacheStarted;
    }
    @Override
    public final void cacheStopped(final String cacheName, final String containerName) {
        super.log.logf(FQCN, INFO, null, cacheStopped$str(), cacheName, containerName);
    }
    private static final String cacheStopped = "WFLYCLINF0003: Stopped %s cache from %s container";
    protected String cacheStopped$str() {
        return cacheStopped;
    }
    @Override
    public final void attributeDeprecated(final String attribute, final String element) {
        super.log.logf(FQCN, WARN, null, attributeDeprecated$str(), attribute, element);
    }
    private static final String attributeDeprecated = "WFLYCLINF0004: The '%s' attribute of the '%s' element is no longer supported and will be ignored";
    protected String attributeDeprecated$str() {
        return attributeDeprecated;
    }
    @Override
    public final void topologyAttributeDeprecated(final String attribute) {
        super.log.logf(FQCN, WARN, null, topologyAttributeDeprecated$str(), attribute);
    }
    private static final String topologyAttributeDeprecated = "WFLYCLINF0005: The '%s' attribute specified on the 'transport' element of a cache container is no longer valid; use the same attribute specified on the 'transport' element of corresponding JGroups stack instead";
    protected String topologyAttributeDeprecated$str() {
        return topologyAttributeDeprecated;
    }
    private static final String dataSourceJndiNameNotFound = "WFLYCLINF0006: Failed to locate a data source bound to %s";
    protected String dataSourceJndiNameNotFound$str() {
        return dataSourceJndiNameNotFound;
    }
    @Override
    public final OperationFailedException dataSourceJndiNameNotFound(final String jndiName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), dataSourceJndiNameNotFound$str(), jndiName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String dataSourceNotFound = "WFLYCLINF0007: Failed to locate data source %s";
    protected String dataSourceNotFound$str() {
        return dataSourceNotFound;
    }
    @Override
    public final OperationFailedException dataSourceNotFound(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), dataSourceNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCacheStore = "WFLYCLINF0010: %s is not a valid cache store";
    protected String invalidCacheStore$str() {
        return invalidCacheStore;
    }
    @Override
    public final IllegalArgumentException invalidCacheStore(final Throwable cause, final String cacheStoreName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCacheStore$str(), cacheStoreName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indeterminiteStack = "WFLYCLINF0027: Could not determine 'stack' attribute from JGroups subsystem";
    protected String indeterminiteStack$str() {
        return indeterminiteStack;
    }
    @Override
    public final String indeterminiteStack() {
        return String.format(getLoggingLocale(), indeterminiteStack$str());
    }
    @Override
    public final void executorIgnored(final String executorName) {
        super.log.logf(FQCN, WARN, null, executorIgnored$str(), executorName);
    }
    private static final String executorIgnored = "WFLYCLINF0028: Executor configuration '%s' was deprecated and will only be used to support legacy slaves in the domain.";
    protected String executorIgnored$str() {
        return executorIgnored;
    }
    @Override
    public final void remoteCacheContainerStarted(final String remoteCacheContainer) {
        super.log.logf(FQCN, INFO, null, remoteCacheContainerStarted$str(), remoteCacheContainer);
    }
    private static final String remoteCacheContainerStarted = "WFLYCLINF0029: Started remote cache container '%s'.";
    protected String remoteCacheContainerStarted$str() {
        return remoteCacheContainerStarted;
    }
    @Override
    public final void remoteCacheContainerStopped(final String remoteCacheContainer) {
        super.log.logf(FQCN, INFO, null, remoteCacheContainerStopped$str(), remoteCacheContainer);
    }
    private static final String remoteCacheContainerStopped = "WFLYCLINF0030: Stopped remote cache container '%s'.";
    protected String remoteCacheContainerStopped$str() {
        return remoteCacheContainerStopped;
    }
    private static final String remoteCacheMustBeDefined = "WFLYCLINF0031: Specified HotRod protocol version %s does not support creating caches automatically. Cache named '%s' must be already created on the Infinispan Server!";
    protected String remoteCacheMustBeDefined$str() {
        return remoteCacheMustBeDefined;
    }
    @Override
    public final HotRodClientException remoteCacheMustBeDefined(final String protocolVersion, final String remoteCacheName) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), remoteCacheMustBeDefined$str(), protocolVersion, remoteCacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void remoteCacheCreated(final String remoteCacheName, final String cacheConfiguration) {
        super.log.logf(FQCN, INFO, null, remoteCacheCreated$str(), remoteCacheName, cacheConfiguration);
    }
    private static final String remoteCacheCreated = "WFLYCLINF0032: Getting remote cache named '%s'. If it does not exist a new cache will be created from configuration template named '%s'; null value uses default cache configuration on the Infinispan Server.";
    protected String remoteCacheCreated$str() {
        return remoteCacheCreated;
    }
}
