package org.jboss.as.domain.http.server.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.modules.ModuleNotFoundException;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.net.InetAddress;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-25T13:16:01+0000")
public class HttpServerLogger_$logger extends DelegatingBasicLogger implements HttpServerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HttpServerLogger_$logger.class.getName();
    public HttpServerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void modelRequestError(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, modelRequestError$str());
    }
    private static final String modelRequestError = "WFLYDMHTTP0001: Unexpected error executing model request";
    protected String modelRequestError$str() {
        return modelRequestError;
    }
    @Override
    public final void uploadError(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, uploadError$str());
    }
    private static final String uploadError = "WFLYDMHTTP0002: Unexpected error executing deployment upload request";
    protected String uploadError$str() {
        return uploadError;
    }
    @Override
    public final void consoleModuleNotFound(final String slot) {
        super.log.logf(FQCN, WARN, null, consoleModuleNotFound$str(), slot);
    }
    private static final String consoleModuleNotFound = "WFLYDMHTTP0003: Unable to load console module for slot %s, disabling console";
    protected String consoleModuleNotFound$str() {
        return consoleModuleNotFound;
    }
    @Override
    public final void errorContextModuleNotFound(final String slot) {
        super.log.logf(FQCN, ERROR, null, errorContextModuleNotFound$str(), slot);
    }
    private static final String errorContextModuleNotFound = "WFLYDMHTTP0004: Unable to load error context for slot %s, disabling error context.";
    protected String errorContextModuleNotFound$str() {
        return errorContextModuleNotFound;
    }
    private static final String invalidOperation = "WFLYDMHTTP0005: Invalid operation '%s'";
    protected String invalidOperation$str() {
        return invalidOperation;
    }
    @Override
    public final IllegalArgumentException invalidOperation(final Throwable cause, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidOperation$str(), value), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmNotReadyMessage = "WFLYDMHTTP0006: The security realm is not ready to process requests, see %s";
    protected String realmNotReadyMessage$str() {
        return realmNotReadyMessage;
    }
    @Override
    public final String realmNotReadyMessage(final String url) {
        return String.format(getLoggingLocale(), realmNotReadyMessage$str(), url);
    }
    private static final String consoleModuleNotFoundMsg = "WFLYDMHTTP0007: No console module available with module name %s";
    protected String consoleModuleNotFoundMsg$str() {
        return consoleModuleNotFoundMsg;
    }
    @Override
    public final ModuleNotFoundException consoleModuleNotFoundMsg(final String moduleName) {
        final ModuleNotFoundException result = new ModuleNotFoundException(String.format(getLoggingLocale(), consoleModuleNotFoundMsg$str(), moduleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCredentialType = "WFLYDMHTTP0010: Invalid Credential Type '%s'";
    protected String invalidCredentialType$str() {
        return invalidCredentialType;
    }
    @Override
    public final IllegalArgumentException invalidCredentialType(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCredentialType$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void httpsRedirectNotSupported(final InetAddress bindAddress, final InetAddress secureBindAddress) {
        super.log.logf(FQCN, INFO, null, httpsRedirectNotSupported$str(), bindAddress, secureBindAddress);
    }
    private static final String httpsRedirectNotSupported = "WFLYDMHTTP0011: Management interface is using different addresses for HTTP (%s) and HTTPS (%s). Redirection of HTTPS requests from HTTP socket to HTTPS socket will not be supported.";
    protected String httpsRedirectNotSupported$str() {
        return httpsRedirectNotSupported;
    }
    private static final String sslRequestedNoSslContext = "WFLYDMHTTP0012: A secure socket has been defined for the HTTP interface, however the referenced security realm is not supplying a SSLContext.";
    protected String sslRequestedNoSslContext$str() {
        return sslRequestedNoSslContext;
    }
    @Override
    public final IllegalArgumentException sslRequestedNoSslContext() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), sslRequestedNoSslContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidUseStreamAsResponseIndex = "WFLYDMHTTP0013: Invalid useStreamIndex value '%d'. The operation response had %d streams attached.";
    protected String invalidUseStreamAsResponseIndex$str() {
        return invalidUseStreamAsResponseIndex;
    }
    @Override
    public final String invalidUseStreamAsResponseIndex(final int index, final int available) {
        return String.format(getLoggingLocale(), invalidUseStreamAsResponseIndex$str(), index, available);
    }
    private static final String managementHttpServerAlreadyBuild = "WFLYDMHTTP0014: The ManagementHttpServer has already been built using this Builder.";
    protected String managementHttpServerAlreadyBuild$str() {
        return managementHttpServerAlreadyBuild;
    }
    @Override
    public final IllegalStateException managementHttpServerAlreadyBuild() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), managementHttpServerAlreadyBuild$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noRealmOrSSLContext = "WFLYDMHTTP0015: No SecurityRealm or SSLContext has been provided.";
    protected String noRealmOrSSLContext$str() {
        return noRealmOrSSLContext;
    }
    @Override
    public final IllegalStateException noRealmOrSSLContext() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noRealmOrSSLContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmNotReadyForSecuredManagementHandler = "WFLYDMHTTP0016: Your Application Server is running. However you have not yet added any users to be able to access the HTTP management interface. To add a new user execute the %s script within the bin folder of your WildFly installation and enter the requested information. By default the realm name used by WildFly is 'ManagementRealm' and this is already selected by default by the add-user tool.";
    protected String realmNotReadyForSecuredManagementHandler$str() {
        return realmNotReadyForSecuredManagementHandler;
    }
    @Override
    public final String realmNotReadyForSecuredManagementHandler(final String scriptFile) {
        return String.format(getLoggingLocale(), realmNotReadyForSecuredManagementHandler$str(), scriptFile);
    }
}
