/*
 * JBoss, Home of Professional Open Source
 *
 * Copyright 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.picketlink.common.util.StringUtil;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import java.security.acl.Group;
import java.util.List;
import java.util.Map;
import org.picketlink.identity.federation.bindings.wildfly.ServiceProviderSAMLContext;

/**
 * Login Module that is capable of dealing with SAML2 cases
 * <p>
 * The password sent to this module should be {@link ServiceProviderSAMLContext#EMPTY_PASSWORD}
 * </p>
 * <p>
 * The username is available from {@link ServiceProviderSAMLContext#getUserName()} and roles is available from
 * {@link ServiceProviderSAMLContext#getRoles()}. If the roles is null, then plugged in login modules in the stack have to
 * provide the roles.
 * </p>
 *
 * @author Anil.Saldhana@redhat.com
 * @since Feb 13, 2009
 */
public class SAML2LoginModule extends UsernamePasswordLoginModule {

    protected String groupName = "Roles";

    /*
     * (non-Javadoc)
     *
     * @see org.jboss.security.auth.spi.AbstractServerLoginModule#initialize(javax.security.auth.Subject,
     * javax.security.auth.callback.CallbackHandler, java.util.Map, java.util.Map)
     */
    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        String groupNameStr = (String) options.get("groupPrincipalName");
        if (StringUtil.isNotNull(groupNameStr)) {
            groupName = groupNameStr.trim();
        }
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        Group group = new SimpleGroup(groupName);
        List<String> roles = ServiceProviderSAMLContext.getRoles();

        if (roles != null) {
            for (String role : roles) {
                group.addMember(new SimplePrincipal(role));
            }
        }
        return new Group[] { group };
    }

    @Override
    protected String getUsersPassword() throws LoginException {
        return "EMPTY_STR";
    }
}